<?php
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}

$id_usuario = $_SESSION['idusuario'];
$sucursal_id = $_SESSION['sucursal'] ?? null;
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d'); // Formato correcto para MySQL
$time_actual = date("H:i:s");

// Conexión a la base de datos
if (!$conn) {
    echo json_encode(["error" => "Error de conexión a la base de datos."]);
    exit();
}

// Obtén el número enviado por AJAX
$number = $_POST['number'] ?? 0;
$valor = $_POST['valor'] ?? 0; // Asegúrate de obtener el valor del formulario o AJAX

if (!$number) {
    echo json_encode(["error" => "Número no proporcionado."]);
    exit();
}

$suma_valor = 0;
$cupo_maximo = 0;
$extra_cupo = 0;
$cupo_activo = 0;

// Consultar cupo máximo de sucursal
$query = "SELECT cupo FROM tbr_sucursal WHERE idsucursal = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $sucursal_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
if ($row = mysqli_fetch_assoc($result)) {
    $cupo_maximo = $row['cupo'];
}
mysqli_stmt_close($stmt);

// Consultar extra_cupo del usuario
$query = "SELECT extra_cupo, cupo_activo FROM tbr_usuario WHERE cupo_activo = 1 AND condicion = 1 AND idusuario = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_usuario);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
if ($row = mysqli_fetch_assoc($result)) {
    $extra_cupo = $row['extra_cupo'];
    $cupo_activo = $row['cupo_activo'];
}
mysqli_stmt_close($stmt);

// Consultar el total apostado hasta ahora
$query = "SELECT IFNULL(SUM(valor), 0) AS suma_valor 
          FROM tbr_ticket 
          WHERE fecha = '$fecha_actual' AND condicion = 1 AND numero = ? AND id_usuario = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "ii", $number, $id_usuario);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
if ($row = mysqli_fetch_assoc($result)) {
    $suma_valor = $row['suma_valor'];
}
mysqli_stmt_close($stmt);
$cupo_disponible = 0;
$total_apuesta = $suma_valor + $valor;
$cupo_disponible = $cupo_maximo;
$cupo_formant = "$" . number_format($cupo_maximo, 2, '.', ',');  // Ejemplo de formato $1,000.50
$cuposuma = $cupo_disponible + $extra_cupo;
if ($total_apuesta > $cuposuma) {
  echo json_encode([
    "error" => "Cupo_no_disponible",
    "mensaje" => "No puedes superar el cupo máximo de $cuposuma con el valor ingresado."
]);
exit();

}

// Si pasa la validación, enviar respuesta exitosa
echo json_encode(["success" => "Cupo disponible", "cupo_maximo" => $cupo_maximo, "cupo_restante" => ($cupo_maximo + $extra_cupo - ($suma_valor + $valor))]);

mysqli_close($conn);
?>
