<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Apuestas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        /* Personalización de colores para cada pestaña */
        .nav-link.dos-cifras-tab {
            background-color: rgba(255, 204, 0, 0.3);
            color: #000;
        }

        .nav-link.tres-cifras-tab {
            background-color: #007bff;
            color: #fff;
        }

        .nav-link.cuatro-cifras-tab {
            background-color: #28a745;
            color: #fff;
        }

        /* Cambiar el color de la pestaña activa */
        .nav-link.active.dos-cifras-tab {
            background-color: rgba(255, 204, 0, 0.5); /* Fondo más oscuro para activa */
        }

        .nav-link.active.tres-cifras-tab {
            background-color: #0056b3; /* Fondo más oscuro para activa */
        }

        .nav-link.active.cuatro-cifras-tab {
            background-color: #218838; /* Fondo más oscuro para activa */
        }

        /* Personalización del área de contenido */
        .tab-pane.dos-cifras {
            background-color: rgba(255, 204, 0, 0.2); /* Fondo amarillo suave */
            border: 1px solid #ffcc00; /* Borde amarillo */
        }

        .tab-pane.tres-cifras {
            background-color: rgba(0, 123, 255, 0.2); /* Fondo azul suave */
            border: 1px solid #007bff; /* Borde azul */
        }

        .tab-pane.cuatro-cifras {
            background-color: rgba(40, 167, 69, 0.2); /* Fondo verde suave */
            border: 1px solid #28a745; /* Borde verde */
        }

        /* Cambiar el color de las pestañas activas en el área de contenido */
        .tab-pane.active.dos-cifras {
            background-color: rgba(255, 204, 0, 0.5); /* Fondo amarillo más fuerte */
        }

        .tab-pane.active.tres-cifras {
            background-color: rgba(0, 123, 255, 0.4); /* Fondo azul más fuerte */
        }

        .tab-pane.active.cuatro-cifras {
            background-color: rgba(40, 167, 69, 0.4); /* Fondo verde más fuerte */
        }

        /* Personalización de los campos de entrada (inputs) */
        .tab-pane input.form-control {
            background-color: #fff; /* Fondo blanco para el input */
            border: 1px solid #ccc; /* Borde gris claro */
        }

        /* Cambiar el color del borde en los campos de entrada */
        .tab-pane input.form-control:focus {
            border-color: rgba(255, 204, 0, 0.5); /* Borde amarillo para Dos Cifras */
        }

        .tab-pane.tres-cifras input.form-control:focus {
            border-color: #007bff; /* Borde azul para Tres Cifras */
        }

        .tab-pane.cuatro-cifras input.form-control:focus {
            border-color: #28a745; /* Borde verde para Cuatro Cifras */
        }
        
        /* Fondo de la tarjeta 'card-body' */
        .tab-pane.dos-cifras .card-body {
            background-color: rgba(255, 204, 0, 0.2); /* Fondo suave amarillo para Dos Cifras */
        }

        .tab-pane.tres-cifras .card-body {
            background-color: rgba(0, 123, 255, 0.2); /* Fondo suave azul para Tres Cifras */
        }

        .tab-pane.cuatro-cifras .card-body {
            background-color: rgba(40, 167, 69, 0.2); /* Fondo suave verde para Cuatro Cifras */
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <h2 class="text-center">Registro de Apuestas</h2>

    <!-- Pestañas de Bootstrap -->
    <ul class="nav nav-tabs" id="myTab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active dos-cifras-tab" id="dos-cifras-tab" data-bs-toggle="tab" data-bs-target="#dos-cifras" type="button" role="tab">Dos Cifras</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link tres-cifras-tab" id="tres-cifras-tab" data-bs-toggle="tab" data-bs-target="#tres-cifras" type="button" role="tab">Tres Cifras</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link cuatro-cifras-tab" id="cuatro-cifras-tab" data-bs-toggle="tab" data-bs-target="#cuatro-cifras" type="button" role="tab">Cuatro Cifras</button>
        </li>
    </ul>

    <div class="tab-content mt-3" id="myTabContent">
        <!-- Pestaña Dos Cifras -->
        <div class="tab-pane fade show active dos-cifras" id="dos-cifras" role="tabpanel">
            <div class="card border-primary mb-3">
                <div class="card-body">
                    <form>
                        <div class="mb-3">
                            <label for="number-2cifras" class="form-label">Número (2 cifras):</label>
                            <input class="form-control" id="number-2cifras" type="number" placeholder="Ingrese número (00-99)" min="0" max="99" required>
                        </div>
                        <div class="mb-3">
                            <label for="valor-2cifras" class="form-label">Valor:</label>
                            <input class="form-control" id="valor-2cifras" type="number" placeholder="Ingrese Valor" min="0.50" step="0.01" required>
                        </div>
                        <button type="submit" class="btn btn-success w-100">Cargar</button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Pestaña Tres Cifras -->
        <div class="tab-pane fade tres-cifras" id="tres-cifras" role="tabpanel">
            <div class="card border-primary mb-3">
                <div class="card-body">
                    <form>
                        <div class="mb-3">
                            <label for="number-3cifras" class="form-label">Número (3 cifras):</label>
                            <input class="form-control" id="number-3cifras" type="number" placeholder="Ingrese número (000-999)" min="0" max="999" required>
                        </div>
                        <div class="mb-3">
                            <label for="valor-3cifras" class="form-label">Valor:</label>
                            <input class="form-control" id="valor-3cifras" type="number" placeholder="Ingrese Valor" min="0.50" step="0.01" required>
                        </div>
                        <button type="submit" class="btn btn-success w-100">Cargar</button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Pestaña Cuatro Cifras -->
        <div class="tab-pane fade cuatro-cifras" id="cuatro-cifras" role="tabpanel">
            <div class="card border-primary mb-3">
                <div class="card-body">
                    <form>
                        <div class="mb-3">
                            <label for="number-4cifras" class="form-label">Número (4 cifras):</label>
                            <input class="form-control" id="number-4cifras" type="number" placeholder="Ingrese número (0000-9999)" min="0" max="9999" required>
                        </div>
                        <div class="mb-3">
                            <label for="valor-4cifras" class="form-label">Valor:</label>
                            <input class="form-control" id="valor-4cifras" type="number" placeholder="Ingrese Valor" min="0.50" step="0.01" required>
                        </div>
                        <button type="submit" class="btn btn-success w-100">Cargar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

</body>
</html>
