<?php
// usuarios_clear_ip.php — borra la IP (ip_permitida = NULL)
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
session_start();

require_once __DIR__ . '/conex.php';
/** @var mysqli $db */
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { echo json_encode(['success'=>false,'message'=>'Sin conexión']); exit; }

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
if ($id <= 0) { echo json_encode(['success'=>false,'message'=>'ID inválido']); exit; }

$stmt = $db->prepare("UPDATE tbr_usuario SET ip_permitida = NULL WHERE idusuario = ?");
$stmt->bind_param('i', $id);
$ok = $stmt->execute();
$stmt->close();

echo json_encode(['success' => $ok ? true : false]);
