<?php
session_start();
include("conex.php");
$usuario = $_SESSION['usuario'];
$idusuario = $_SESSION['idusuario'];
$sucursal = $_SESSION['sucursal'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Gestión</title>
    <link rel="shortcut icon" href="../resources/img/crud.ico">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            background-color: #f4f6f9;
            padding-top: 60px;
            overflow-x: hidden; /* Evitar desplazamiento horizontal */
        }

        .topbar {
            width: 100%;
            height: 60px;
            background: #343a40;
            color: white;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
        }

        .sidebar {
            width: 250px;
            background: #343a40;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 60px;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            transition: width 0.3s;
            z-index: 1000; /* Asegura que el sidebar tenga un z-index menor que el modal */
        }

        .main-content {
            margin-left: 250px;
            padding: 1rem;
            transition: margin-left 0.3s; /* Para cuando se colapse el sidebar */
            z-index: 100; /* Asegura que el contenido principal no se desorganice al mostrar el modal */
        }

        .modal-backdrop {
            z-index: 1040 !important; /* Asegura que el fondo del modal esté por encima del sidebar */
        }

        .modal-dialog {
            z-index: 1050 !important; /* Asegura que el contenido del modal esté por encima del sidebar */
        }

        .sidebar.collapsed {
            width: 80px;
        }

        .sidebar.collapsed a span {
            display: none;
        }

        .toggle-btn {
            cursor: pointer;
            margin-right: 10px;
        }

        /* Ajustar la visibilidad del sidebar al colapsar */
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 12px;
            display: flex;
            align-items: center;
            width: 100%;
            transition: background 0.3s, transform 0.2s;
            border-radius: 8px;
        }

        .sidebar .submenu {
            display: none;
            padding-left: 20px;
            list-style: none;
            margin: 0;
            font-size: 14px;
        }

        .sidebar .submenu li {
            padding: 8px 0;
        }

        .sidebar a:hover, .sidebar a.active {
            background: #495057;
            transform: scale(1.05);
        }
		
		/* Estilos del interruptor */
	.switch {
	  position: relative;
	  display: inline-block;
	  width: 60px;
	  height: 34px;
	}

	.switch input {
	  opacity: 0;
	  width: 0;
	  height: 0;
	}
	.slider {
	  position: absolute;
	  cursor: pointer;
	  top: 0;
	  left: 0;
	  right: 0;
	  bottom: 0;
	  background-color: #ccc;
	  transition: 0.4s;
	  border-radius: 34px;
	}

	.slider:before {
	  position: absolute;
	  content: "";
	  height: 26px;
	  width: 26px;
	  border-radius: 50%;
	  left: 4px;
	  bottom: 4px;
	  background-color: white;
	  transition: 0.4s;
	}

	input:checked + .slider {
	  background-color: #4CAF50;
	}

	input:checked + .slider:before {
	  transform: translateX(26px);
	}

    </style>
</head>
<body>

<!-- Barra Superior -->
<div class="topbar">
    <div class="toggle-btn" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </div>
    <span style="margin-left: 20px;">Sistema de Gestión</span>
    <div class="info">
        <span><?php echo $usuario; ?></span>
        <span id="fechaActual"></span>
        <span id="horaActual"></span>
    </div>
</div>

<!-- Sidebar -->
<?php include("menu.php"); ?>

<!-- Contenido Principal -->
<div class="main-content">
    <div class="col-lg-12 col-md-12">
        <div class="panel panel-WHITE">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-md-12"> 
                        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#agregar">Agregar Usuario</button>
                    </div>
                    
                    <div class="col-md-12">    
                        <table id="usuar" class="table table-hover" cellspacing="0" width="100%">
                            <thead>
                                <tr class="info">                                                                                                 
                                    <th>Usuario</th>
                                    <th>Sucursal</th>
                                    <th>Cupo Extra 2 C.</th>
                                    <th>Cupo Extra 3 C.</th>
                                    <th>Cupo Extra 4 C.</th>
                                    <th>Hora Inicio Anulación</th>                                                                                             
                                    <th>Hora Fin Anulación</th> 									
                                    <th>Activo</th>
									<th>IP</th>
                                    <th>Acción</th>                                  
                                                                      
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Aquí se carga dinámicamente el contenido -->
                            </tbody>
                        </table>        
                    </div>                         
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="agregar" tabindex="-1" aria-labelledby="agregar_empresaLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="agregarLabel">Agregar nuevo usuario</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
			
            <div class="modal-body">
                <!-- Formulario de agregar usuario -->
                <form id="formAgregarUsuario">
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="sucursal">Sucursal*</label>
                                <select class="form-control" id="sucursal" name="sucursal" required></select>
                            </div>
                        </div>
						<div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="rol">Rol*</label>
								<select name="rol" id="rol" class="form-control" placeholder="Seleccionar rol..." required></select>                                
                            </div>
                        </div>                        
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="hora_inicio">Hora Inicio Anulación*</label>
                                <input type="time" class="form-control" id="hora_inicio" name="hora_inicio" required min="00:00" max="23:59">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="hora_fin">Hora Fin Anulación*</label>
                                <input type="time" class="form-control" id="hora_fin" name="hora_fin" required min="00:00" max="23:59">
                            </div>
                        </div>
						<div class="col-lg-4 col-md-4">
                            <div class="form-group">
                                <label for="cupo">Cupo Extra 2 C</label>
                                <input type="number" class="form-control" id="cupo" name="cupo" required>
                            </div>
                        </div>	
						<div class="col-lg-4 col-md-4">
                            <div class="form-group">
                                <label for="cupo3">Cupo Extra 3 C</label>
                                <input type="number" class="form-control" id="cupo3" name="cupo3" required>
                            </div>
                        </div>	
						<div class="col-lg-4 col-md-4">
                            <div class="form-group">
                                <label for="cupo4">Cupo Extra 4 C</label>
                                <input type="number" class="form-control" id="cupo4" name="cupo4" required>
                            </div>
                        </div>	
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="usuario">Usuario*</label>
                                <input type="text" class="form-control" id="usuario" name="usuario" required>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="clave">Clave*</label>
								<div class="input-group">
									<input type="password" class="form-control" id="clave" name="clave" required minlength="6">
									<button class="btn btn-outline-secondary" type="button" onclick="togglePassword()">
										<i class="fa fa-eye" id="iconoClave"></i>
									</button>
								</div>
								<small class="form-text text-muted">Mínimo 6 caracteres.</small>
							</div>
						</div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" onclick="guardar()">Guardar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal para editar -->
<div id="modalEditar" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalEditarLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalEditarLabel">Editar Usuario</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>                    
            </div>
            <div class="modal-body">
                <form id="formEditar">
					<div class="row">
						<input type="hidden" id="idusuario_a" name="idusuario_a">
						
						<div class="col-lg-8 col-md-8">
                            <div class="form-group">
                                <label for="sucursal">Sucursal*</label>
                                <select class="form-control" id="sucursal_a" name="sucursal_a" required></select>
                            </div>
                        </div>
						
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="hora_inicio_a">Hora de Inicio Anulación</label>
								<input type="time" class="form-control" id="hora_inicio_a" name="hora_inicio_a">
							</div>
						</div>
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="hora_fin_a">Hora de Fin Anulación</label>
								<input type="time" class="form-control" id="hora_fin_a" name="hora_fin_a">
							</div>
						</div>
						<div class="col-lg-4 col-md-4">
							<div class="form-group">
								<label for="cupo">Cupo Extra 2 C</label>
								<input type="number" class="form-control" id="cupo_a" name="cupo_a">
							</div>
						</div>
						<div class="col-lg-4 col-md-4">
                            <div class="form-group">
                                <label for="cupo3_a">Cupo Extra 3 C</label>
                                <input type="number" class="form-control" id="cupo3_a" name="cupo3_a" required>
                            </div>
                        </div>	
						<div class="col-lg-4 col-md-4">
                            <div class="form-group">
                                <label for="cupo4_a">Cupo Extra 4 C</label>
                                <input type="number" class="form-control" id="cupo4_a" name="cupo4_a" required>
                            </div>
                        </div>						
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="usuario">Usuario</label>
								<input type="text" class="form-control" id="usuario_a" name="usuario_a">
							</div>
						</div>
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="clave">Clave*</label>
								<div class="input-group">
									<input type="password" class="form-control" id="clave_a" name="clave_a" required minlength="6">
									<button class="btn btn-outline-secondary" type="button" onclick="togglePasswordAlt()">
										<i class="fa fa-eye" id="iconoClave"></i>
									</button>
								</div>
								<small class="form-text text-muted">Mínimo 6 caracteres.</small>
							</div>
						</div>
					</div>					
                </form>
            </div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
				<button type="submit" class="btn btn-primary" onclick="actualizar()">Guardar Cambios</button>
			</div>
        </div>
    </div>
</div>

<!-- Modal para editar administrador-->
<div id="modalEditar_ad" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalEditarLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalEditarLabel">Editar Usuario Administrador</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>                    
            </div>
            <div class="modal-body">
                <form id="formEditar">
					<div class="row">
						<input type="hidden" id="idusuario_ad" name="idusuario_ad">				
												
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="usuario">Usuario</label>
								<input type="text" class="form-control" id="usuario_ad" name="usuario_ad">
							</div>
						</div>
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="clave">Clave*</label>
								<div class="input-group">
									<input type="password" class="form-control" id="clave_ad" name="clave_ad" required minlength="6">
									<button class="btn btn-outline-secondary" type="button" onclick="togglePasswordAltad()">
										<i class="fa fa-eye" id="iconoClave"></i>
									</button>
								</div>
								<small class="form-text text-muted">Mínimo 6 caracteres.</small>
							</div>
						</div>
					</div>					
                </form>
            </div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
				<button type="submit" class="btn btn-primary" onclick="actualizar_ad()">Guardar Cambios</button>
			</div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- Asegúrate de que los scripts necesarios estén cargados -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
	<script src="../../resources/media/js/jquery.dataTables.min.js"></script>
	<script src="../../resources/media/js/dataTables.bootstrap.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
	<script src="../../resources/js/menu_usuarios.js"></script>
<script>
    // Función para actualizar la fecha y hora en la barra superior
    function actualizarHora() {
        const ahora = new Date();
        const opcionesFecha = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
        const opcionesHora = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
        document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opcionesFecha);
        document.getElementById('horaActual').textContent = ahora.toLocaleTimeString('es-ES', opcionesHora);
    }
    setInterval(actualizarHora, 1000);
    actualizarHora();
    
    // Función para alternar la visibilidad del sidebar
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const mainContent = document.getElementById('mainContent');
        sidebar.classList.toggle('collapsed');
        mainContent.style.marginLeft = sidebar.classList.contains('collapsed') ? '80px' : '250px';
    }
	
	// Función para mostrar/ocultar la contraseña del campo "clave"
	function togglePassword() {
		let input = document.getElementById("clave");
		let icon = document.getElementById("iconoClave");

		if (input.type === "password") {
			input.type = "text";
			icon.classList.remove("fa-eye");
			icon.classList.add("fa-eye-slash");
		} else {
			input.type = "password";
			icon.classList.remove("fa-eye-slash");
			icon.classList.add("fa-eye");
		}
	}

	// Función para mostrar/ocultar la contraseña del campo "clave_a"
	function togglePasswordAlt() {
		let input = document.getElementById("clave_a");
		let icon = document.getElementById("iconoClave");

		if (input.type === "password") {
			input.type = "text";
			icon.classList.remove("fa-eye");
			icon.classList.add("fa-eye-slash");
		} else {
			input.type = "password";
			icon.classList.remove("fa-eye-slash");
			icon.classList.add("fa-eye");
		}
	}
	
	// Función para mostrar/ocultar la contraseña del campo "clave_ad"
	function togglePasswordAltad() {
		let input = document.getElementById("clave_ad");
		let icon = document.getElementById("iconoClave");

		if (input.type === "password") {
			input.type = "text";
			icon.classList.remove("fa-eye");
			icon.classList.add("fa-eye-slash");
		} else {
			input.type = "password";
			icon.classList.remove("fa-eye-slash");
			icon.classList.add("fa-eye");
		}
	}

	
	//funcion para desactivar y activar usuario	
	$(document).on("change", ".toggle-switch", function () {
		let switchElement = $(this);
		let idusuario = switchElement.data("id");
		let estado_actual = switchElement.data("estado");
		
		$.ajax({
			url: "actulizar_estado.php", // Archivo que actualizará el estado
			type: "POST",
			data: { idusuario: idusuario, estado: estado_actual },
			dataType: "json",
			success: function (response) {
				if (response.success) {
					// Recargar la tabla automáticamente
					$("#usuar").DataTable().ajax.reload(null, false);

					// Cambiar el estado en el checkbox
					//switchElement.data("estado", response.nuevo_estado);
				} //else {
					//$('#error-msg').text("Error al actualizar el estado.").show();
					//alert("Error al actualizar el estado.");
				//}
			},
			error: function () {
				$('#error-msg').text("Error de conexión con el servidor.").show();
				//alert("Error de conexión con el servidor.");
			}
		});
	});
	
	//funcion para desactivar y activar cupo 2c	
	$(document).on("change", ".toggle-switch2", function () {
		let switchElement = $(this);
		let idusuario = switchElement.data("id");
		let estado_actual = switchElement.data("estado");
		
		$.ajax({
			url: "activar_cupo.php", // Archivo que actualizará el estado
			type: "POST",
			data: { idusuario: idusuario, estado: estado_actual },
			dataType: "json",
			success: function (response) {
				if (response.success) {
					// Recargar la tabla automáticamente
					$("#usuar").DataTable().ajax.reload(null, false);

					// Cambiar el estado en el checkbox
					//switchElement.data("estado", response.nuevo_estado);
				} //else {
					//$('#error-msg').text("Error al actualizar el estado.").show();
					//alert("Error al actualizar el estado.");
				//}
			},
			error: function () {
				$('#error-msg').text("Error de conexión con el servidor.").show();
				//alert("Error de conexión con el servidor.");
			}
		});
	});
	
	//funcion para desactivar y activar cupo 3c	
	$(document).on("change", ".toggle-switch3", function () {
		let switchElement = $(this);
		let idusuario = switchElement.data("id");
		let estado_actual = switchElement.data("estado");
		
		$.ajax({
			url: "activar_cupo3.php", // Archivo que actualizará el estado
			type: "POST",
			data: { idusuario: idusuario, estado: estado_actual },
			dataType: "json",
			success: function (response) {
				if (response.success) {
					// Recargar la tabla automáticamente
					$("#usuar").DataTable().ajax.reload(null, false);

					// Cambiar el estado en el checkbox
					//switchElement.data("estado", response.nuevo_estado);
				} //else {
					//$('#error-msg').text("Error al actualizar el estado.").show();
					//alert("Error al actualizar el estado.");
				//}
			},
			error: function () {
				$('#error-msg').text("Error de conexión con el servidor.").show();
				//alert("Error de conexión con el servidor.");
			}
		});
	});
	
	//funcion para desactivar y activar cupo 4c	
	$(document).on("change", ".toggle-switch4", function () {
		let switchElement = $(this);
		let idusuario = switchElement.data("id");
		let estado_actual = switchElement.data("estado");
		
		$.ajax({
			url: "activar_cupo4.php", // Archivo que actualizará el estado
			type: "POST",
			data: { idusuario: idusuario, estado: estado_actual },
			dataType: "json",
			success: function (response) {
				if (response.success) {
					// Recargar la tabla automáticamente
					$("#usuar").DataTable().ajax.reload(null, false);

					// Cambiar el estado en el checkbox
					//switchElement.data("estado", response.nuevo_estado);
				} //else {
					//$('#error-msg').text("Error al actualizar el estado.").show();
					//alert("Error al actualizar el estado.");
				//}
			},
			error: function () {
				$('#error-msg').text("Error de conexión con el servidor.").show();
				//alert("Error de conexión con el servidor.");
			}
		});
	});
		
	//funcion para bloquear usuario	
	$(document).ready(function () {
    $(document).on("click", ".toggle-condicion", function () {
        let boton = $(this);
        let idusuario = boton.data("id");

        Swal.fire({
            title: "¿Estás seguro?",
            text: "El usuario será eliminado.",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#d33",
            cancelButtonColor: "#3085d6",
            confirmButtonText: "Sí, eliminar",
            cancelButtonText: "Cancelar"
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "actualizar_condicion.php",
                    type: "POST",
                    data: { idusuario: idusuario },
                    dataType: "json",
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: "success",
                                title: "Usuario eliminado",
                                text: "El usuario ha sido eliminado correctamente.",
                                timer: 3000
                            });

                            // Recargar la tabla automáticamente
                            $("#usuar").DataTable().ajax.reload(null, false);
                        } else {
                            Swal.fire("Error", "No se pudo eliminar.", "error");
                        }
                    },
                    error: function () {
                        Swal.fire("Error", "Error de conexión con el servidor.", "error");
                    }
                });
            }
        });
    });
});

	//Funcion sucursal seleccion		
	$(document).ready(function() 
	{
		$.ajax({
			type: "POST",
			url: "datos.php?Accion=GetSucursal",
			
			success: function(response)
			{
				$('#sucursal').html(response).fadeIn();
			}
		}); 
	});
	
	//Funcion sucursal seleccion		
	$(document).ready(function() 
	{
		$.ajax({
			type: "POST",
			url: "datos.php?Accion=GetSucursal",
			
			success: function(response)
			{
				$('#sucursal_a').html(response).fadeIn();
			}
		}); 
	});
	
    // Función para guardar el usuario (aquí debes agregar la lógica de envío del formulario)
    function guardar() 
	{
		var sucursal = $('#sucursal').val();
		var rol = $('#rol').val();
		var cupo = $('#cupo').val();
		var cupo3 = $('#cupo3').val();
		var cupo4 = $('#cupo4').val();
		var hora_inicio = $('#hora_inicio').val();
		var hora_fin = $('#hora_fin').val();
		var usuario = $('#usuario').val();
		var clave = $('#clave').val();
		//alert (rol);
		// Validar que todos los campos estén llenos
		if (!sucursal || !rol || !hora_inicio || !hora_fin || !usuario || !clave) {
			Swal.fire("Error","Por favor, complete todos los campos obligatorios.", "error");
			return;
		}

		// Validar que la hora de inicio sea menor que la hora de fin
		if (hora_inicio >= hora_fin) {
			Swal.fire("Error","La hora de inicio debe ser menor que la hora de fin.", "error");
			return;
		}

		// Enviar los datos por AJAX
		$.ajax({
			url: 'guardar_usuario.php', // Reemplaza con la URL correcta
			type: 'POST',
			data: {
				sucursal: sucursal,
				rol: rol,
				cupo: cupo,
				cupo3: cupo3,
				cupo4: cupo4,
				hora_inicio: hora_inicio,
				hora_fin: hora_fin,
				usuario: usuario,
				clave: clave
			},
			beforeSend: function () {
				// Puedes deshabilitar el botón para evitar envíos múltiples
				$('button[onclick="guardar()"]').prop('disabled', true);
			},
			success: function (response) {
				//alert(response);
				Swal.fire({
							title: 'Éxito',
							text: 'El usuario fue guardado correctamente.',
							icon: 'success',
							confirmButtonText: 'OK',
							timer: 2000
						}).then((result) => {
							if (result.isConfirmed || result.isDismissed) {
								location.reload(); // Recargar la página después de cerrar la alerta
							}
						});				
			},
			error: function (xhr, status, error) {
				
				Swal.fire("Error","Ocurrió un error al guardar los datos.", "error");
				console.error(error);
			},
			complete: function () {
				$('button[onclick="guardar()"]').prop('disabled', false); // Rehabilitar botón
			}
		});
	}
	
	//funcion para editar registro de usuario
	$(document).on('click', '.toggle-editar', function() 
	{
		var idusuario_a = $(this).data('id');
		var usuario_a = $(this).data('usuario');
		var clave_a = $(this).data('clave');
		var sucursal_a = $(this).data('sucursal');
		var cupo_a = $(this).data('cupo');
		var cupo3_a = $(this).data('cupo3');
		var cupo4_a = $(this).data('cupo4');
		var hora_inicio_a = $(this).data('hora_inicio_a');
		var hora_fin_a = $(this).data('hora_fin_a');
        //alert (clave_a);
		// Cargar los datos en un formulario de edición o modal
		$('#idusuario_a').val(idusuario_a);
		$('#usuario_a').val(usuario_a);
		$('#clave_a').val(clave_a);
		$('#sucursal_a').val(sucursal_a);
		$('#cupo_a').val(cupo_a);
		$('#cupo3_a').val(cupo3_a);
		$('#cupo4_a').val(cupo4_a);
		$('#hora_inicio_a').val(hora_inicio_a);
		$('#hora_fin_a').val(hora_fin_a);

		// Mostrar el modal o formulario
		$('#modalEditar').modal('show');
	});

	function actualizar() {
		// Obtener los valores de los campos
		var idusuario_a = $('#idusuario_a').val();
		var usuario_a = $('#usuario_a').val();
		var sucursal_a = $('#sucursal_a').val();
		var cupo_a = $('#cupo_a').val();
		var cupo3_a = $('#cupo3_a').val();
		var cupo4_a = $('#cupo4_a').val();
		var hora_inicio_a = $('#hora_inicio_a').val();
		var hora_fin_a = $('#hora_fin_a').val();
		var clave_a = $('#clave_a').val();
		
		//alert(usuario_a);
		
		// Validar que todos los campos estén llenos
		if (!sucursal_a || !hora_inicio_a || !hora_fin_a || !usuario_a || !clave_a) {
			Swal.fire("Error", "Por favor, complete todos los campos obligatorios.", "error");
			return;
		}

		// Validar que la hora de inicio sea menor que la hora de fin
		if (hora_inicio_a >= hora_fin_a) {
			Swal.fire("Error", "La hora de inicio debe ser menor que la hora de fin.", "error");
			return;
		}

		// Enviar los datos por AJAX
		$.ajax({
			url: 'guardar_edicion.php', // Reemplaza con la URL correcta
			type: 'POST',
			data: {
				idusuario_a: idusuario_a,
				sucursal_a: sucursal_a,
				cupo_a: cupo_a,
				cupo3_a: cupo3_a,
				cupo4_a: cupo4_a,
				hora_inicio_a: hora_inicio_a,
				hora_fin_a: hora_fin_a,
				usuario_a: usuario_a,
				clave_a: clave_a
			},
			beforeSend: function () {
				// Deshabilitar el botón para evitar envíos múltiples
				$('button[onclick="actualizar()"]').prop('disabled', true);
			},
			success: function (response) {
				//alert(response);
				Swal.fire({
							title: 'Éxito',
							text: 'El usuario fue actualizado correctamente.',
							icon: 'success',
							confirmButtonText: 'OK',
							timer: 2000
						}).then((result) => {
							if (result.isConfirmed || result.isDismissed) {
								location.reload(); // Recargar la página después de cerrar la alerta
							}
						});

			},
			error: function (xhr, status, error) {
				Swal.fire("Error", "Ocurrió un error al guardar los datos.", "error");
				console.error(error);
			},
			complete: function () {
				// Rehabilitar el botón después de completar la solicitud
				$('button[onclick="actualizar()"]').prop('disabled', false);
			}
		});
	}
	//funcio para cerra sesion
	function cerrar() {
        Swal.fire({
            title: '¿Estás seguro?',
            text: '¿Deseas cerrar sesión?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, cerrar sesión',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('../../controllers/usuario.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: new URLSearchParams({ boton: 'cerrar' })
                })
                .then(response => response.ok ? location.href = '../administracion.php' : Promise.reject(response.statusText))
                .catch(error => Swal.fire('Error', 'Hubo un error al cerrar sesión: ' + error, 'error'));
            }
        });
    }
	//Funcion rol seleccion		
	$(document).ready(function() 
	{
		$.ajax({
			type: "POST",
			url: "datos.php?Accion=GetRol",
			
			success: function(response)
			{
				$('#rol').html(response).fadeIn();
			}
		}); 
	});
	
	//funcion para editar registro de usuario
	$(document).on('click', '.toggle-editar_ad', function() 
	{
		var idusuario_ad = $(this).data('id');
		var usuario_ad = $(this).data('usuario');
		var clave_ad = $(this).data('clave');
		

		// Cargar los datos en un formulario de edición o modal
		$('#idusuario_ad').val(idusuario_ad);
		$('#usuario_ad').val(usuario_ad);
		$('#clave_ad').val(clave_ad);
		

		// Mostrar el modal o formulario
		$('#modalEditar_ad').modal('show');
	});
	
	//funcion actualizar usuario administracion
	function actualizar_ad() {
		// Obtener los valores de los campos
		var idusuario_ad = $('#idusuario_ad').val();
		var usuario_ad = $('#usuario_ad').val();		
		var clave_ad = $('#clave_ad').val();
		
		//alert(usuario_a);
		
		// Validar que todos los campos estén llenos
		if (!usuario_a || !clave_a) {
			Swal.fire("Error", "Por favor, complete todos los campos obligatorios.", "error");
			return;
		}

		// Enviar los datos por AJAX
		$.ajax({
			url: 'guardar_edicionad.php', // Reemplaza con la URL correcta
			type: 'POST',
			data: {
				idusuario_ad: idusuario_ad,				
				usuario_ad: usuario_ad,
				clave_ad: clave_ad
			},
			beforeSend: function () {
				// Deshabilitar el botón para evitar envíos múltiples
				$('button[onclick="actualizar_ad()"]').prop('disabled', true);
			},
			success: function (response) {
				//alert(response);
				Swal.fire({
							title: 'Éxito',
							text: 'El usuario fue actualizado correctamente.',
							icon: 'success',
							confirmButtonText: 'OK',
							timer: 2000
						}).then((result) => {
							if (result.isConfirmed || result.isDismissed) {
								location.reload(); // Recargar la página después de cerrar la alerta
							}
						});

			},
			error: function (xhr, status, error) {
				Swal.fire("Error", "Ocurrió un error al guardar los datos.", "error");
				console.error(error);
			},
			complete: function () {
				// Rehabilitar el botón después de completar la solicitud
				$('button[onclick="actualizar_ad()"]').prop('disabled', false);
			}
		});
	}
	// Requiere SweetAlert2 (CDN):
	// <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11">

	$('#usuar').on('click', '.btn-clear-ip', function () {
	  var $btn = $(this);
	  var id   = $btn.data('id');
	  var user = $btn.data('usuario') || '';
	  var ip   = $btn.data('ip') || '';

	  Swal.fire({
		icon: 'question',
		title: 'Borrar IP',
		html: '¿Deseas borrar la IP <b>' + (ip || '(vacía)') + '</b> del usuario <b>' + user + '</b>?',
		showCancelButton: true,
		confirmButtonText: 'Sí, borrar',
		cancelButtonText: 'Cancelar'
	  }).then(function (res) {
		if (!res.isConfirmed) return;

		$.post('usuarios_clear_ip.php', { id: id })
		  .done(function (r) {
			if (r && r.success) {
			  Swal.fire({ icon: 'success', title: 'IP borrada', timer: 1200, showConfirmButton: false });
			  // Recargar datos sin perder la página actual:
			  $('#usuar').DataTable().ajax.reload(null, false);
			} else {
			  Swal.fire({ icon: 'error', title: 'Error', text: (r && r.message) ? r.message : 'No se pudo borrar la IP' });
			}
		  })
		  .fail(function (xhr) {
			Swal.fire({ icon: 'error', title: 'Error', text: 'Fallo de red o servidor' });
		  });
	  });
	});

</script>
</body>
</html>
