<?php
require __DIR__ . '/autoload.php';
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\Printer;

// Nombre de la impresora compartida
$nombre_impresora = "POS";

try {
    $connector = new WindowsPrintConnector($nombre_impresora);
    $printer = new Printer($connector);
    $printer->setJustification(Printer::JUSTIFY_CENTER);

    // Ruta absoluta de la imagen
    $ruta_imagen = __DIR__ . "logo.PNG";

    // Verificar si la imagen existe
    if (!file_exists($ruta_imagen)) {
        throw new Exception("Error: La imagen no se encuentra en " . $ruta_imagen);
    }

    // Cargar e imprimir la imagen
   $logo = EscposImage::load($ruta_imagen, false);
   $printer->graphics($logo); // Usa graphics() en lugar de bitImage()

    //	Ahora vamos a imprimir un encabezado

	$printer->setTextSize(6, 1);
	$printer->text("\n"."ACIERTA" . "\n");
	$printer->text("\n"."YGANABET" . "\n");
	$printer->setTextSize(1, 1);
	$printer->text("ACIERTA Y GANA BET" . "\n");
	
	#La fecha también
	//date_default_timezone_set("America/Mexico_City");
	date_default_timezone_set('America/Guayaquil');
	$printer->text(date("Y-m-d H:i:s") . "\n");
	$printer->text("-----------------------------" . "\n");
	/*
	$printer->setJustification(Printer::JUSTIFY_LEFT);
	$printer->text("CANT  DESCRIPCION    P.U   P.T.\n");
	$printer->text("-----------------------------"."\n");
	/*
		Ahora vamos a imprimir los
		productos
	*/
		/*Alinear a la izquierda para la cantidad y el nombre*/
		/*$printer->setJustification(Printer::JUSTIFY_LEFT);
		$printer->text("Producto Galletas\n");
		$printer->text( "2  pieza         10.00 20.00   \n");
		$printer->text("Sabrtitas \n");
		$printer->text( "3  pieza         10.00 30.00   \n");
		$printer->text("Doritos \n");
		$printer->text( "5  pieza         10.00 50.00   \n");
	/*
		Terminamos de imprimir
		los productos, ahora va el total
	*/
	/*$printer->text("-----------------------------"."\n");
	$printer->setJustification(Printer::JUSTIFY_RIGHT);
	$printer->text("SUBTOTAL: $100.00\n");
	$printer->text("IVA: $16.00\n");
	$printer->text("TOTAL: $116.00\n");


	/*
		Podemos poner también un pie de página
	*/
	/*$printer->setJustification(Printer::JUSTIFY_CENTER);
	$printer->text("Muchas gracias por su compra\n");*/

    // Alimentar papel y cortar
    $printer->feed(2);
    $printer->cut();
    $printer->pulse();

    // Cerrar conexión con la impresora
    $printer->close();

} catch (Exception $e) {
    echo "Error de impresión: " . $e->getMessage();
}

?>
