<?php
session_start();
include("conex.php");
// Verifica si las variables de sesión están definidas
if (!isset($_SESSION['idusuario'], $_SESSION['usuario'], $_SESSION['sucursal'])) {
    header('Location: index.php');
    exit();
}

$idusuario = htmlspecialchars($_SESSION['idusuario']);
$usuario = htmlspecialchars($_SESSION['usuario']);
$sucursal_id = $_SESSION['sucursal'] ?? null;

if (!is_numeric($sucursal_id)) {
    die("ID de sucursal inválido");
}

if (!isset($conn) || $conn === null) {
    die("Error: No se pudo establecer la conexión a la base de datos.");
}

$query = "SELECT sucursal FROM tbr_sucursal WHERE idsucursal = ?";
$stmt = mysqli_prepare($conn, $query);

if ($stmt) {
    mysqli_stmt_bind_param($stmt, "i", $sucursal_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if ($row = mysqli_fetch_assoc($result)) {
        $sucursal = $row['sucursal'];
    } else {
        die("Sucursal no encontrada.");
    }

    mysqli_stmt_close($stmt);
} else {
    die("Error en la preparación de la consulta.");
}
// Consulta preparada para obtener los permisos de venta y pago del usuario
	$queryu = "SELECT venta, pago FROM tbr_usuario WHERE idusuario = ?";
	$stmtu = mysqli_prepare($conn, $queryu); // Usamos $queryu, no $query

	if ($stmtu) {
		mysqli_stmt_bind_param($stmtu, "i", $idusuario);
		mysqli_stmt_execute($stmtu);
		$resultu = mysqli_stmt_get_result($stmtu);
		
		if ($row = mysqli_fetch_assoc($resultu)) {
			$venta = $row['venta'];
			$pago = $row['pago'];
		} else {
			die("Usuario no encontrado");
		}
		
		mysqli_stmt_close($stmtu);
	} else {
		die("Error en la preparación de la consulta.");
	}

	// Si $venta es 0 o falso, redirigimos al usuario a pago.php
	if ($venta != 1) {
		header("Location: pago.php");
		exit; // Asegúrate de salir después de la redirección
	}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Gestión</title>
    <link rel="shortcut icon" href="../resources/img/crud.ico">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta2/dist/css/bootstrap-select.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
    <style>
        .form-control, .selectpicker, .btn {
            font-size: 2em;
            min-height: 2em;
        }
        body {
            background-color: #f4f6f9;
        }
        .sidebar {
            width: 250px;
            background: #343a40;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 15px;
            width: 100%;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: background 0.3s, transform 0.2s;
        }
        .sidebar a:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: scale(1.05);
            border-radius: 8px;
        }
        .sidebar .active {
            font-weight: bold;
            color: #17a2b8;
        }
        .main-content {
            margin-left: 150px;
            padding: 1rem;
        }
        .loader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            font-size: 20px;
            font-weight: bold;
            z-index: 2000;
        }
    </style>
</head>
<body>
    <nav class="sidebar" id="sidebar" style="width: 150px;">
        <ul class="nav flex-column text-center">
				<li class="nav-item">
					<a href="dashboard.php" aria-label="Ir al Dashboard">
						<i class="fa fa-tachometer-alt" aria-hidden="true"></i> Dashboard
					</a>
				</li>
				<?php if ($venta == 1): ?>
					<li class="nav-item">
						<a href="ventas.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'ventas.php' ? 'active' : ''; ?>">
							<i class="fas fa-shopping-cart fa-2x" aria-hidden="true"></i>
							<div class="text-uppercase" style="font-size: 12px;">Ventas</div>
						</a>
					</li>
				<?php endif; ?>

				<?php if ($pago == 1): ?>
					<li class="nav-item">
						<a href="pago.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'pago.php' ? 'active' : ''; ?>">
							<i class="fas fa-money-check-alt fa-2x" aria-hidden="true"></i>
							<div class="text-uppercase" style="font-size: 12px;">Pago</div>
						</a>
					</li>
				<?php endif; ?>

				<li class="nav-item">
					<a href="historial.php" class="nav-link">
						<i class="fa fa-history fa-2x" aria-hidden="true"></i>
						<div class="text-uppercase" style="font-size: 12px;">Historial</div>
					</a>
				</li>
				<li class="nav-item">
					<a href="reporte_usu2.php" class="nav-link">
						<i class="fa fa-cubes fa-2x" aria-hidden="true"></i>
						<div class="text-uppercase" style="font-size: 12px;">Utilidad dos cifras</div>
					</a>
				</li>
				<li class="nav-item">
					<a href="reporte_usu3.php" class="nav-link">
						<i class="fa fa-cubes fa-2x" aria-hidden="true"></i>
						<div class="text-uppercase" style="font-size: 12px;">Utilidad tres cifras</div>
					</a>
				</li>
				<li class="nav-item">
					<a href="reporte_usu4.php" class="nav-link">
						<i class="fa fa-cubes fa-2x" aria-hidden="true"></i>
						<div class="text-uppercase" style="font-size: 12px;">Utilidad cuatro cifras</div>
					</a>
				</li>
				<li class="nav-item">
					<a href="javascript:void(0)" class="nav-link" onclick="cerrar();" aria-label="Cerrar sesión">
						<i class="fas fa-sign-out-alt fa-2x" aria-hidden="true"></i>
						<div class="text-uppercase" style="font-size: 12px;">Cerrar Sesión</div>
					</a>
				</li>
			</ul>
    </nav>

    <div class="main-content" id="mainContent">
        <nav class="navbar navbar-expand-lg navbar-light bg-light">
            <div class="container-fluid">
                <a class="navbar-brand" href="#"><i class="fas fa-cubes"></i> Utilidades y Perdidas de Cuatro Cifras</a>
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link active"><i class="fa fa-store"></i> <?= $sucursal ?></a></li>
                    <li class="nav-item"><a class="nav-link active"><i class="fa fa-user-secret"></i> <?= $usuario ?></a></li>
                    <li class="nav-item"><a class="nav-link"><i class="fa fa-calendar-check"></i> <span id="fechaActual"></span></a></li>
                    <li class="nav-item d-none d-md-block"><a class="nav-link"><em class="fas fa-clock"></em> <span id="horaActual"></span></a></li>
                </ul>
            </div>
        </nav>

        <div class="row">
            <div class="row mb-5">
			  <div class="col-auto">
				<label for="fecha_inicio" class="form-label small">Desde:</label>
				<input type="date" id="fecha_inicio" class="form-control form-control-sm" style="max-width: 240;">
			  </div>
			  <div class="col-auto">
				<label for="fecha_fin" class="form-label small">Hasta:</label>
				<input type="date" id="fecha_fin" class="form-control form-control-sm" style="max-width: 240;">
			  </div>
			</div>
			<div class="mt-3 p-2 border rounded bg-light" style="max-width: 300px;">
			  <div style="display: flex; justify-content: space-between;">
				<strong>Total Vendido:</strong>
				<span id="totalGlobalVendido" style="text-align: right; min-width: 80px; display: inline-block;">$0.00</span>
			  </div>
			  <div style="display: flex; justify-content: space-between;">
				<strong>Total Premio:</strong>
				<span id="totalGlobalPremio" style="text-align: right; min-width: 80px; display: inline-block;">$0.00</span>
			  </div>
			  <div style="display: flex; justify-content: space-between;">
				<strong>Utilidad:</strong>
				<span id="totalGlobalUtilidad" style="text-align: right; min-width: 80px; display: inline-block;">$0.00</span>
			  </div>
			</div>
        <div class="table-responsive mt-3">
            <table id="ticket_hoy" class="table table-striped w-100 m-0">
                <thead>
                    <tr class="text-center">
                        <th>Lotería</th>
                        <th>Cifras</th>
                        <th>Fecha</th>
                        <th>Sucursal</th>
                        <th>Usuario</th>
                        <th>Ventas</th>
                        <th>Premio</th>
                        <th>Utilidad/Perdida</th>
                    </tr>
                </thead>
                <tbody></tbody>
                <tfoot>
					
				</tfoot>
            </table>
        </div>
    </div>

    <!-- JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>    
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>    
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>    
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    function cerrar() {
        Swal.fire({
            title: '¿Estás seguro?',
            text: '¿Deseas cerrar sesión?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, cerrar sesión',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                const loader = document.createElement('div');
                loader.className = 'loader';
                loader.textContent = 'Cerrando sesión...';
                document.body.appendChild(loader);

                fetch('../../controllers/usuario.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: new URLSearchParams({ boton: 'cerrar' })
                })
                .then(response => {
                    if (response.ok) {
                        window.location.href = '../index.php';
                    } else {
                        throw new Error();
                    }
                })
                .catch(() => Swal.fire('Error', 'No se pudo cerrar la sesión.', 'error'));
            }
        });
    }

    // Fecha y hora en navbar
    setInterval(() => {
        const now = new Date();
        document.getElementById("fechaActual").textContent = now.toLocaleDateString();
        document.getElementById("horaActual").textContent  = now.toLocaleTimeString();
    }, 1000);

    // Limitar fechas máximas a hoy
    document.addEventListener('DOMContentLoaded', function () {
        const hoy = new Date().toISOString().split('T')[0];
        document.getElementById('fecha_inicio').setAttribute('max', hoy);
        document.getElementById('fecha_fin').setAttribute('max', hoy);

        // Por defecto, hoy en ambos
        document.getElementById('fecha_inicio').value = hoy;
        document.getElementById('fecha_fin').value    = hoy;
    });

    // Validar rango de fechas
    function validarFechas() {
        const fechaInicio = document.getElementById('fecha_inicio').value;
        const fechaFin    = document.getElementById('fecha_fin').value;

        if (fechaInicio && fechaFin && fechaFin < fechaInicio) {
            Swal.fire({
                icon: 'error',
                title: 'Fechas inválidas',
                text: 'La fecha final no puede ser anterior a la fecha de inicio.',
            });

            document.getElementById('fecha_fin').value = fechaInicio;
            return false;
        }
        return true;
    }

    document.getElementById('fecha_inicio').addEventListener('change', function() {
        if (validarFechas()) table.ajax.reload();
    });
    document.getElementById('fecha_fin').addEventListener('change', function() {
        if (validarFechas()) table.ajax.reload();
    });

    // 🔢 DataTable
    let table;
    $(document).ready(function () {
        table = $("#ticket_hoy").DataTable({
            bDeferRender: true,
            paging: false,
            bLengthChange: false,
            searching: true,
            order: [[2, "asc"]], // orden por fecha
            ajax: {
                url: "funcion_r_up_usu4.php",
                type: "POST",
                data: function (d) {
                    d.fecha_inicio = $("#fecha_inicio").val();
                    d.fecha_fin    = $("#fecha_fin").val();
                },
                dataSrc: function (json) {
                    if (json.error) {
                        Swal.fire('Error', json.error, 'error');
                        return [];
                    }
                    // Totales globales
                    $("#totalGlobalVendido").text("$" + json.totales.total_vendido);
                    $("#totalGlobalPremio").text("$" + json.totales.total_premio);
                    $("#totalGlobalUtilidad").text("$" + json.totales.total_utilidad);
                    return json.data;
                }
            },
            columns: [
                { data: "loteria",  className: "text-center" },
                { data: "cifras",   className: "text-center" },
                { data: "fecha",    className: "text-center" },
                { data: "sucursal", className: "text-center" },
                { data: "usuario",  className: "text-center" },
                { data: "vendido",  className: "text-end"   },
                { data: "premio",   className: "text-end"   },
                { data: "saldo",    className: "text-end"   }
            ],
            language: {
                processing:   "Procesando...",
                zeroRecords:  "No se encontraron resultados",
                emptyTable:   "Ningún dato disponible en esta tabla",
                info:         "Mostrando _START_ a _END_ de _TOTAL_ registros",
                infoEmpty:    "Mostrando 0 a 0 de 0 registros",
                infoFiltered: "(filtrado de _MAX_ registros)",
                loadingRecords: "Por favor espere - cargando...",
                search:       "Buscar:",
                paginate: {
                    first:    "Primero",
                    last:     "Último",
                    next:     "Siguiente",
                    previous: "Anterior"
                }
            },
            dom: '<"d-flex justify-content-between align-items-center mb-2"<"btn-container"B><"search-container"f>>rtip',
            buttons: [
                {
                    extend: "excelHtml5",
                    text: '<i class="fa-solid fa-file-excel"></i>',
                    className: "btn btn-success btn-sm",
                    exportOptions: { columns: ":visible" }
                },
                {
                    extend: "pdfHtml5",
                    text: '<i class="fa-solid fa-file-pdf"></i>',
                    className: "btn btn-danger btn-sm",
                    orientation: "landscape",
                    pageSize: "A4",
                    exportOptions: { columns: ":visible" }
                }
            ],
            footerCallback: function (row, data, start, end, display) {
                function toNumber(v) {
                    if (v === null || v === undefined) return 0;
                    return parseFloat(String(v).replace(/[^0-9.-]/g, '')) || 0;
                }

                let totalVendido = 0;
                let totalPremio  = 0;
                let totalSaldo   = 0;

                data.forEach(item => {
                    totalVendido += toNumber(item.vendido);
                    totalPremio  += toNumber(item.premio);
                    totalSaldo   += toNumber(item.saldo);
                });

                // tfoot: 1 fila, 8 columnas -> totales en 6,7,8
                const $tfoot = $("#ticket_hoy tfoot th");
                $tfoot.eq(5).html('$' + totalVendido.toFixed(2));
                $tfoot.eq(6).html('$' + totalPremio.toFixed(2));
                $tfoot.eq(7).html('$' + totalSaldo.toFixed(2));
            }
        });
    });
    </script>
</body>
</html>
