<?php
session_start();
include("conex.php");
$usuario   = $_SESSION['usuario']  ?? '';
$idusuario = $_SESSION['idusuario'] ?? '';
$sucursal  = $_SESSION['sucursal']  ?? '';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Gestión</title>
    <link rel="shortcut icon" href="../resources/img/crud.ico">
    
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <!-- DataTables Buttons -->
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">
    <!-- (Opcional) Bootstrap CDN repetido, pero no afecta -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">

    <style>
        body {
            background-color: #f4f6f9;
            padding-top: 60px;
            overflow-x: hidden;
        }

        .topbar {
            width: 100%;
            height: 60px;
            background: #343a40;
            color: white;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
        }

        .sidebar {
            width: 250px;
            background: #343a40;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 60px;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            transition: width 0.3s;
            z-index: 1000;
        }

        .main-content {
            margin-left: 250px;
            padding: 1rem;
            transition: margin-left 0.3s;
            z-index: 100;
        }

        .modal-backdrop {
            z-index: 1040 !important;
        }

        .modal-dialog {
            z-index: 1050 !important;
        }

        .sidebar.collapsed {
            width: 80px;
        }

        .sidebar.collapsed a span {
            display: none;
        }

        .toggle-btn {
            cursor: pointer;
            margin-right: 10px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 12px;
            display: flex;
            align-items: center;
            width: 100%;
            transition: background 0.3s, transform 0.2s;
            border-radius: 8px;
        }

        .sidebar .submenu {
            display: none;
            padding-left: 20px;
            list-style: none;
            margin: 0;
            font-size: 14px;
        }

        .sidebar .submenu li {
            padding: 8px 0;
        }

        .sidebar a:hover, .sidebar a.active {
            background: #495057;
            transform: scale(1.05);
        }

        /* Switch */
        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: 0.4s;
            border-radius: 34px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            border-radius: 50%;
            left: 4px;
            bottom: 4px;
            background-color: white;
            transition: 0.4s;
        }

        input:checked + .slider {
            background-color: #4CAF50;
        }

        input:checked + .slider:before {
            transform: translateX(26px);
        }

        .dt-buttons .btn {
            padding: 6px 10px;
            font-size: 16px;
            border-radius: 5px;
            color: white !important;
        }

        .btn-success {
            background-color: #28a745 !important;
            border-color: #28a745 !important;
        }

        .btn-danger {
            background-color: #dc3545 !important;
            border-color: #dc3545 !important;
        }
    </style>
</head>
<body>

<!-- Barra Superior -->
<div class="topbar">
    <div class="toggle-btn" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </div>
    <span style="margin-left: 20px;">Sistema de Gestión</span>
    <div class="info">
        <span><?php echo htmlspecialchars($usuario); ?></span>
        <span id="fechaActual"></span>
        <span id="horaActual"></span>
    </div>
</div>

<!-- Sidebar -->
<?php include("menu.php"); ?>

<!-- Contenido Principal -->
<div class="main-content" id="mainContent">
    <div class="col-lg-12 col-md-12">
        <div class="panel panel-WHITE">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-lg-2 col-md-2">
                        <div class="form-group">
                            <label for="fecha_i">Desde*</label>
                            <input id="fecha_i" name="fecha_i" type="date" class="form-control border-left-0" required>
                        </div>						
                    </div>
					
                    <div class="col-lg-2 col-md-2">
                        <div class="form-group">
                            <label for="fecha_f">Hasta*</label>
                            <input id="fecha_f" name="fecha_f" type="date" class="form-control border-left-0" required>
                        </div>						
                    </div>
					
                    <div class="col-lg-2 col-md-2">
                        <div class="form-group">
                            <label for="sucursal">Sucursal*</label>
                            <select class="form-control" id="sucursal" name="sucursal" required></select>
                        </div>
                    </div> 

                    <div class="col-lg-2 col-md-2">
                        <div class="form-group">
                            <label for="usuario_s">Usuario*</label>
                            <select class="form-control" id="usuario_s" name="usuario_s" required></select>
                        </div>
                    </div> 

                    <div class="modal-body p-2">
                        <div class="table-responsive">
                            <table id="ticket_hoy" class="table table-striped w-100 m-0">
                                <thead>
                                    <tr class="text-center">
                                        <th>Cifras <i class="fas fa-sort-numeric-down"></i></th>
                                        <th>Loteria <i class="fas fa-sort-numeric-down"></i></th>
                                        <th>Fecha <i class="fas fa-calendar"></i></th>
                                        <th>Sucursal <i class="fas fa-television"></i></th>
                                        <th>Usuario <i class="fas fa-user"></i></th>
                                        <th>Ventas <i class="fas fa-dollar-sign"></i></th>
                                        <th>Premio <i class="fas fa-trophy"></i></th>
                                        <th>Utilidad/Perdida <i class="fas fa-dollar-sign"></i></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Datos por AJAX -->
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th colspan="2">UTILIDAD DEL DÍA</th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>                       
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Scripts base -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>

<!-- DataTables -->
<script src="../../resources/media/js/jquery.dataTables.min.js"></script>
<script src="../../resources/media/js/dataTables.bootstrap.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<!-- pdfmake (recomendado para pdfHtml5) -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>

<!-- Menú / lógica externa -->


<script>
    // Fecha y hora en barra superior
    function actualizarHora() {
        const ahora = new Date();
        const opcionesFecha = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
        const opcionesHora  = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
        document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opcionesFecha);
        document.getElementById('horaActual').textContent  = ahora.toLocaleTimeString('es-ES', opcionesHora);
    }
    setInterval(actualizarHora, 1000);
    actualizarHora();

    // Sidebar
    function toggleSidebar() {
        const sidebar     = document.getElementById('sidebar');
        const mainContent = document.getElementById('mainContent');
        if (!sidebar || !mainContent) return;

        sidebar.classList.toggle('collapsed');
        mainContent.style.marginLeft = sidebar.classList.contains('collapsed') ? '80px' : '250px';
    }

    // Cerrar sesión
    function cerrar() {
        Swal.fire({
            title: '¿Estás seguro?',
            text: '¿Deseas cerrar sesión?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, cerrar sesión',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('../../controllers/usuario.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: new URLSearchParams({ boton: 'cerrar' })
                })
                .then(response => response.ok ? location.href = '../administracion.php' : Promise.reject(response.statusText))
                .catch(error => Swal.fire('Error', 'Hubo un error al cerrar sesión: ' + error, 'error'));
            }
        });
    }

    // === TODO EL JS DE FILTROS, FECHAS Y DATATABLE ===
    $(document).ready(function () {
        // --- Cargar sucursales y usuarios ---
        $.ajax({
            type: "POST",
            url: "datos.php?Accion=GetSucursal",
            success: function(response) {
                $('#sucursal').html(response).fadeIn();
            }
        });

        $("#sucursal").change(function() {
            var Sucursal = $(this).val();
            $.ajax({
                type: "POST",
                url: "datos.php?Accion=GetUsuario&Sucursal=" + Sucursal,
                success: function(data) {
                    $('#usuario_s').html(data).fadeIn();
                }
            });
        });

        const $fechaInicio = $("#fecha_i");
        const $fechaFin    = $("#fecha_f");

        // ====== LÍMITES DE FECHAS ======
        const hoyObj  = new Date();
        const hoy     = hoyObj.toISOString().split("T")[0]; // YYYY-MM-DD

        const hace30  = new Date(hoyObj.getTime() - 30 * 24 * 60 * 60 * 1000)
                            .toISOString().split("T")[0];
        const minDate = hace30; // cámbialo si quieres otra cosa

        function setDateRestrictions() {
            // Límites generales
            $fechaInicio.attr("min", minDate);
            $fechaInicio.attr("max", hoy);
            $fechaFin.attr("min", minDate);
            $fechaFin.attr("max", hoy);

            // Si ya hay fecha de inicio, que fin no sea menor
            if ($fechaInicio.val()) {
                $fechaFin.attr("min", $fechaInicio.val());
            }

            // Si ya hay fecha fin, que inicio no sea mayor
            if ($fechaFin.val()) {
                $fechaInicio.attr("max", $fechaFin.val());
            }
        }

        // Ejecutar al cargar
        setDateRestrictions();

        // Recalcular restricciones cuando cambien las fechas
        $fechaInicio.on("change", setDateRestrictions);
        $fechaFin.on("change", setDateRestrictions);

        // ========== DATATABLE ==========
        let table;

        if ($.fn.DataTable.isDataTable('#ticket_hoy')) {
            // Ya existe -> la reutilizamos
            table = $('#ticket_hoy').DataTable();
        } else {
            // No existe -> la creamos
            table = $('#ticket_hoy').DataTable({
                bDeferRender: true,
                paging: false,
                bLengthChange: false,
                bFilter: false,
                searching: true,
                order: [[1, "asc"]],
                ajax: {
                    url: "funcion_r_up.php",
                    type: "POST",
                    data: function (d) {
                        d.usuario       = $("#usuario_s").val();
                        d.sucursal      = $("#sucursal").val();
                        d.fecha_inicio  = $("#fecha_i").val(); // 👈 coinciden con el PHP
                        d.fecha_fin     = $("#fecha_f").val();
                    }
                },
                columns: [
                    { data: "cifras",   className: "text-end" },
                    { data: "loteria",   className: "text-end" },
                    { data: "fecha",    className: "text-end" },
                    { data: "sucursal", className: "text-center" },
                    { data: "usuario",  className: "text-center" },
                    { data: "vendido",  className: "text-end" },
                    { data: "premio",   className: "text-end" },
                    { data: "saldo",    className: "text-end" }
                ],
                language: {
                    processing: "Procesando...",
                    zeroRecords: "No se encontraron resultados",
                    emptyTable: "Ningún dato disponible en esta tabla",
                    info: "Mostrando _START_ a _END_ de _TOTAL_ registros",
                    infoEmpty: "Mostrando 0 a 0 de 0 registros",
                    infoFiltered: "(filtrado de _MAX_ registros)",
                    loadingRecords: "Por favor espere - cargando...",
                    search: "Buscar:",
                    paginate: {
                        first: "Primero",
                        last: "Último",
                        next: "Siguiente",
                        previous: "Anterior"
                    }
                },
                dom: '<"d-flex justify-content-between" <"btn-container"B> <"search-container"f>>rtip',
                buttons: [
                    {
                        extend: "excelHtml5",
                        text: '<i class="fa-solid fa-file-excel"></i>',
                        className: "btn btn-success",
                        titleAttr: "Exportar a Excel",
                        exportOptions: { columns: ":visible" }
                    },
                    {
                        extend: "pdfHtml5",
                        text: '<i class="fa-solid fa-file-pdf"></i>',
                        className: "btn btn-danger",
                        titleAttr: "Exportar a PDF",
                        orientation: "landscape",
                        pageSize: "A4",
                        exportOptions: { columns: ":visible" }
                    }
                ],
                footerCallback: function (row, data, start, end, display) {
                    var totalVendido = 0;
                    var totalGanado  = 0;
                    var saldo        = 0;

                    data.forEach(function (item) {
                        totalVendido += parseFloat(item.vendido) || 0;
                        totalGanado  += parseFloat(item.premio) || 0;
                        saldo        += parseFloat(item.saldo) || 0;
                    });

                    $("#ticket_hoy tfoot th:nth-child(5)").html('$' + totalVendido.toFixed(2));
                    $("#ticket_hoy tfoot th:nth-child(6)").html('$' + totalGanado.toFixed(2));
                    $("#ticket_hoy tfoot th:nth-child(7)").html('$' + saldo.toFixed(2));
                }
            });
        }

        // ===== RECARGAR TABLA AL CAMBIAR FILTROS =====
        $("#usuario_s, #sucursal, #fecha_i, #fecha_f").change(function () {
            if (!$("#fecha_i").val() || !$("#fecha_f").val()) {
                console.warn("Las fechas deben estar completas antes de actualizar la tabla.");
                return;
            }

            console.log("Actualizando tabla con:", {
                usuario: $("#usuario_s").val(),
                sucursal: $("#sucursal").val(),
                fecha_inicio: $("#fecha_i").val(),
                fecha_fin: $("#fecha_f").val()
            });

            table.ajax.reload();
        });
    });
</script>


</body>
</html>
