<?php
declare(strict_types=1);
session_start();
date_default_timezone_set('America/Guayaquil');

if (!isset($_SESSION['idusuario'])) {
  header("Location: ../login.php"); exit;
}

$hoy = date('Y-m-d');
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Reporte · Topes por Cifras</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <link href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css" rel="stylesheet">

  <style>
    body{ font-size:15px; }
    .card{ border-radius: 14px; }
    .nav-tabs .nav-link{ font-weight: 700; }
    .table thead th{ white-space: nowrap; }
  </style>
</head>
<body class="bg-light">

<div class="container py-3">

  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h5 class="mb-0 fw-bold">Reporte de Topes por Números</h5>
      <div class="text-muted">3 cifras (>= 5) y 4 cifras (>= 1) en tablas separadas</div>
    </div>
  </div>

  <!-- Filtros -->
  <div class="card shadow-sm mb-3">
    <div class="card-body">
      <div class="row g-2 align-items-end">
        <div class="col-12 col-md-4">
          <label class="form-label fw-semibold">Fecha</label>
          <input type="date" class="form-control" id="fecha" value="<?= htmlspecialchars($hoy) ?>">
        </div>
        <div class="col-12 col-md-3 d-grid">
          <button class="btn btn-primary fw-semibold" id="btnBuscar">
            Buscar
          </button>
        </div>
      </div>
    </div>
  </div>

  <!-- Tabs -->
  <ul class="nav nav-tabs mb-2" role="tablist">
    <li class="nav-item" role="presentation">
      <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab3" type="button" role="tab">
        3 Cifras (>= 5)
      </button>
    </li>
    <li class="nav-item" role="presentation">
      <button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab4" type="button" role="tab">
        4 Cifras (>= 1)
      </button>
    </li>
  </ul>

  <div class="tab-content">

    <!-- TAB 3 CIFRAS -->
    <div class="tab-pane fade show active" id="tab3" role="tabpanel">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <div class="fw-bold">Números que superaron el tope (3 cifras)</div>
            <span class="badge bg-dark">Tope: >= 5</span>
          </div>

          <table id="tbl3" class="table table-striped table-hover w-100">
            <thead class="table-dark">
              <tr>
                <th>Lotería</th>
                <th>Número</th>
                <th class="text-end">Ventas</th>
                <th class="text-end">Total</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>

        </div>
      </div>
    </div>

    <!-- TAB 4 CIFRAS -->
    <div class="tab-pane fade" id="tab4" role="tabpanel">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <div class="fw-bold">Números que superaron el tope (4 cifras)</div>
            <span class="badge bg-dark">Tope: >= 1</span>
          </div>

          <table id="tbl4" class="table table-striped table-hover w-100">
            <thead class="table-dark">
              <tr>
                <th>Lotería</th>
                <th>Número</th>
                <th class="text-end">Ventas</th>
                <th class="text-end">Total</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>

        </div>
      </div>
    </div>

  </div>

</div>

<!-- JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>

<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>

<script>
let dt3 = null;
let dt4 = null;

function money(v){
  const n = Number(v || 0);
  return n.toLocaleString('es-EC', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
}

function initTables(){
  dt3 = $('#tbl3').DataTable({
    responsive: true,
    pageLength: 25,
    dom: 'Bfrtip',
    buttons: [
      { extend: 'excelHtml5', title: 'Reporte_3Cifras' },
      { extend: 'print', title: 'Reporte 3 Cifras' }
    ],
    columns: [
      { data: 'loteria' },
      { data: 'numero' },
      { data: 'cant_ventas', className: 'text-end' },
      { data: 'total_valor', className: 'text-end', render: (d)=> money(d) }
    ],
    language: { url: "https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json" }
  });

  dt4 = $('#tbl4').DataTable({
    responsive: true,
    pageLength: 25,
    dom: 'Bfrtip',
    buttons: [
      { extend: 'excelHtml5', title: 'Reporte_4Cifras' },
      { extend: 'print', title: 'Reporte 4 Cifras' }
    ],
    columns: [
      { data: 'loteria' },
      { data: 'numero' },
      { data: 'cant_ventas', className: 'text-end' },
      { data: 'total_valor', className: 'text-end', render: (d)=> money(d) }
    ],
    language: { url: "https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json" }
  });
}

function buscar(){
  const fecha = $('#fecha').val();

  // 3 cifras
  $.getJSON('api_reporte_topes.php', { action:'reporte', fecha, id_cifras: 3 }, function(res){
    if(res && res.success){
      dt3.clear().rows.add(res.data || []).draw();
    } else {
      dt3.clear().draw();
    }
  });

  // 4 cifras
  $.getJSON('api_reporte_topes.php', { action:'reporte', fecha, id_cifras: 4 }, function(res){
    if(res && res.success){
      dt4.clear().rows.add(res.data || []).draw();
    } else {
      dt4.clear().draw();
    }
  });
}

$(function(){
  initTables();
  $('#btnBuscar').on('click', buscar);
  buscar(); // carga inicial
});
</script>

</body>
</html>
