<?php
// views/pages/raspadita/reporte_coordinador.php
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') { header("Location: login.php"); exit; }
if (!isset($_SESSION['idusuario'])) { header("Location: login.php"); exit; }

// El coordinador logueado (rol 7 en tu sistema)
$id_coordinador = (int)$_SESSION['idusuario'];
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Reporte Coordinador - Raspaditas</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css" rel="stylesheet">

  <style>
    :root { --card:#fff; --muted:#6c757d; }
    body{ background:#f6f7fb; }
    .card-soft{ background:var(--card); border:1px solid rgba(0,0,0,.08); border-radius:14px; }
    .kpi{ font-size:1.35rem; font-weight:800; }
    .sub{ color:var(--muted); font-size:.9rem; }
    .toolbar{ gap:.5rem; flex-wrap:wrap; }
    .badge-state{ font-size:.75rem; }
    .table td, .table th{ vertical-align: middle; }
  </style>
</head>

<body class="p-3 p-md-4">
<div class="container-fluid">

  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h4 class="mb-0">Reporte de Coordinador</h4>
      <div class="sub">Resumen y detalle (Entregadas, Vendidas, Pagadas, Premios) — según tu sesión</div>
    </div>
    <div class="text-end sub">
      ID Coordinador: <b><?= (int)$id_coordinador ?></b>
    </div>
  </div>

  <!-- filtros -->
  <div class="card-soft p-3 mb-3">
    <div class="d-flex toolbar align-items-end">
      <div>
        <label class="form-label mb-1">Fecha inicio</label>
        <input type="date" id="fini" class="form-control form-control-sm">
      </div>
      <div>
        <label class="form-label mb-1">Fecha fin</label>
        <input type="date" id="ffin" class="form-control form-control-sm">
      </div>
      <div class="d-flex gap-2">
        <button class="btn btn-primary btn-sm" id="btnBuscar">Buscar</button>
        <button class="btn btn-outline-secondary btn-sm" id="btnHoy">Hoy</button>
      </div>

      <div class="ms-auto">
        <div class="sub">Por defecto carga <b>hoy</b> si no eliges fechas.</div>
      </div>
    </div>
  </div>

  <!-- KPIs -->
  <div class="row g-3 mb-3">
    <div class="col-12 col-md-3">
      <div class="card-soft p-3">
        <div class="sub">Entregadas (cant / valor)</div>
        <div class="kpi"><span id="kEntCant">0</span> / $<span id="kEntVal">0.00</span></div>
        <div class="sub">Estado = <b>2</b></div>
      </div>
    </div>
    <div class="col-12 col-md-3">
      <div class="card-soft p-3">
        <div class="sub">Vendidas (cant / valor)</div>
        <div class="kpi"><span id="kVenCant">0</span> / $<span id="kVenVal">0.00</span></div>
        <div class="sub">Estados = <b>3</b> y <b>8</b></div>
      </div>
    </div>
    <div class="col-12 col-md-3">
      <div class="card-soft p-3">
        <div class="sub">Premios</div>
        <div class="kpi">$<span id="kPremTotal">0.00</span></div>
        <div class="sub">Premios pagados (estado 8): $<b id="kPremPagados">0.00</b></div>
      </div>
    </div>
    <div class="col-12 col-md-3">
      <div class="card-soft p-3">
        <div class="sub">Neto (vendido - premios pagados)</div>
        <div class="kpi">$<span id="kNeto">0.00</span></div>
      </div>
    </div>
  </div>

  <!-- Tabla detalle -->
  <div class="card-soft p-3">
    <div class="d-flex align-items-center justify-content-between mb-2">
      <h6 class="mb-0">Detalle de raspaditas del rango</h6>
      <span class="sub" id="lblRango"></span>
    </div>

    <div class="table-responsive">
      <table id="tblDetalle" class="table table-sm table-striped table-hover mb-0" style="width:100%">
        <thead>
        <tr>
          <th>#</th>
          <th>Código</th>
          <th>Estado</th>
          <th>Valor</th>
          <th>Premio</th>
          <th>Fecha/Hora</th>
          <th>Punto venta</th>
          <th>Canillita</th>
          <th>Dev PV</th>
          <th>Dev CAN</th>
          <th>Dev COORD</th>
        </tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>

  </div>

</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>

<script>
  const API_URL = "api/reporte_coordinador.php";

  function todayISO(){
    const d = new Date();
    const m = String(d.getMonth()+1).padStart(2,'0');
    const day = String(d.getDate()).padStart(2,'0');
    return `${d.getFullYear()}-${m}-${day}`;
  }
  function money(n){
    n = Number(n || 0);
    return n.toFixed(2);
  }
  function stateBadge(estado, label){
    let cls = "bg-secondary";
    estado = Number(estado);
    if (estado === 2) cls = "bg-primary";
    if (estado === 3) cls = "bg-warning text-dark";
    if (estado === 8) cls = "bg-success";
    return `<span class="badge badge-state ${cls}">${label}</span>`;
  }

  let dt = null;

  async function loadReporte(){
    const fini = document.getElementById('fini').value || todayISO();
    const ffin = document.getElementById('ffin').value || todayISO();
    document.getElementById('lblRango').textContent = `Rango: ${fini} a ${ffin}`;

    const res = await fetch(API_URL, {
      method: "POST",
      headers: {"Content-Type":"application/json"},
      body: JSON.stringify({ fecha_inicio: fini, fecha_fin: ffin })
    });

    let data;
    try { data = await res.json(); }
    catch(e){
      alert("API no devolvió JSON válido.");
      return;
    }

    if (!data.success){
      alert(data.message || "No se pudo cargar el reporte.");
      return;
    }

    const s = data.summary || {};
    document.getElementById('kEntCant').textContent = s.entregadas_cant ?? 0;
    document.getElementById('kEntVal').textContent  = money(s.entregadas_valor);

    document.getElementById('kVenCant').textContent = s.vendidas_cant ?? 0;
    document.getElementById('kVenVal').textContent  = money(s.vendidas_valor);

    document.getElementById('kPremTotal').textContent   = money(s.premios_total);
    document.getElementById('kPremPagados').textContent = money(s.premios_pagados);

    document.getElementById('kNeto').textContent = money(s.neto);

    const rows = (data.detalle || []).map((r, i) => ({
      idx: i + 1,
      codigo: r.codigo,
      estado: stateBadge(r.estado, r.estado_label),
      valor: `$${money(r.valor)}`,
      premio: `$${money(r.premio)}`,
      fecha_hora: r.fecha_hora,
      punto_venta: r.punto_venta || "-",
      canillita: r.canillita || "-",
      dev_pv: Number(r.devuelto_punto) === 1 ? "SI" : "NO",
      dev_can: Number(r.devuelto_canillita) === 1 ? "SI" : "NO",
      dev_coord: Number(r.devuelto_coordinador) === 1 ? "SI" : "NO",
    }));

    if (!dt){
      dt = $('#tblDetalle').DataTable({
        data: rows,
        columns: [
          {data:'idx'},
          {data:'codigo'},
          {data:'estado'},
          {data:'valor'},
          {data:'premio'},
          {data:'fecha_hora'},
          {data:'punto_venta'},
          {data:'canillita'},
          {data:'dev_pv'},
          {data:'dev_can'},
          {data:'dev_coord'},
        ],
        pageLength: 25,
        order: [[5,'desc']],
        language: { url: "https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json" }
      });
    } else {
      dt.clear().rows.add(rows).draw();
    }
  }

  document.getElementById('btnBuscar').addEventListener('click', loadReporte);
  document.getElementById('btnHoy').addEventListener('click', () => {
    const t = todayISO();
    document.getElementById('fini').value = t;
    document.getElementById('ffin').value = t;
    loadReporte();
  });

  // init
  document.getElementById('fini').value = todayISO();
  document.getElementById('ffin').value = todayISO();
  loadReporte();
</script>
</body>
</html>