<?php
// menu_raspadita.php
// Uso: define $active = 'admin' | 'reporte' | 'punto' | 'canillita' | 'coordinador'
$active = $active ?? '';
?>
<nav class="sidebar" id="sidebar">
  <ul class="nav flex-column text-center w-100">

    <!-- ADMIN -->
    <li class="nav-item">
      <a href="admin.php" class="nav-link <?= ($active === 'admin') ? 'active' : '' ?>">
        <i class="fa-solid fa-user-shield fa-3x"></i>
        <div class="text-uppercase" style="font-size:12px;">Admin</div>
      </a>
    </li>

    <!-- COORDINADOR -->
    <li class="nav-item">
      <a href="coordinador.php" class="nav-link <?= ($active === 'coordinador') ? 'active' : '' ?>">
        <i class="fa-solid fa-user-tie fa-3x"></i>
        <div class="text-uppercase" style="font-size:12px;">Coordinador</div>
      </a>
    </li>

    <!-- PUNTO DE VENTA -->
    <li class="nav-item">
      <a href="punto_venta_admin.php" class="nav-link <?= ($active === 'punto') ? 'active' : '' ?>">
        <i class="fa-solid fa-store fa-3x"></i>
        <div class="text-uppercase" style="font-size:12px;">Punto de venta</div>
      </a>
    </li>

    <!-- CANILLITA -->
    <li class="nav-item">
      <a href="canillita_admin.php" class="nav-link <?= ($active === 'canillita') ? 'active' : '' ?>">
        <i class="fa-solid fa-person-walking fa-3x"></i>
        <div class="text-uppercase" style="font-size:12px;">Canillita</div>
      </a>
    </li>

    <!-- 🔥 NUEVO: REPORTE -->
    <li class="nav-item">
      <a href="reporte.php" class="nav-link <?= ($active === 'reporte') ? 'active' : '' ?>">
        <i class="fa-solid fa-chart-column fa-3x"></i>
        <div class="text-uppercase" style="font-size:12px;">Reporte</div>
      </a>
    </li>
	
	 <!-- 🔥 NUEVO: RESUMEN -->
	<li class="nav-item">
	  <a href="resumen_ventas_pagos.php" class="nav-link" <?= ($active === 'resumen') ? 'active' : '' ?>">
		<i class="fa fa-calculator me-2 fa-3x"></i>
		Resumen
	  </a>
	</li>

    <!-- SALIR -->
    <li class="nav-item">
      <a href="javascript:void(0)" class="nav-link" onclick="cerrar();">
        <i class="fas fa-sign-out-alt fa-3x"></i>
        <div class="text-uppercase" style="font-size:12px;">Salir</div>
      </a>
    </li>

  </ul>
</nav>

<script>
async function cerrar(){
  const ok = await Swal.fire({
    title: '¿Cerrar sesión?',
    text: 'Se cerrará tu sesión actual',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sí, salir',
    cancelButtonText: 'Cancelar',
    confirmButtonColor: '#d33'
  });

  if(!ok.isConfirmed) return;

  try{
    const r = await fetch('logout.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      credentials: 'same-origin',
      body: JSON.stringify({ bye: true })
    });

    const j = await r.json().catch(()=>null);
    if(!r.ok || !j?.success){
      throw new Error(j?.message || 'No se pudo cerrar sesión');
    }

    window.location.href = 'login.php';
  }catch(err){
    Swal.fire('Error', err.message || 'Error al cerrar sesión', 'error');
  }
}
</script>