<?php
// raspadita/logout.php — Cierre de sesión seguro (API JSON)
declare(strict_types=1);
date_default_timezone_set('America/Guayaquil');

/* ===== HEADERS / CORS ===== */
header('Content-Type: application/json; charset=utf-8');

// ✅ Si ya tienes lista blanca, mejor que '*'. Si no, lo dejamos flexible:
$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
if ($origin) {
  header("Access-Control-Allow-Origin: {$origin}");
  header('Vary: Origin');
} else {
  header('Access-Control-Allow-Origin: *');
}

header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-CSRF-Token');
header('Access-Control-Allow-Credentials: true'); // ✅ útil si usas cookies en fetch (credentials)
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

$method = strtoupper((string)($_SERVER['REQUEST_METHOD'] ?? 'GET'));
if ($method === 'OPTIONS') { http_response_code(204); exit; }
if ($method !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Método no permitido. Use POST'], JSON_UNESCAPED_UNICODE);
  exit;
}

// ✅ Iniciar sesión (si existe)
session_start();

// ✅ Regenerar ID para invalidar (recomendado)
@session_regenerate_id(true);

// ✅ Limpiar variables de sesión
$_SESSION = [];

// ✅ Borrar cookie de sesión (PHPSESSID)
if (ini_get('session.use_cookies')) {
  $p = session_get_cookie_params();

  // ⚠️ Importante: para que se borre, path/domain deben coincidir con la cookie original
  setcookie(
    session_name(),
    '',
    time() - 42000,
    $p['path'] ?? '/',
    $p['domain'] ?? '',
    (bool)($p['secure'] ?? false),
    (bool)($p['httponly'] ?? true)
  );

  // ✅ Opcional: por si tu cookie se creó sin domain, intenta borrar también sin domain
  setcookie(
    session_name(),
    '',
    time() - 42000,
    $p['path'] ?? '/',
  );
}

// ✅ Destruir sesión
session_destroy();

http_response_code(200);
echo json_encode(['success'=>true,'message'=>'Sesión cerrada'], JSON_UNESCAPED_UNICODE);