<?php
// views/pages/raspadita/api/venta_cart_list.php
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store');

$cart = $_SESSION['rasp_cart'] ?? [];
if (!is_array($cart)) $cart = [];

$total = 0.0;
$data = [];

foreach ($cart as $it) {
  $v = (float)($it['valor'] ?? 0);
  if (!is_finite($v)) $v = 0.0;

  $total += $v;

  $data[] = [
    'id'    => (int)($it['id'] ?? 0),
    'fecha' => (string)($it['fecha'] ?? ''),
    'serie' => (string)($it['serie'] ?? ''),
    'valor' => $v
  ];
}

echo json_encode([
  'success' => true,
  'data'    => $data,
  'total'   => round($total, 2),
], JSON_UNESCAPED_UNICODE);