<?php
// views/pages/raspadita/api/venta_cart_delete.php
// ✅ Quita del carrito (sesión)
// ✅ Revierte SOLO si está reservado por carrito: estado=2 AND tmp_cart=1  -> estado=1, tmp_cart=0
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Use POST'], JSON_UNESCAPED_UNICODE);
  exit;
}

function jexit(array $p, int $c=200): void {
  http_response_code($c);
  echo json_encode($p, JSON_UNESCAPED_UNICODE);
  exit;
}

if (!isset($_SESSION['idusuario'])) jexit(['success'=>false,'message'=>'Sesión no iniciada'], 401);
$id_usuario = (int)$_SESSION['idusuario'];

$raw = file_get_contents('php://input');
$in = $raw ? json_decode($raw, true) : [];
if (!is_array($in)) $in = [];

$id = (int)($in['id'] ?? 0);
if ($id <= 0) jexit(['success'=>false,'message'=>'ID inválido'], 400);

$_SESSION['rasp_cart'] = $_SESSION['rasp_cart'] ?? [];
$PRECIO_FIJO = 0.50;

// buscar item en carrito
$found = null;
foreach ($_SESSION['rasp_cart'] as $it) {
  if ((int)($it['id'] ?? 0) === $id) { $found = $it; break; }
}
if (!$found) jexit(['success'=>false,'message'=>'No existe ese item en el carrito.'], 404);

$serie = trim((string)($found['serie'] ?? ''));
if ($serie === '') jexit(['success'=>false,'message'=>'Serie inválida en carrito.'], 400);

require_once __DIR__ . '/../../conex.php';
$db = $conn ?? null;
if (!$db instanceof mysqli) jexit(['success'=>false,'message'=>'Sin conexión BD'], 500);
mysqli_set_charset($db, 'utf8mb4');

try {
  $db->begin_transaction();

  // ✅ Revertir SOLO si es reserva de carrito
  $sqlUpd = "UPDATE tbr_raspadita
             SET estado = 1,
                 tmp_cart = 0,
                 tmp_cart_at = NULL
             WHERE codigo = ?
               AND estado = 2
               AND tmp_cart = 1
               AND anulado = 0
               AND id_usuario = ?
             LIMIT 1";
  $st = $db->prepare($sqlUpd);
  if (!$st) throw new RuntimeException("Prepare update: ".$db->error);

  $st->bind_param('si', $serie, $id_usuario);
  $st->execute();
  $aff = $st->affected_rows;
  $st->close();

  // quitar de sesión
  $_SESSION['rasp_cart'] = array_values(array_filter($_SESSION['rasp_cart'], fn($x)=> (int)($x['id']??0) !== $id));

  $db->commit();

  $items = array_values($_SESSION['rasp_cart']);
  $total = round(count($items) * $PRECIO_FIJO, 2);

  $msg = ($aff === 1)
    ? "Eliminado y revertido (estado=1, tmp_cart=0)."
    : "Eliminado del carrito. (No se revirtió: puede ser venta definitiva o ya cambió de estado).";

  jexit(['success'=>true,'message'=>$msg,'data'=>$items,'total'=>$total], 200);

} catch (Throwable $e) {
  try { $db->rollback(); } catch (Throwable $x) {}
  jexit(['success'=>false,'message'=>'Error interno','detail'=>$e->getMessage()], 500);
}
