<?php
// views/pages/raspadita/api/resumen_ventas_pagos.php
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Use POST'], JSON_UNESCAPED_UNICODE);
  exit;
}

require_once __DIR__ . '/../../conex.php';
$db = $conn ?? null;
if (!$db instanceof mysqli) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Sin conexión BD'], JSON_UNESCAPED_UNICODE);
  exit;
}
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

function jexit(array $p, int $c=200): void {
  http_response_code($c);
  echo json_encode($p, JSON_UNESCAPED_UNICODE);
  exit;
}

$raw = file_get_contents('php://input') ?: '';
$in  = json_decode($raw, true);
if (!is_array($in)) $in = [];

$fi = trim((string)($in['fecha_inicio'] ?? ''));
$ff = trim((string)($in['fecha_fin'] ?? ''));

// Si no envían fechas => HOY
if ($fi === '' || $ff === '') {
  $hoy = (new DateTime('now'))->format('Y-m-d');
  $fi = $fi !== '' ? $fi : $hoy;
  $ff = $ff !== '' ? $ff : $hoy;
}

// Validación yyyy-mm-dd
if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $fi) || !preg_match('/^\d{4}-\d{2}-\d{2}$/', $ff)) {
  jexit(['success'=>false,'message'=>'Formato fecha inválido. Use YYYY-MM-DD'], 422);
}

$start = $fi . ' 00:00:00';
$end   = $ff . ' 23:59:59';

/* =========================================================
   1) VENTAS: tbr_coordinador_saldo (fecha_hora)
   tipo_pago: EFECTIVO | CREDITO | ABONO
   ========================================================= */
$sqlVentas = "
SELECT
  COALESCE(SUM(total_pagar),0) AS ventas_total,
  COALESCE(SUM(CASE WHEN UPPER(tipo_pago)='EFECTIVO' THEN total_pagar ELSE 0 END),0) AS ventas_efectivo,
  COALESCE(SUM(CASE WHEN UPPER(tipo_pago)='CREDITO'  THEN total_pagar ELSE 0 END),0) AS ventas_credito,
  COALESCE(SUM(CASE WHEN UPPER(tipo_pago)='ABONO'    THEN total_pagar ELSE 0 END),0) AS ventas_abono,
  COALESCE(SUM(descuento),0) AS descuentos_total
FROM tbr_coordinador_saldo
WHERE fecha_hora BETWEEN ? AND ?
";

$stmt = mysqli_prepare($db, $sqlVentas);
if (!$stmt) jexit(['success'=>false,'message'=>'Error prepare ventas: '.mysqli_error($db)], 500);

mysqli_stmt_bind_param($stmt, "ss", $start, $end);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$ventas = $res ? mysqli_fetch_assoc($res) : null;
mysqli_stmt_close($stmt);

if (!$ventas) {
  $ventas = [
    'ventas_total' => 0,
    'ventas_efectivo' => 0,
    'ventas_credito' => 0,
    'ventas_abono' => 0,
    'descuentos_total' => 0
  ];
}

/* =========================================================
   2) PAGOS / PREMIOS PAGADOS: tbr_raspadita
   - premio > 0
   - estado = 8 (pagada)  ✅ si tu estado pagada es otro número, cámbialo
   - anulado <> 1
   - fecha_hora entre rango
   ========================================================= */
$ESTADO_PAGADA = 8; // ✅ si en tu sistema "pagada" es otro estado, cambia aquí

$sqlPagos = "
SELECT COALESCE(SUM(premio),0) AS pagos_total
FROM tbr_raspadita
WHERE fecha_hora BETWEEN ? AND ?
  AND COALESCE(anulado,0) <> 1
  AND COALESCE(premio,0) > 0
  AND estado = ?
";

$stmt2 = mysqli_prepare($db, $sqlPagos);
if (!$stmt2) jexit(['success'=>false,'message'=>'Error prepare pagos: '.mysqli_error($db)], 500);

mysqli_stmt_bind_param($stmt2, "ssi", $start, $end, $ESTADO_PAGADA);
mysqli_stmt_execute($stmt2);
$res2 = mysqli_stmt_get_result($stmt2);
$p = $res2 ? mysqli_fetch_assoc($res2) : null;
mysqli_stmt_close($stmt2);

$pagos_total = $p ? (float)$p['pagos_total'] : 0.0;

jexit([
  'success'          => true,
  'fecha_inicio'     => $fi,
  'fecha_fin'        => $ff,
  'ventas_total'     => (float)$ventas['ventas_total'],
  'ventas_efectivo'  => (float)$ventas['ventas_efectivo'],
  'ventas_credito'   => (float)$ventas['ventas_credito'],
  'ventas_abono'     => (float)$ventas['ventas_abono'],
  'descuentos_total' => (float)$ventas['descuentos_total'],
  'pagos_total'      => (float)$pagos_total
]);