<?php
// views/pages/raspadita/api/raspadita_marcar_pagada.php
// POST JSON: { "id": 123 }  (recomendado)
// Regla: solo si estado=3 (VENDIDA) -> pasa a 8 (PAGADA)

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Use POST'], JSON_UNESCAPED_UNICODE);
  exit;
}

function jexit(array $p, int $c=200): void { http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE); exit; }
function read_json(): array {
  $raw = file_get_contents('php://input');
  if (!$raw) return [];
  $j = json_decode($raw, true);
  return is_array($j) ? $j : [];
}

if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES' || (int)($_SESSION['id_rol'] ?? 0) !== 7) {
  jexit(['success'=>false,'message'=>'No autorizado'], 401);
}

$id_coordinador = (int)($_SESSION['id_coordinador'] ?? 0);
if ($id_coordinador <= 0) jexit(['success'=>false,'message'=>'Sesión sin coordinador'], 401);

$in = read_json();
$id = (int)($in['id'] ?? 0);
if ($id <= 0) jexit(['success'=>false,'message'=>'id requerido'], 422);

require_once __DIR__ . '/../../conex.php';
$db = $conn ?? null;
if (!$db instanceof mysqli) jexit(['success'=>false,'message'=>'Sin conexión BD'], 500);
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

mysqli_begin_transaction($db);

try {
  // Verificar pertenece + estado actual
  $stmt = mysqli_prepare($db, "SELECT estado, codigo FROM tbr_raspadita WHERE id=? AND id_coordinador=? LIMIT 1");
  if (!$stmt) throw new Exception('SQL select error');
  mysqli_stmt_bind_param($stmt, "ii", $id, $id_coordinador);
  mysqli_stmt_execute($stmt);
  mysqli_stmt_store_result($stmt);
  if (mysqli_stmt_num_rows($stmt) < 1) {
    mysqli_stmt_close($stmt);
    mysqli_rollback($db);
    jexit(['success'=>false,'message'=>'No encontrado o no pertenece a este coordinador'], 404);
  }
  mysqli_stmt_bind_result($stmt, $estado, $codigo);
  mysqli_stmt_fetch($stmt);
  mysqli_stmt_close($stmt);

  if ((int)$estado !== 3) {
    mysqli_rollback($db);
    jexit(['success'=>false,'message'=>'Solo se puede pagar cuando está en estado VENDIDA (3)'], 422);
  }

  // Update a estado=8 (pagada). Guardamos id_admin = id_coordinador (trazabilidad simple)
  $nuevoEstado = 8;
  $idAdmin = $id_coordinador;

  $stmt2 = mysqli_prepare($db, "UPDATE tbr_raspadita SET estado=?, id_admin=? WHERE id=? AND id_coordinador=? LIMIT 1");
  if (!$stmt2) throw new Exception('SQL update error');
  mysqli_stmt_bind_param($stmt2, "iiii", $nuevoEstado, $idAdmin, $id, $id_coordinador);
  mysqli_stmt_execute($stmt2);

  if (mysqli_stmt_affected_rows($stmt2) < 1) {
    mysqli_stmt_close($stmt2);
    mysqli_rollback($db);
    jexit(['success'=>false,'message'=>'No se pudo actualizar (ya estaba pagada o sin cambios)'], 409);
  }
  mysqli_stmt_close($stmt2);

  mysqli_commit($db);

  jexit([
    'success' => true,
    'message' => 'Marcada como PAGADA (8)',
    'id' => $id,
    'codigo' => (string)$codigo,
    'estado' => 8
  ]);

} catch (Throwable $e) {
  mysqli_rollback($db);
  jexit(['success'=>false,'message'=>'Error', 'detail'=>$e->getMessage()], 500);
}