<?php
// views/pages/raspadita/api/raspadita_insert.php
// ENTREGA CANILLITA
// - estado=3 forzado
// - Si ya existe activo (anulado=0):
//     * Si algn devuelto est en 0 o 1 ? anula anterior e inserta nuevo
//     * Si todos >1 ? bloquea
// - Guarda premio y valor
// - NO actualiza saldo

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Guayaquil');

/* ===== HEADERS ===== */
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') {
    http_response_code(204);
    exit;
}

function jexit(array $payload, int $code=200): void {
    http_response_code($code);
    echo json_encode($payload, JSON_UNESCAPED_UNICODE);
    exit;
}

function read_json(): array {
    $raw = file_get_contents('php://input');
    $data = json_decode($raw ?: '', true);
    return is_array($data) ? $data : [];
}

function norm(string $s): string {
    $s = trim($s);
    $s = preg_replace('/\s+/', '', $s);
    return $s;
}

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
    jexit(['success'=>false,'message'=>'Metodo no permitido. Use POST'], 405);
}

/* ===== DB ===== */
require_once __DIR__ . '/../../conex.php';
$db = $conn ?? ($conex ?? null);

if (!$db instanceof mysqli) {
    jexit(['success'=>false,'message'=>'Sin conexion BD'], 500);
}

mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

/* ===== INPUT ===== */
$in = read_json();

$codigo       = norm((string)($in['codigo'] ?? ''));
$id_canillita = (int)($in['id_canillita'] ?? 0);
$premio       = round((float)($in['premio'] ?? 0), 2);
$valor        = round((float)($in['valor'] ?? 0.50), 2);

$estado  = 3;
$anulado = 0;

$id_admin_ses = (int)($_SESSION['idusuario'] ?? 0);
$id_admin     = $id_admin_ses > 0 ? $id_admin_ses : (int)($in['id_admin'] ?? 0);

if ($id_admin <= 0)      jexit(['success'=>false,'message'=>'Debe iniciar sesin o enviar id_admin'], 401);
if ($codigo === '')      jexit(['success'=>false,'message'=>'Debe enviar codigo'], 422);
if ($id_canillita <= 0)  jexit(['success'=>false,'message'=>'Debe enviar id_canillita vlido'], 422);
if ($premio < 0)         jexit(['success'=>false,'message'=>'Premio no puede ser negativo'], 422);
if ($valor < 0)          jexit(['success'=>false,'message'=>'Valor no puede ser negativo'], 422);

$ip  = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
$now = date('Y-m-d H:i:s');

try {
    mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
    $db->begin_transaction();

    /* ===== Validar canillita activo ===== */
    $stmt = $db->prepare("SELECT id FROM tbr_canillita WHERE id=? AND activo=1 LIMIT 1");
    $stmt->bind_param("i", $id_canillita);
    $stmt->execute();
    $res = $stmt->get_result();
    if (!$res->fetch_assoc()) {
        $db->rollback();
        jexit(['success'=>false,'message'=>'Canillita no existe o est inactivo'], 409);
    }
    $stmt->close();

    /* ===== Ver si ya existe activo ===== */
    $stmt = $db->prepare("
        SELECT id,
               COALESCE(devuelto_punto,0) AS dev_p,
               COALESCE(devuelto_canillita,0) AS dev_c,
               COALESCE(devuelto_coordinador,0) AS dev_co
        FROM tbr_raspadita
        WHERE codigo=? AND anulado=0
        ORDER BY id DESC
        LIMIT 1
        FOR UPDATE
    ");
    $stmt->bind_param("s", $codigo);
    $stmt->execute();
    $res = $stmt->get_result();
    $existente = $res->fetch_assoc();
    $stmt->close();

    $oldId = 0;

    if ($existente) {
        $oldId = (int)$existente['id'];

        $permite = (
            in_array((int)$existente['dev_p'],  [0,1], true) ||
            in_array((int)$existente['dev_c'],  [0,1], true) ||
            in_array((int)$existente['dev_co'], [0,1], true)
        );

        if (!$permite) {
            $db->rollback();
            jexit([
                'success'=>false,
                'message'=>'No se puede reinsertar: devoluciones mayores a 1 en todos'
            ], 409);
        }

        // Anular anterior
        $stmtAn = $db->prepare("UPDATE tbr_raspadita SET anulado=1 WHERE id=? LIMIT 1");
        $stmtAn->bind_param("i", $oldId);
        $stmtAn->execute();
        $stmtAn->close();
    }

    /* ===== INSERT NUEVO ===== */
    $stmtIns = $db->prepare("
        INSERT INTO tbr_raspadita
            (codigo, estado, anulado, fecha_hora, ip, id_admin, id_canillita, premio, valor)
        VALUES
            (?, ?, 0, ?, ?, ?, ?, ?, ?)
    ");

    // 8 variables ? s i s s i i d d
    $stmtIns->bind_param(
        "sissiidd",
        $codigo,
        $estado,
        $now,
        $ip,
        $id_admin,
        $id_canillita,
        $premio,
        $valor
    );

    $stmtIns->execute();
    $newId = (int)$db->insert_id;
    $stmtIns->close();

    $db->commit();

    jexit([
        'success' => true,
        'message' => $oldId > 0 ? 'Insertado nuevamente (anterior anulado)' : 'Insertado correctamente',
        'mode'    => $oldId > 0 ? 'insert_again' : 'insert',
        'id'      => $newId,
        'codigo'  => $codigo,
        'premio'  => $premio,
        'valor'   => $valor
    ], 201);

} catch (Throwable $e) {
    try { $db->rollback(); } catch(Throwable $x) {}
    jexit([
        'success'=>false,
        'message'=>'Error en transaccin',
        'detail'=>$e->getMessage()
    ], 500);
}