<?php 
// views/pages/raspadita/api/raspadita_ganadora_insert.php
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-CSRF-Token');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Método no permitido. Use POST'], JSON_UNESCAPED_UNICODE);
  exit;
}

require_once __DIR__ . '/../../conex.php';
$db = $conn ?? ($conex ?? null);

if (!$db instanceof mysqli) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Sin conexión a la base de datos'], JSON_UNESCAPED_UNICODE);
  exit;
}

mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

// ===== Helpers =====
function jexit(array $payload, int $code=200): void {
  http_response_code($code);
  echo json_encode($payload, JSON_UNESCAPED_UNICODE);
  exit;
}
function read_json(): array {
  $raw = file_get_contents('php://input');
  if (!$raw) return [];
  $data = json_decode($raw, true);
  return is_array($data) ? $data : [];
}
function serie_norm(string $s): string {
  $s = trim($s);
  $s = preg_replace('/\s+/', '', $s);
  return (string)$s;
}

$in = read_json();

$codigo = serie_norm((string)($in['codigo'] ?? $in['serie'] ?? ''));
$premio = isset($in['premio']) ? (float)$in['premio'] : 0.0;

// ✅ ORIGEN (1 de 3)
$id_puntoventa  = (int)($in['id_puntoventa'] ?? $in['id_usuario'] ?? 0); // punto = id_usuario
$id_canillita   = (int)($in['id_canillita'] ?? 0);
$id_coordinador = (int)($in['id_coordinador'] ?? 0);

// id_admin (sesión primero)
$id_admin = (int)($_SESSION['idusuario'] ?? 0);
if ($id_admin <= 0) $id_admin = (int)($in['id_admin'] ?? 0);

if ($codigo === '') jexit(['success'=>false,'message'=>'Código/Serie es obligatorio'], 422);
if (!($premio > 0)) jexit(['success'=>false,'message'=>'Premio debe ser mayor a 0'], 422);
if ($id_admin <= 0) jexit(['success'=>false,'message'=>'id_admin es obligatorio (o iniciar sesión)'], 422);

$hasP = $id_puntoventa > 0;
$hasC = $id_canillita > 0;
$hasK = $id_coordinador > 0;

$cnt = ($hasP?1:0) + ($hasC?1:0) + ($hasK?1:0);
if ($cnt !== 1) {
  jexit(['success'=>false,'message'=>'Debe enviar SOLO UNO: Punto o Canillita o Coordinador (no 2 ni 3).'], 422);
}

// ✅ ESTADO según origen
if ($hasC) {
  $estado = 3; // CANILLITA
} elseif ($hasP) {
  $estado = 2; // PUNTO DE VENTA
} else {
  $estado = 1; // COORDINADOR
}

$anulado = 0;
$fecha_hora = date('Y-m-d H:i:s');

// IP
$ip = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? ($_SERVER['REMOTE_ADDR'] ?? '');
if ($ip && strpos($ip, ',') !== false) $ip = trim(explode(',', $ip)[0]);
$ip = substr((string)$ip, 0, 45);

$T = "tbr_raspadita";

/*
  ✅ REQUERIDO para coordinador:
  ALTER TABLE tbr_raspadita ADD COLUMN id_coordinador INT NULL AFTER id_canillita;
*/

// ✅ Anti-duplicado: misma serie + mismo origen (no anulado)
if ($hasP) {
  $stmt = mysqli_prepare($db, "SELECT id FROM {$T} WHERE codigo=? AND id_usuario=? AND anulado=0 LIMIT 1");
  if(!$stmt) jexit(['success'=>false,'message'=>'No se pudo preparar SELECT','detail'=>mysqli_error($db)], 500);
  mysqli_stmt_bind_param($stmt, "si", $codigo, $id_puntoventa);
} elseif ($hasC) {
  $stmt = mysqli_prepare($db, "SELECT id FROM {$T} WHERE codigo=? AND id_canillita=? AND anulado=0 LIMIT 1");
  if(!$stmt) jexit(['success'=>false,'message'=>'No se pudo preparar SELECT','detail'=>mysqli_error($db)], 500);
  mysqli_stmt_bind_param($stmt, "si", $codigo, $id_canillita);
} else { // $hasK
  $stmt = mysqli_prepare($db, "SELECT id FROM {$T} WHERE codigo=? AND id_coordinador=? AND anulado=0 LIMIT 1");
  if(!$stmt) jexit(['success'=>false,'message'=>'No se pudo preparar SELECT','detail'=>mysqli_error($db)], 500);
  mysqli_stmt_bind_param($stmt, "si", $codigo, $id_coordinador);
}

mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$dup = mysqli_fetch_assoc($res) ?: null;
mysqli_stmt_close($stmt);

if ($dup) {
  jexit([
    'success'=>false,
    'message'=>'Ya existe un registro (no anulado) para esa serie y ese origen.',
    'id_existente'=>(int)$dup['id']
  ], 409);
}

// ✅ INSERT (1 de 3)
if ($hasP) {
  $sql = "INSERT INTO {$T}
          (id_usuario, codigo, estado, anulado, fecha_hora, ip, id_admin, id_canillita, id_coordinador, premio)
          VALUES (?, ?, ?, ?, ?, ?, ?, NULL, NULL, ?)";
  $stmt = mysqli_prepare($db, $sql);
  if(!$stmt) jexit(['success'=>false,'message'=>'No se pudo preparar INSERT','detail'=>mysqli_error($db)], 500);

  mysqli_stmt_bind_param($stmt, "isiissid",
    $id_puntoventa, $codigo, $estado, $anulado, $fecha_hora, $ip, $id_admin, $premio
  );

} elseif ($hasC) {
  $sql = "INSERT INTO {$T}
          (id_usuario, codigo, estado, anulado, fecha_hora, ip, id_admin, id_canillita, id_coordinador, premio)
          VALUES (NULL, ?, ?, ?, ?, ?, ?, ?, NULL, ?)";
  $stmt = mysqli_prepare($db, $sql);
  if(!$stmt) jexit(['success'=>false,'message'=>'No se pudo preparar INSERT','detail'=>mysqli_error($db)], 500);

  mysqli_stmt_bind_param($stmt, "siissiid",
    $codigo, $estado, $anulado, $fecha_hora, $ip, $id_admin, $id_canillita, $premio
  );

} else { // $hasK
  $sql = "INSERT INTO {$T}
          (id_usuario, codigo, estado, anulado, fecha_hora, ip, id_admin, id_canillita, id_coordinador, premio)
          VALUES (NULL, ?, ?, ?, ?, ?, ?, NULL, ?, ?)";
  $stmt = mysqli_prepare($db, $sql);
  if(!$stmt) jexit(['success'=>false,'message'=>'No se pudo preparar INSERT','detail'=>mysqli_error($db)], 500);

  mysqli_stmt_bind_param($stmt, "siissiid",
    $codigo, $estado, $anulado, $fecha_hora, $ip, $id_admin, $id_coordinador, $premio
  );
}

$ok  = mysqli_stmt_execute($stmt);
$err = mysqli_stmt_error($stmt);
$newId = (int)mysqli_insert_id($db);
mysqli_stmt_close($stmt);

if (!$ok) {
  jexit(['success'=>false,'message'=>'No se pudo guardar','detail'=>$err], 500);
}

jexit([
  'success'=>true,
  'message'=>'Ganadora registrada',
  'id'=>$newId,
  'codigo'=>$codigo,
  'premio'=>$premio,
  'estado'=>$estado, // ✅ DEVUELVE estado
  'id_puntoventa'=>$hasP ? $id_puntoventa : 0,
  'id_canillita'=>$hasC ? $id_canillita : 0,
  'id_coordinador'=>$hasK ? $id_coordinador : 0,
  'fecha_hora'=>$fecha_hora
], 200);
