<?php
// views/pages/raspadita/api/raspadita_ganadora_delete.php
// Elimina registro GANADORA / ANTIFRAUDE en tbr_raspadita por:
// - codigo (serie)
// - y XOR: SOLO UNO entre id_puntoventa (id_usuario) o id_canillita o id_coordinador
//
// POST JSON:
// {
//   "codigo":"6766...",
//   "id_puntoventa": 5,     // opcional (si este viene, NO enviar los otros)
//   "id_canillita": 0,      // opcional
//   "id_coordinador": 0,    // opcional
//   "id_admin": 1           // opcional si no hay sesión
// }

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-CSRF-Token');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Método no permitido. Use POST'], JSON_UNESCAPED_UNICODE);
  exit;
}

require_once __DIR__ . '/../../conex.php';
$db = $conn ?? ($conex ?? null);

if (!$db instanceof mysqli) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Sin conexión a la base de datos'], JSON_UNESCAPED_UNICODE);
  exit;
}

mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

// ===== Helpers =====
function jexit(array $payload, int $code=200): void {
  http_response_code($code);
  echo json_encode($payload, JSON_UNESCAPED_UNICODE);
  exit;
}
function read_json(): array {
  $raw = file_get_contents('php://input');
  if (!$raw) return [];
  $data = json_decode($raw, true);
  return is_array($data) ? $data : [];
}
function serie_norm(string $s): string {
  $s = trim($s);
  $s = preg_replace('/\s+/', '', $s);
  return (string)$s;
}

// ===== Entrada =====
$in = read_json();

$codigo = serie_norm((string)($in['codigo'] ?? $in['serie'] ?? ''));

// ✅ ORIGEN (1 de 3)
$id_puntoventa  = (int)($in['id_puntoventa'] ?? $in['id_usuario'] ?? 0);
$id_canillita   = (int)($in['id_canillita'] ?? 0);
$id_coordinador = (int)($in['id_coordinador'] ?? 0);

// id_admin: preferir sesión
$id_admin = (int)($_SESSION['idusuario'] ?? 0);
if ($id_admin <= 0) $id_admin = (int)($in['id_admin'] ?? 0);

if ($codigo === '') jexit(['success'=>false,'message'=>'Código/Serie es obligatorio'], 422);
if ($id_admin <= 0) jexit(['success'=>false,'message'=>'id_admin es obligatorio (o iniciar sesión)'], 422);

$hasP = $id_puntoventa > 0;
$hasC = $id_canillita > 0;
$hasK = $id_coordinador > 0;

$cnt = ($hasP?1:0) + ($hasC?1:0) + ($hasK?1:0);
if ($cnt !== 1) {
  jexit(['success'=>false,'message'=>'Debe enviar SOLO UNO: Punto o Canillita o Coordinador (no 2 ni 3).'], 422);
}

// Tabla
$T = "tbr_raspadita";

// ===== Buscar existencia =====
if ($hasP) {
  $stmt = mysqli_prepare($db, "SELECT id FROM {$T} WHERE codigo=? AND id_usuario=? LIMIT 1");
  if(!$stmt) jexit(['success'=>false,'message'=>'No se pudo preparar SELECT','detail'=>mysqli_error($db)], 500);
  mysqli_stmt_bind_param($stmt, "si", $codigo, $id_puntoventa);

} elseif ($hasC) {
  $stmt = mysqli_prepare($db, "SELECT id FROM {$T} WHERE codigo=? AND id_canillita=? LIMIT 1");
  if(!$stmt) jexit(['success'=>false,'message'=>'No se pudo preparar SELECT','detail'=>mysqli_error($db)], 500);
  mysqli_stmt_bind_param($stmt, "si", $codigo, $id_canillita);

} else { // $hasK
  $stmt = mysqli_prepare($db, "SELECT id FROM {$T} WHERE codigo=? AND id_coordinador=? LIMIT 1");
  if(!$stmt) jexit(['success'=>false,'message'=>'No se pudo preparar SELECT','detail'=>mysqli_error($db)], 500);
  mysqli_stmt_bind_param($stmt, "si", $codigo, $id_coordinador);
}

mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$ex = mysqli_fetch_assoc($res) ?: null;
mysqli_stmt_close($stmt);

if (!$ex) {
  jexit(['success'=>false,'message'=>'No existe el registro a eliminar'], 404);
}

// ===== Eliminar =====
if ($hasP) {
  $stmt = mysqli_prepare($db, "DELETE FROM {$T} WHERE codigo=? AND id_usuario=? LIMIT 1");
  if(!$stmt) jexit(['success'=>false,'message'=>'No se pudo preparar DELETE','detail'=>mysqli_error($db)], 500);
  mysqli_stmt_bind_param($stmt, "si", $codigo, $id_puntoventa);

} elseif ($hasC) {
  $stmt = mysqli_prepare($db, "DELETE FROM {$T} WHERE codigo=? AND id_canillita=? LIMIT 1");
  if(!$stmt) jexit(['success'=>false,'message'=>'No se pudo preparar DELETE','detail'=>mysqli_error($db)], 500);
  mysqli_stmt_bind_param($stmt, "si", $codigo, $id_canillita);

} else { // $hasK
  $stmt = mysqli_prepare($db, "DELETE FROM {$T} WHERE codigo=? AND id_coordinador=? LIMIT 1");
  if(!$stmt) jexit(['success'=>false,'message'=>'No se pudo preparar DELETE','detail'=>mysqli_error($db)], 500);
  mysqli_stmt_bind_param($stmt, "si", $codigo, $id_coordinador);
}

$ok  = mysqli_stmt_execute($stmt);
$err = mysqli_stmt_error($stmt);
$aff = mysqli_stmt_affected_rows($stmt);
mysqli_stmt_close($stmt);

if (!$ok) jexit(['success'=>false,'message'=>'No se pudo eliminar','detail'=>$err], 500);
if ($aff <= 0) jexit(['success'=>false,'message'=>'No se eliminó ningún registro'], 409);

jexit([
  'success'=>true,
  'message'=>'Registro eliminado',
  'deleted'=>$aff,
  'id'=>(int)$ex['id'],
  'codigo'=>$codigo,
  'id_puntoventa'=>$hasP ? $id_puntoventa : 0,
  'id_canillita'=>$hasC ? $id_canillita : 0,
  'id_coordinador'=>$hasK ? $id_coordinador : 0
], 200);
