<?php
// views/pages/raspadita/api/raspadita_detalle.php
// POST JSON: { "id": 123 } o { "codigo":"XXXX" }

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Use POST'], JSON_UNESCAPED_UNICODE);
  exit;
}

function jexit(array $p, int $c=200): void { http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE); exit; }
function read_json(): array {
  $raw = file_get_contents('php://input');
  if (!$raw) return [];
  $j = json_decode($raw, true);
  return is_array($j) ? $j : [];
}

if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES' || (int)($_SESSION['id_rol'] ?? 0) !== 7) {
  jexit(['success'=>false,'message'=>'No autorizado'], 401);
}

$id_coordinador = (int)($_SESSION['id_coordinador'] ?? 0);
if ($id_coordinador <= 0) jexit(['success'=>false,'message'=>'Sesión sin coordinador'], 401);

$in = read_json();
$id = (int)($in['id'] ?? 0);
$codigo = trim((string)($in['codigo'] ?? ''));

if ($id <= 0 && $codigo === '') jexit(['success'=>false,'message'=>'Envía id o codigo'], 422);

require_once __DIR__ . '/../../conex.php';
$db = $conn ?? null;
if (!$db instanceof mysqli) jexit(['success'=>false,'message'=>'Sin conexión BD'], 500);
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

$sql = "
SELECT
  r.id, r.codigo, r.estado, r.fecha_hora, r.id_usuario, r.id_canillita, r.id_admin, r.id_coordinador,
  COALESCE(c.canillita,''), COALESCE(u.usuario,'')
FROM tbr_raspadita r
LEFT JOIN tbr_canillita c ON c.id=r.id_canillita
LEFT JOIN tbr_usuario u ON u.idusuario=r.id_usuario
WHERE r.id_coordinador=?
  AND " . ($id > 0 ? "r.id=?" : "r.codigo=?") . "
LIMIT 1
";

$stmt = mysqli_prepare($db, $sql);
if (!$stmt) jexit(['success'=>false,'message'=>'SQL detalle error'], 500);

if ($id > 0) mysqli_stmt_bind_param($stmt, "ii", $id_coordinador, $id);
else mysqli_stmt_bind_param($stmt, "is", $id_coordinador, $codigo);

mysqli_stmt_execute($stmt);
mysqli_stmt_store_result($stmt);

if (mysqli_stmt_num_rows($stmt) < 1) {
  mysqli_stmt_close($stmt);
  jexit(['success'=>false,'message'=>'No encontrado'], 404);
}

mysqli_stmt_bind_result($stmt, $rid, $rcod, $rest, $rfecha, $rid_usuario, $rid_can, $rid_admin, $rid_coord, $canillita, $usuario_pv);
mysqli_stmt_fetch($stmt);
mysqli_stmt_close($stmt);

$estadoTxt = match ((int)$rest) {
  1 => 'ASIGNADA',
  2 => 'ENTREGADA',
  3 => 'VENDIDA',
  8 => 'PAGADA',
  default => 'DESCONOCIDO'
};

jexit([
  'success' => true,
  'item' => [
    'id' => (int)$rid,
    'codigo' => (string)$rcod,
    'estado' => (int)$rest,
    'estado_txt' => $estadoTxt,
    'fecha_hora' => (string)$rfecha,
    'id_usuario' => (int)$rid_usuario,
    'usuario_pv' => (string)$usuario_pv,
    'id_canillita' => (int)$rid_can,
    'canillita' => (string)$canillita,
    'id_admin' => (int)$rid_admin,
    'id_coordinador' => (int)$rid_coord
  ]
]);