<?php
// views/pages/raspadita/api/raspadita_delete_coord.php
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') {
  http_response_code(204);
  exit;
}
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Método no permitido. Use POST'], JSON_UNESCAPED_UNICODE);
  exit;
}

function jexit(array $p, int $code=200): void {
  http_response_code($code);
  echo json_encode($p, JSON_UNESCAPED_UNICODE);
  exit;
}

$raw = file_get_contents('php://input');
$in = json_decode($raw ?: '', true);
if (!is_array($in)) {
  jexit(['success'=>false,'message'=>'JSON inválido'], 400);
}

$codigo = preg_replace('/\s+/', '', (string)($in['codigo'] ?? ''));
$codigo = trim($codigo);

if ($codigo === '') {
  jexit(['success'=>false,'message'=>'Código requerido'], 400);
}

require_once __DIR__ . '/../../conex.php';
$db = $conn ?? null;
if (!$db instanceof mysqli) jexit(['success'=>false,'message'=>'Sin conexión BD'], 500);
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

try {
  // ✅ Busca el registro y valida que tenga coordinador y no esté anulado
  $sql = "SELECT id, COALESCE(id_coordinador,0) AS id_coordinador
          FROM tbr_raspadita
          WHERE codigo = ?
            AND anulado = 0
          LIMIT 1";
  $st = mysqli_prepare($db, $sql);
  mysqli_stmt_bind_param($st, "s", $codigo);
  mysqli_stmt_execute($st);
  $rs = mysqli_stmt_get_result($st);
  $row = $rs ? mysqli_fetch_assoc($rs) : null;
  mysqli_stmt_close($st);

  if (!$row) {
    jexit(['success'=>false,'message'=>'No se encontró la serie (o está anulada)'], 404);
  }

  $id = (int)$row['id'];
  $id_coord = (int)$row['id_coordinador'];

  if ($id_coord <= 0) {
    jexit(['success'=>false,'message'=>'La serie no tenía coordinador asignado'], 409);
  }

  // ✅ Quita coordinador (NO anula, solo desasigna)
  $up = mysqli_prepare($db, "UPDATE tbr_raspadita SET id_coordinador = NULL WHERE id = ? LIMIT 1");
  mysqli_stmt_bind_param($up, "i", $id);
  mysqli_stmt_execute($up);
  $aff = mysqli_stmt_affected_rows($up);
  mysqli_stmt_close($up);

  if ($aff <= 0) {
    jexit(['success'=>false,'message'=>'No se pudo desasignar (ya estaba sin coordinador)'], 409);
  }

  jexit([
    'success'=>true,
    'message'=>"Asignación eliminada",
    'codigo'=>$codigo,
    'id'=>$id
  ]);
} catch (Throwable $e) {
  jexit(['success'=>false,'message'=>'Error en servidor','detail'=>$e->getMessage()], 500);
}
