<?php
// views/pages/raspadita/api/raspadita_check_asignada.php
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Método no permitido. Use POST'], JSON_UNESCAPED_UNICODE);
  exit;
}

function jexit(array $payload, int $code=200): void {
  http_response_code($code);
  echo json_encode($payload, JSON_UNESCAPED_UNICODE);
  exit;
}
function read_json(): array {
  $raw = file_get_contents('php://input');
  if (!$raw) return [];
  $j = json_decode($raw, true);
  return is_array($j) ? $j : [];
}

try {
  if (!isset($_SESSION['idusuario'])) jexit(['success'=>false,'message'=>'Sesión no iniciada'], 401);
  $id_usuario = (int)$_SESSION['idusuario'];

  $in = read_json();
  $codigo = isset($in['codigo']) ? trim((string)$in['codigo']) : '';
  if ($codigo === '') jexit(['success'=>false,'message'=>'Código requerido'], 422);

  require_once __DIR__ . '/../../conex.php';
  $db = $conn ?? null;
  if (!$db instanceof mysqli) jexit(['success'=>false,'message'=>'Sin conexión BD'], 500);
  mysqli_set_charset($db, 'utf8mb4');

  $sql = "SELECT id, codigo, estado, anulado, id_usuario, fecha_hora
          FROM tbr_raspadita
          WHERE codigo = ?
            AND estado = 1
            AND anulado = 0
            AND id_usuario = ?
          LIMIT 1";

  $st = $db->prepare($sql);
  if (!$st) jexit(['success'=>false,'message'=>'Error prepare','detail'=>$db->error], 500);

  $st->bind_param('si', $codigo, $id_usuario);
  $st->execute();
  $res = $st->get_result();
  $row = $res ? $res->fetch_assoc() : null;
  $st->close();

  if (!$row) {
    jexit(['success'=>true,'asignada'=>false,'message'=>'Este código NO está asignado a tu usuario.']);
  }

  jexit([
    'success'=>true,
    'asignada'=>true,
    'message'=>'Código válido: asignado a tu usuario.',
    'data'=>[
      'id'=>(int)$row['id'],
      'codigo'=>(string)$row['codigo'],
      'id_usuario'=>(int)$row['id_usuario'],
      'estado'=>(int)$row['estado'],
      'anulado'=>(int)$row['anulado'],
      'fecha_hora'=>(string)($row['fecha_hora'] ?? '')
    ]
  ]);

} catch (Throwable $e) {
  jexit(['success'=>false,'message'=>'Error interno','detail'=>$e->getMessage()], 500);
}
