<?php
// views/pages/raspadita/api/raspadita_canillita_check.php
// ✅ Verifica si un código pertenece al usuario y está disponible para asignar a canillita
// POST JSON: { "codigo":"ABC123" }
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Use POST'], JSON_UNESCAPED_UNICODE);
  exit;
}

function jexit(array $p, int $c=200): void {
  http_response_code($c);
  echo json_encode($p, JSON_UNESCAPED_UNICODE);
  exit;
}
function read_json(): array {
  $raw = file_get_contents('php://input');
  $j = $raw ? json_decode($raw, true) : [];
  return is_array($j) ? $j : [];
}

if (!isset($_SESSION['idusuario'])) jexit(['success'=>false,'message'=>'Sesión no iniciada'], 401);
$id_usuario = (int)$_SESSION['idusuario'];

$in = read_json();
$codigo = trim((string)($in['codigo'] ?? ''));
$codigo = preg_replace('/[^\p{L}\p{N}\-_]/u', '', $codigo);

if ($codigo === '' || mb_strlen($codigo) < 4) {
  jexit(['success'=>false,'message'=>'Código inválido'], 400);
}

require_once __DIR__ . '/../../conex.php';
$db = $conn ?? null;
if (!$db instanceof mysqli) jexit(['success'=>false,'message'=>'Sin conexión BD'], 500);
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

$sql = "SELECT id, codigo, estado, anulado, id_usuario, id_canillita
        FROM tbr_raspadita
        WHERE codigo = ?
        LIMIT 1";
$st = $db->prepare($sql);
if (!$st) jexit(['success'=>false,'message'=>'Error prepare','detail'=>$db->error], 500);

$st->bind_param('s', $codigo);
$st->execute();
$res = $st->get_result();
$row = $res ? $res->fetch_assoc() : null;
$st->close();

if (!$row) jexit(['success'=>false,'message'=>'No existe ese código'], 404);

if ((int)$row['anulado'] === 1) jexit(['success'=>false,'message'=>'Código anulado'], 403);
if ((int)$row['id_usuario'] !== $id_usuario) jexit(['success'=>false,'message'=>'Este código NO pertenece a tu usuario'], 403);
if ((int)$row['estado'] !== 1) jexit(['success'=>false,'message'=>'Este código no está disponible (debe estar estado=1)'], 409);

jexit([
  'success'=>true,
  'message'=>'OK: disponible para asignar',
  'data'=>[
    'codigo'=>$row['codigo'],
    'estado'=>(int)$row['estado'],
    'id_canillita'=>(int)($row['id_canillita'] ?? 0)
  ]
], 200);
