<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

date_default_timezone_set('America/Guayaquil');

function jexit(array $payload, int $code=200): void {
  http_response_code($code);
  echo json_encode($payload, JSON_UNESCAPED_UNICODE);
  exit;
}
function read_json(): array {
  $raw = file_get_contents('php://input');
  if (!$raw) return [];
  $data = json_decode($raw, true);
  return is_array($data) ? $data : [];
}
function norm(string $s): string {
  $s = trim($s);
  $s = preg_replace('/\s+/', '', $s);
  return (string)$s;
}

/* ✅ Evita warning de session id inválida (Postman/cookies dañadas) */
$sn = session_name();
if (isset($_COOKIE[$sn])) {
  $sid = (string)$_COOKIE[$sn];
  if (!preg_match('/^[A-Za-z0-9,-]{1,128}$/', $sid)) {
    setcookie($sn, '', time() - 3600, '/');
    unset($_COOKIE[$sn]);
  }
}

session_start();

$id_admin = (int)($_SESSION['idusuario'] ?? 0);
if ($id_admin <= 0) {
  jexit(['success'=>false,'message'=>'Sesión no iniciada'], 401);
}

require_once __DIR__ . '/../../conex.php'; // ajusta si tu ruta cambia
$db = $conn ?? null;
if (!$db instanceof mysqli) {
  jexit(['success'=>false,'message'=>'Sin conexión BD'], 500);
}
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

/* Entrada */
$in = read_json();
$codigo = norm((string)($in['codigo'] ?? $in['serie'] ?? ''));

if ($codigo === '') {
  jexit(['success'=>false,'message'=>'Debe enviar "codigo"'], 422);
}

/*
  ✅ Define aquí el estado numérico de "ANULADO"
  Si tú manejas otro valor, cámbialo.
*/
$ESTADO_ANULADO = 0;

$ip  = (string)($_SERVER['REMOTE_ADDR'] ?? '');
$now = date('Y-m-d H:i:s'); // OK para VARCHAR

/* 1) Validar existencia */
$stmt = mysqli_prepare($db, "SELECT id, anulado, estado FROM tbr_raspadita WHERE codigo=? LIMIT 1");
if (!$stmt) jexit(['success'=>false,'message'=>'Error prepare SELECT','detail'=>mysqli_error($db)], 500);

mysqli_stmt_bind_param($stmt, "s", $codigo);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$row = mysqli_fetch_assoc($res) ?: null;
mysqli_stmt_close($stmt);

if (!$row) {
  jexit(['success'=>false,'message'=>'No existe ese código','codigo'=>$codigo], 404);
}

if ((int)$row['anulado'] === 1) {
  jexit(['success'=>false,'message'=>'Ya estaba anulado','codigo'=>$codigo], 409);
}

/* 2) ✅ ANULAR TODO EL REGISTRO (eliminación lógica) */
$stmt = mysqli_prepare($db, "
  UPDATE tbr_raspadita
  SET anulado=1,
      estado=?,
      id_admin=?,
      ip=?,
      fecha_hora=?
  WHERE codigo=? AND anulado=0
  LIMIT 1
");
if (!$stmt) jexit(['success'=>false,'message'=>'Error prepare UPDATE','detail'=>mysqli_error($db)], 500);

mysqli_stmt_bind_param($stmt, "iisss", $ESTADO_ANULADO, $id_admin, $ip, $now, $codigo);

$ok  = mysqli_stmt_execute($stmt);
$aff = mysqli_stmt_affected_rows($stmt);
$err = mysqli_stmt_error($stmt);
mysqli_stmt_close($stmt);

if (!$ok) {
  jexit(['success'=>false,'message'=>'No se pudo eliminar','detail'=>$err], 500);
}
if ($aff <= 0) {
  jexit(['success'=>false,'message'=>'No se pudo eliminar (ya estaba anulado o no coincide)','codigo'=>$codigo], 409);
}

jexit([
  'success'=>true,
  'message'=>'Asignación anulada correctamente',
  'codigo'=>$codigo,
  'estado'=>$ESTADO_ANULADO
]);
