<?php
// views/pages/raspadita/api/pv_toggle_raspadita.php
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

ini_set('display_errors','0');
ini_set('log_errors','1');
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

function jexit(array $p, int $code=200): void {
  http_response_code($code);
  echo json_encode($p, JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_SUBSTITUTE);
  exit;
}

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') jexit(['success'=>false,'message'=>'Use POST'], 405);

$in = json_decode(file_get_contents('php://input') ?: '[]', true);
if (!is_array($in)) jexit(['success'=>false,'message'=>'JSON inválido'], 400);

$idusuario = (int)($in['idusuario'] ?? 0);
$raspadita = (int)($in['raspadita'] ?? -1);

if ($idusuario <= 0) jexit(['success'=>false,'message'=>'idusuario inválido'], 400);
if (!in_array($raspadita, [0,1], true)) jexit(['success'=>false,'message'=>'raspadita inválido'], 400);

require __DIR__ . '/../../conex.php';
$cn = $conn ?? ($conex ?? null);
if (!$cn instanceof mysqli) jexit(['success'=>false,'message'=>'Sin conexión BD'], 500);
mysqli_set_charset($cn, 'utf8mb4');

$st = $cn->prepare("UPDATE tbr_usuario
                    SET raspadita=?
                    WHERE idusuario=? AND id_rol=2 AND condicion=1");
if (!$st) jexit(['success'=>false,'message'=>'Prepare fail','detail'=>$cn->error], 500);

$st->bind_param('ii', $raspadita, $idusuario);
if (!$st->execute()) jexit(['success'=>false,'message'=>'No se pudo actualizar','detail'=>$st->error], 500);

jexit(['success'=>true,'message'=>'Raspadita actualizada ✅']);
