<?php
// views/pages/raspadita/api/pv_save_simple.php
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

ini_set('display_errors','0');
ini_set('log_errors','1');
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

function jexit(array $p, int $code=200): void {
  http_response_code($code);
  echo json_encode($p, JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_SUBSTITUTE);
  exit;
}

set_exception_handler(function($e){
  jexit(['success'=>false,'message'=>'Error servidor','detail'=>$e->getMessage()], 500);
});

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') jexit(['success'=>false,'message'=>'Use POST'], 405);

$in = json_decode(file_get_contents('php://input') ?: '[]', true);
if (!is_array($in)) jexit(['success'=>false,'message'=>'JSON inválido'], 400);

$idusuario   = (int)($in['idusuario'] ?? 0);
$usuario     = trim((string)($in['usuario'] ?? ''));
$clave       = trim((string)($in['clave'] ?? ''));
$activo      = (int)($in['activo'] ?? 1);
$id_sucursal = (int)($in['id_sucursal'] ?? 0);
$raspadita   = (int)($in['raspadita'] ?? 1);

if ($usuario === '') jexit(['success'=>false,'message'=>'Usuario es obligatorio'], 400);
if ($id_sucursal <= 0) jexit(['success'=>false,'message'=>'Seleccione una sucursal'], 400);

require __DIR__ . '/../../conex.php';
$cn = $conn ?? ($conex ?? null);
if (!$cn instanceof mysqli) jexit(['success'=>false,'message'=>'Sin conexión BD'], 500);
mysqli_set_charset($cn, 'utf8mb4');

// ✅ Crear
if ($idusuario <= 0) {
  if ($clave === '') jexit(['success'=>false,'message'=>'Clave obligatoria al crear'], 400);

  // validar duplicado
  $chk = $cn->prepare("SELECT 1 FROM tbr_usuario WHERE usuario=? LIMIT 1");
  if (!$chk) jexit(['success'=>false,'message'=>'Prepare fail','detail'=>$cn->error], 500);
  $chk->bind_param('s', $usuario);
  $chk->execute();
  $chk->store_result();
  if ($chk->num_rows > 0) jexit(['success'=>false,'message'=>'Ese usuario ya existe'], 400);
  $chk->close();

  // ✅ NO HASH para evitar "Data too long" (tu columna clave es corta)
  $st = $cn->prepare("INSERT INTO tbr_usuario (usuario, clave, activo, id_sucursal, id_rol, condicion, raspadita)
                      VALUES (?, ?, ?, ?, 2, 1, ?)");
  if (!$st) jexit(['success'=>false,'message'=>'Prepare fail','detail'=>$cn->error], 500);

  $st->bind_param('ssiii', $usuario, $clave, $activo, $id_sucursal, $raspadita);
  if (!$st->execute()) jexit(['success'=>false,'message'=>'No se pudo insertar','detail'=>$st->error], 500);

  jexit(['success'=>true,'message'=>'Punto creado ✅','idusuario'=>$st->insert_id]);
}

// ✅ Editar
if ($clave !== '') {
  $st = $cn->prepare("UPDATE tbr_usuario
                      SET usuario=?, clave=?, activo=?, id_sucursal=?, raspadita=?
                      WHERE idusuario=? AND id_rol=2 AND condicion=1");
  if (!$st) jexit(['success'=>false,'message'=>'Prepare fail','detail'=>$cn->error], 500);

  $st->bind_param('ssiiii', $usuario, $clave, $activo, $id_sucursal, $raspadita, $idusuario);
} else {
  $st = $cn->prepare("UPDATE tbr_usuario
                      SET usuario=?, activo=?, id_sucursal=?, raspadita=?
                      WHERE idusuario=? AND id_rol=2 AND condicion=1");
  if (!$st) jexit(['success'=>false,'message'=>'Prepare fail','detail'=>$cn->error], 500);

  $st->bind_param('siiii', $usuario, $activo, $id_sucursal, $raspadita, $idusuario);
}

if (!$st->execute()) jexit(['success'=>false,'message'=>'No se pudo actualizar','detail'=>$st->error], 500);

jexit(['success'=>true,'message'=>'Actualizado ✅']);
