<?php
// views/pages/raspadita/api/entrega_lista.php
// ✅ Lista entregas reales desde BD (tbr_raspadita)
// Devuelve códigos asignados a canillitas del usuario en sesión.

declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Use GET'], JSON_UNESCAPED_UNICODE);
  exit;
}

function jexit(array $p, int $c=200): void {
  http_response_code($c);
  echo json_encode($p, JSON_UNESCAPED_UNICODE);
  exit;
}

if (!isset($_SESSION['idusuario'])) jexit(['success'=>false,'message'=>'Sesión no iniciada'], 401);
$id_usuario = (int)$_SESSION['idusuario'];

require_once __DIR__ . '/../../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) jexit(['success'=>false,'message'=>'Sin conexión BD'], 500);
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

// ✅ Importante: aquí asumimos que "entregada" = estado=2 y tiene id_canillita
// Si luego cambias estados, ajustas este WHERE.
$sql = "SELECT
          r.id,
          DATE_FORMAT(r.fecha_hora, '%Y-%m-%d %H:%i') AS fecha,
          r.codigo AS serie,
          r.id_canillita,
          c.canillita
        FROM tbr_raspadita r
        LEFT JOIN tbr_canillita c ON c.id = r.id_canillita
        WHERE r.id_usuario = ?
          AND r.anulado = 0
          AND r.estado = 2
          AND r.id_canillita IS NOT NULL
        ORDER BY r.fecha_hora DESC
        LIMIT 500";

$st = $db->prepare($sql);
if (!$st) jexit(['success'=>false,'message'=>'Error SQL','detail'=>$db->error], 500);

$st->bind_param('i', $id_usuario);
$st->execute();
$st->bind_result($id, $fecha, $serie, $id_canillita, $canillita);

$data = [];
while ($st->fetch()) {
  $data[] = [
    'id' => (int)$id,                 // id real de tbr_raspadita
    'fecha' => (string)$fecha,
    'canillita' => (string)($canillita ?? ''),
    'serie' => (string)$serie,
    'id_canillita' => (int)($id_canillita ?? 0),
  ];
}
$st->close();

jexit([
  'success'=>true,
  'data'=>$data,
  'total_entregadas'=>count($data)
], 200);
