<?php
// views/pages/raspadita/api/entrega_add.php
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') { http_response_code(405); echo json_encode(['success'=>false,'message'=>'Use POST']); exit; }
if (!isset($_SESSION['idusuario'])) { http_response_code(401); echo json_encode(['success'=>false,'message'=>'Sesión no iniciada']); exit; }

function jexit(array $p, int $c=200): void { http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE); exit; }

$raw = file_get_contents('php://input');
$in = $raw ? json_decode($raw, true) : [];
if (!is_array($in)) $in = [];

$onlySafe = function(string $s): string {
  $s = preg_replace('/[^\p{L}\p{N}\-_ ]/u', '', $s);
  return trim((string)$s);
};

$canillita = strtoupper($onlySafe((string)($in['canillita'] ?? '')));
$serie     = $onlySafe((string)($in['serie'] ?? ''));
$serie     = preg_replace('/[^\p{L}\p{N}\-_]/u', '', $serie);

if ($canillita === '') jexit(['success'=>false,'message'=>'Ingrese el Canillita.'], 400);
if ($serie === '' || mb_strlen($serie) < 4) jexit(['success'=>false,'message'=>'Ingrese un Código válido (mínimo 4).'], 400);

$id_usuario = (int)$_SESSION['idusuario'];

require_once __DIR__ . '/../../conex.php';
$db = $conn ?? null;
if (!$db instanceof mysqli) jexit(['success'=>false,'message'=>'Sin conexión BD'], 500);
mysqli_set_charset($db, 'utf8mb4');

// ✅ Validar asignación en tbr_raspadita
$sql = "SELECT id FROM tbr_raspadita
        WHERE codigo = ?
          AND estado = 1
          AND anulado = 0
          AND id_usuario = ?
        LIMIT 1";
$st = $db->prepare($sql);
if (!$st) jexit(['success'=>false,'message'=>'Error prepare','detail'=>$db->error], 500);
$st->bind_param('si', $serie, $id_usuario);
$st->execute();
$res = $st->get_result();
$ok = $res && $res->fetch_assoc();
$st->close();

if (!$ok) jexit(['success'=>false,'message'=>'❌ Código NO asignado a tu usuario.'], 403);

// ✅ Guardar en sesión
$_SESSION['rasp_entregas'] = $_SESSION['rasp_entregas'] ?? [];

foreach ($_SESSION['rasp_entregas'] as $it) {
  if (($it['serie'] ?? '') === $serie) jexit(['success'=>false,'message'=>'Ese código ya fue entregado (sesión).'], 409);
}

$nowFecha = date('Y-m-d');
$id = (int)(microtime(true) * 1000);

$_SESSION['rasp_entregas'][] = [
  'id'=>$id,
  'fecha'=>$nowFecha,
  'canillita'=>$canillita,
  'serie'=>$serie
];

$items = array_values($_SESSION['rasp_entregas']);

jexit([
  'success'=>true,
  'message'=>'Entrega registrada',
  'data'=>$items,
  'total_entregadas'=>count($items)
], 200);
