<?php
// views/pages/raspadita/api/coordinadores_select.php
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Método no permitido (use GET)'], JSON_UNESCAPED_UNICODE);
  exit;
}

function jexit(array $p, int $code=200): void {
  http_response_code($code);
  echo json_encode($p, JSON_UNESCAPED_UNICODE);
  exit;
}

if (!isset($_SESSION['idusuario'])) {
  jexit(['success'=>false,'message'=>'Sesión no válida'], 401);
}

// ✅ Conexión BD (CORRECTO desde /raspadita/api/)
require_once __DIR__ . '/../../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) jexit(['success'=>false,'message'=>'Sin conexión BD'], 500);
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

// Filtro opcional: buscar por nombre o identificación
$q = trim((string)($_GET['q'] ?? ''));
$like = '%' . $q . '%';

try {
  if ($q !== '') {
    $stmt = mysqli_prepare($db, "
      SELECT id, indentificacion, nombre
      FROM tbr_coordinador
      WHERE activo = 1
        AND (indentificacion LIKE ? OR nombre LIKE ?)
      ORDER BY nombre ASC
      LIMIT 50
    ");
    mysqli_stmt_bind_param($stmt, "ss", $like, $like);
  } else {
    $stmt = mysqli_prepare($db, "
      SELECT id, indentificacion, nombre
      FROM tbr_coordinador
      WHERE activo = 1
      ORDER BY nombre ASC
      LIMIT 200
    ");
  }

  mysqli_stmt_execute($stmt);
  $res = mysqli_stmt_get_result($stmt);

  $out = [];
  while ($r = mysqli_fetch_assoc($res)) {
    $id  = (int)$r['id'];
    $txt = trim((string)$r['indentificacion']) . ' - ' . trim((string)$r['nombre']);
    $out[] = ['id'=>$id, 'text'=>$txt];
  }
  mysqli_stmt_close($stmt);

  jexit(['success'=>true,'results'=>$out]);

} catch (Throwable $e) {
  jexit(['success'=>false,'message'=>'Error', 'detail'=>$e->getMessage()], 500);
}
