<?php
// rifa_prueba/views/pages/raspadita/api/coordinador_list.php
declare(strict_types=1);
session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

require_once __DIR__ . '/../../conex.php';
$db = $conn ?? null;

if (!$db instanceof mysqli) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Sin conexión BD'], JSON_UNESCAPED_UNICODE);
  exit;
}

mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

$sql = "SELECT id, indentificacion, nombre
        FROM tbr_coordinador
        WHERE activo = 1
        ORDER BY nombre ASC
        LIMIT 500";

$stmt = mysqli_prepare($db, $sql);
if(!$stmt){
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Error preparando SQL'], JSON_UNESCAPED_UNICODE);
  exit;
}

mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);

$data = [];
while($row = mysqli_fetch_assoc($res)){
  $id = (int)$row['id'];
  $ced = trim((string)$row['indentificacion']);
  $nom = strtoupper(trim((string)$row['nombre']));

  // ✅ texto bonito para el select
  $text = $ced ? "{$nom} — {$ced}" : $nom;

  $data[] = [
    'id' => $id,
    'text' => $text
  ];
}

echo json_encode(['success'=>true,'data'=>$data], JSON_UNESCAPED_UNICODE);
