<?php
// views/pages/raspadita/api/canillita_list.php
// ✅ Lista canillitas activos para el select
declare(strict_types=1);

session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

if (!isset($_SESSION['idusuario'])) {
  http_response_code(401);
  echo json_encode(['success'=>false,'message'=>'Sesión no iniciada'], JSON_UNESCAPED_UNICODE);
  exit;
}

require_once __DIR__ . '/../../conex.php';
$db = $conn ?? null;
if (!$db instanceof mysqli) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Sin conexión BD'], JSON_UNESCAPED_UNICODE);
  exit;
}
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

$sql = "SELECT id, canillita
        FROM tbr_canillita
        WHERE activo = 1
        ORDER BY canillita ASC";
$res = $db->query($sql);

$data = [];
if ($res) {
  while ($row = $res->fetch_assoc()) {
    $data[] = [
      'id' => (int)$row['id'],
      'canillita' => (string)$row['canillita']
    ];
  }
}

echo json_encode(['success'=>true,'data'=>$data], JSON_UNESCAPED_UNICODE);
