<?php
// views/pages/raspadita/admin_coordinador.php — ULTRA PRO (COMPLETO)
// ✅ Lista siempre al cargar: estados 1,2,3 del coordinador (NO incluye 8)
// ✅ Asignar SOLO por códigos a PV o Canillita
// ✅ En pestaña ASIGNAR: muestra valores individuales por código, Subtotal, Descuento (%) y Total
// ✅ Estado cambia a 2 al asignar (eso lo hace tu API coordinador_asignar.php)
// ✅ Pestaña DEVOLUCIÓN: devolver por códigos y RESTAR saldo al PV o Canillita (API coordinador_devolver.php)
// ✅ Pestaña COBRAR SALDOS: cobrar saldos PV/CAN y registrar en tbr_raspadita_cobro
// ✅ NUEVO: Pestaña REPORTE con rango de fechas + filtro por PV/CAN usando:
//    - views/pages/raspadita/api/pv_list_simple.php
//    - views/pages/raspadita/api/canillitas_list.php
// 🔥 REPORTE: cuenta vendidas estado=3, premios pagados estado=8, neto = totalVendido - premiosPagados
// 🔥 REPORTE: tabla muestra 3 y 8 (requiere que API_LISTADO soporte incluir_pagadas=true)

declare(strict_types=1);
session_start();
date_default_timezone_set('America/Guayaquil');

if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') { header("Location: login.php"); exit; }
if ((int)($_SESSION['id_rol'] ?? 0) !== 7) { header("Location: login.php"); exit; }

$usuario = htmlspecialchars((string)($_SESSION['usuario'] ?? ''), ENT_QUOTES, 'UTF-8');
$nombre  = htmlspecialchars((string)($_SESSION['nombre'] ?? ''), ENT_QUOTES, 'UTF-8');
$idCoord = (int)($_SESSION['id_coordinador'] ?? 0);
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Coordinador · Raspaditas</title>

  <link rel="shortcut icon" href="../resources/img/crud.ico">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.10.8/dist/sweetalert2.min.css" rel="stylesheet">

  <style>
    :root{
      --bg:#0b1020; --card:#111a33; --card2:#0f1730;
      --border:rgba(255,255,255,.10);
      --text:#e8edf7; --muted:rgba(255,255,255,.68);
      --cyan:#22d3ee; --amber:#f59e0b; --green:#22c55e; --purple:#a855f7;
      --danger:#ef4444;
    }
    body{ background: linear-gradient(180deg, #070a14, var(--bg)); color:var(--text); font-size:15px; }
    .navbar{ background: rgba(10,14,28,.82); border-bottom:1px solid var(--border); backdrop-filter: blur(10px); }
    .brand-dot{ width:10px;height:10px;border-radius:50%; background: var(--cyan); box-shadow:0 0 18px rgba(34,211,238,.55); display:inline-block; margin-right:10px; }
    .app-wrap{ max-width: 1400px; margin: 0 auto; padding: 14px; }
    .card{ border:1px solid var(--border); background: linear-gradient(180deg, var(--card), var(--card2)); border-radius:16px; }
    .kpi{
      padding:12px 14px; border-radius:16px; border:1px solid var(--border);
      background: rgba(255,255,255,.04);
      display:flex; gap:12px; align-items:center; height: 100%;
    }
    .kpi .ico{
      width:42px;height:42px;border-radius:14px; display:flex; align-items:center; justify-content:center;
      border:1px solid var(--border); background: rgba(255,255,255,.06);
    }
    .kpi .label{ color:var(--muted); font-weight:900; font-size:.85rem; }
    .kpi .value{ font-weight:900; font-size:1.18rem; line-height:1.1; color:#fff !important; }

    .btn-soft{
      border:1px solid var(--border);
      background: rgba(255,255,255,.06);
      color: var(--text);
      border-radius: 12px;
    }
    .btn-soft:hover{ background: rgba(255,255,255,.09); color: var(--text); }
    .badge-soft{
      border:1px solid var(--border);
      background: rgba(255,255,255,.06);
      color: var(--muted);
      border-radius: 999px;
      padding:.35rem .65rem;
      font-weight:900;
    }
    .hr-soft{ border-color: var(--border); opacity: 1; }

    .table thead th{ color: rgba(255,255,255,.82); }
    .dataTables_wrapper .dataTables_filter input,
    .dataTables_wrapper .dataTables_length select{
      background: rgba(255,255,255,.10) !important;
      color: var(--text) !important;
      border: 1px solid var(--border) !important;
      border-radius: 10px !important;
    }

    .nav-tabs .nav-link{
      border: 1px solid var(--border);
      background: rgba(255,255,255,.05);
      color: rgba(255,255,255,.82);
      border-radius: 12px 12px 0 0;
      font-weight: 900;
    }
    .nav-tabs .nav-link.active{
      background: rgba(34,211,238,.10);
      border-color: rgba(34,211,238,.35);
      color: #fff;
    }

    .form-control, .form-select{
      background: rgba(255,255,255,.10) !important;
      color: var(--text) !important;
      border: 1px solid var(--border) !important;
      border-radius: 12px !important;
    }
    .form-control::placeholder{ color: rgba(255,255,255,.60); }

    select.form-select option{
      background-color: #0f1730 !important;
      color: #e8edf7 !important;
    }

    .pill{
      display:inline-flex;
      gap:8px;
      align-items:center;
      padding:.25rem .6rem;
      border-radius:999px;
      border:1px solid var(--border);
      background: rgba(255,255,255,.06);
      font-weight:900;
      color:#fff;
      white-space:nowrap;
    }
    .pill.s1{ box-shadow: 0 0 0 1px rgba(245,158,11,.16) inset; }
    .pill.s2{ box-shadow: 0 0 0 1px rgba(34,211,238,.16) inset; }
    .pill.s3{ box-shadow: 0 0 0 1px rgba(34,197,94,.16) inset; }
    .pill.s8{ box-shadow: 0 0 0 1px rgba(168,85,247,.18) inset; }

    .mini-note{ color: var(--muted); font-weight:800; }

    .tiny-table{
      border:1px solid var(--border);
      border-radius:14px;
      overflow:hidden;
    }
    .tiny-table table{ margin:0; }
    .tiny-table thead th{
      background: rgba(255,255,255,.06);
      color: rgba(255,255,255,.86);
      font-weight:900;
      border-color: var(--border);
    }
    .tiny-table td{ border-color: var(--border); }
    .code-badge{
      font-weight:900;
      border:1px solid var(--border);
      background: rgba(255,255,255,.06);
      padding:.2rem .5rem;
      border-radius:999px;
      display:inline-block;
    }
    .st-ok{ color: #86efac; font-weight:900; }
    .st-bad{ color: #fecaca; font-weight:900; }
  </style>
</head>

<body>

<nav class="navbar navbar-expand-lg navbar-dark sticky-top">
  <div class="container-fluid px-3">
    <a class="navbar-brand fw-bold" href="#">
      <span class="brand-dot"></span> RASPADITAS · COORDINADOR
    </a>

    <div class="d-flex align-items-center gap-2 ms-auto">
      <span class="badge-soft d-none d-md-inline">
        <i class="fa-solid fa-user-shield"></i> <?= ($nombre !== '' ? $nombre : $usuario) ?>
      </span>

      <button class="btn btn-soft" type="button" id="btnReload" title="Actualizar">
        <i class="fa-solid fa-rotate"></i>
      </button>

      <button class="btn btn-soft" type="button" id="btnLogout" title="Cerrar sesión">
        <i class="fa-solid fa-right-from-bracket"></i>
      </button>
    </div>
  </div>
</nav>

<div class="app-wrap">

  <div class="row g-3">
    <div class="col-12 col-xl-4">
      <div class="card p-3">
        <div class="d-flex align-items-center justify-content-between">
          <div>
            <div class="fw-bold">Modo Coordinador</div>
            <div class="mini-note">Usuario: <b><?= $usuario ?></b></div>
            <div class="mini-note">ID Coordinador: <b><?= (int)$idCoord ?></b></div>
          </div>
          <div class="text-end">
            <span class="badge-soft"><i class="fa-solid fa-id-badge"></i> ROL 7</span>
          </div>
        </div>
        <hr class="hr-soft my-3">
        <div class="mini-note">
          Solo reparto: asignar raspaditas a <b>Puntos</b> o <b>Canillitas</b> por <b>código</b>.
        </div>
      </div>
    </div>

    <div class="col-12 col-xl-8">
      <div class="row g-3">
        <div class="col-12 col-md-4">
          <div class="kpi">
            <div class="ico"><i class="fa-solid fa-wallet" style="color:var(--cyan)"></i></div>
            <div class="w-100">
              <div class="label">Saldo</div>
              <div class="value" id="kpiSaldo">$0.00</div>
            </div>
          </div>
        </div>
        <div class="col-12 col-md-4">
          <div class="kpi">
            <div class="ico"><i class="fa-solid fa-layer-group" style="color:#fff"></i></div>
            <div class="w-100">
              <div class="label">Total (1-3)</div>
              <div class="value" id="kpiTotal123">0</div>
            </div>
          </div>
        </div>
        <div class="col-12 col-md-4">
          <div class="kpi">
            <div class="ico"><i class="fa-solid fa-cash-register" style="color:var(--green)"></i></div>
            <div class="w-100">
              <div class="label">Vendidas HOY</div>
              <div class="value" id="kpiVenHoy">0</div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Tabs -->
  <div class="card p-3 mt-3">
    <ul class="nav nav-tabs" id="tabsCoord" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="tab-listado" data-bs-toggle="tab" data-bs-target="#pane-listado" type="button" role="tab">
          <i class="fa-solid fa-table"></i> LISTADO (1-3)
        </button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="tab-asignar" data-bs-toggle="tab" data-bs-target="#pane-asignar" type="button" role="tab">
          <i class="fa-solid fa-share-nodes"></i> ASIGNAR (CÓDIGOS + COBRO)
        </button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="tab-devolucion" data-bs-toggle="tab" data-bs-target="#pane-devolucion" type="button" role="tab">
          <i class="fa-solid fa-rotate-left"></i> DEVOLUCIÓN
        </button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="tab-cobros" data-bs-toggle="tab" data-bs-target="#pane-cobros" type="button" role="tab">
          <i class="fa-solid fa-hand-holding-dollar"></i> COBRAR SALDOS
        </button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="tab-reporte" data-bs-toggle="tab" data-bs-target="#pane-reporte" type="button" role="tab">
          <i class="fa-solid fa-chart-line"></i> REPORTE
        </button>
      </li>
    </ul>

    <div class="tab-content pt-3">

      <!-- LISTADO -->
      <div class="tab-pane fade show active" id="pane-listado" role="tabpanel">
        <div class="fw-bold">Mis raspaditas (estado 1, 2, 3)</div>
        <div class="mini-note">Al cargar: muestra todas. (El coordinador NO paga premios)</div>

        <hr class="hr-soft my-3">

        <div class="table-responsive">
          <table id="tbl" class="table table-dark table-striped align-middle w-100">
            <thead>
              <tr>
                <th>Fecha</th>
                <th>Código</th>
                <th>Valor</th>
                <th>Estado</th>
                <th>Asignado a</th>
                <th style="width:110px;">Acción</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>

        <div class="mt-2 d-none" id="hintApis" style="color:#fecaca;font-weight:800;">
          No se pudo cargar desde API. Revisa endpoints y sesión.
        </div>
      </div>

      <!-- ASIGNAR -->
      <div class="tab-pane fade" id="pane-asignar" role="tabpanel">

        <div class="row g-3">
          <div class="col-12 col-lg-4">
            <div class="kpi">
              <div class="ico"><i class="fa-solid fa-boxes-stacked" style="color:var(--cyan)"></i></div>
              <div class="w-100">
                <div class="label">Stock disponible para asignar</div>
                <div class="value" id="kpiStock">0</div>
              </div>
            </div>
            <div class="mt-2 mini-note">
              Stock = <b>estado 1</b> y sin destino (PV=0 y Canillita=0)
            </div>
          </div>

          <div class="col-12 col-lg-8">
            <div class="card p-3">
              <div class="fw-bold mb-2"><i class="fa-solid fa-share-nodes"></i> Asignar por códigos</div>

              <div class="row g-2">
                <div class="col-12 col-md-4">
                  <label class="fw-bold mini-note">Tipo destino</label>
                  <select id="tipoDestino" class="form-select">
                    <option value="PV">Punto de venta</option>
                    <option value="CAN">Canillita</option>
                  </select>
                </div>

                <div class="col-12 col-md-8">
                  <label class="fw-bold mini-note">Destino</label>
                  <select id="destino" class="form-select"></select>
                </div>

                <div class="col-12">
                  <label class="fw-bold mini-note">Códigos (uno por línea)</label>
                  <textarea id="codigos" class="form-control" rows="8" placeholder="ABC123&#10;ABC124&#10;ABC125"></textarea>
                  <div class="mini-note mt-1">
                    Se valida en vivo: <b>existe</b> · <b>es tuya</b> · <b>estado=1</b>.
                  </div>
                </div>

                <!-- LISTA DE CÓDIGOS + VALORES -->
                <div class="col-12">
                  <div class="tiny-table">
                    <table class="table table-dark table-striped align-middle">
                      <thead>
                        <tr>
                          <th style="width:55%;">Código</th>
                          <th style="width:20%;">Valor</th>
                          <th style="width:25%;">Estado</th>
                        </tr>
                      </thead>
                      <tbody id="tbodyPreview">
                        <tr><td colspan="3" class="mini-note">Escribe códigos para ver valores…</td></tr>
                      </tbody>
                    </table>
                  </div>
                  <div class="mini-note mt-2" id="previewMsg">—</div>
                </div>

                <div class="col-12">
                  <hr class="hr-soft my-2">
                  <div class="card p-3">
                    <div class="fw-bold mb-2"><i class="fa-solid fa-calculator"></i> Totales / Cobro</div>

                    <div class="row g-2 align-items-end">
                      <div class="col-12 col-md-3">
                        <label class="fw-bold mini-note">Tipo pago</label>
                        <select id="tipoPagoAsig" class="form-select">
                          <option value="efectivo">Efectivo</option>
                          <option value="credito">Crédito</option>
                        </select>
                      </div>

                      <div class="col-12 col-md-3">
                        <label class="fw-bold mini-note">Descuento (%)</label>
                        <input id="descAsig" type="number" step="0.01" min="0" max="100" class="form-control" value="0.00" placeholder="Ej: 10">
                      </div>

                      <div class="col-12 col-md-3">
                        <div class="badge-soft w-100">Códigos: <b id="cntAsig">0</b></div>
                      </div>

                      <div class="col-12 col-md-3">
                        <div class="badge-soft w-100">Válidos: <b id="cntValidos">0</b></div>
                      </div>

                      <div class="col-12 col-md-4">
                        <div class="badge-soft w-100">Subtotal: <b id="subAsig">0.00</b></div>
                      </div>
                      <div class="col-12 col-md-4">
                        <div class="badge-soft w-100">Total a pagar: <b id="totAsig">0.00</b></div>
                      </div>
                      <div class="col-12 col-md-4">
                        <div class="badge-soft w-100">Saldo sumado: <b id="saldoSumado">NO</b></div>
                      </div>

                      <div class="col-12 mini-note">
                        * Subtotal = <b>SUM(tbr_raspadita.valor)</b> de códigos <b>válidos</b> (estado=1).<br>
                        * Total = <b>Subtotal - (Subtotal * Descuento/100)</b>.<br>
                        * Si es <b>Crédito</b>, se suma saldo al PV/CAN.
                      </div>
                    </div>

                  </div>
                </div>

                <div class="col-12 d-flex flex-wrap gap-2 mt-1">
                  <button class="btn btn-soft" type="button" id="btnStock">
                    <i class="fa-solid fa-arrows-rotate"></i> Actualizar stock
                  </button>
                  <button class="btn btn-success" type="button" id="btnAsignar">
                    <i class="fa-solid fa-circle-check"></i> Cobrar y asignar
                  </button>
                </div>

                <div class="col-12">
                  <div class="badge-soft w-100">
                    Resultado: <span id="resText">—</span>
                  </div>
                </div>

                <div class="col-12 d-none" id="resBox">
                  <div class="row g-2">
                    <div class="col-12 col-md-4">
                      <div class="badge-soft w-100">Asignados: <b id="resAsignados">0</b></div>
                    </div>
                    <div class="col-12 col-md-4">
                      <div class="badge-soft w-100">No encontrados: <b id="resNoFound">0</b></div>
                    </div>
                    <div class="col-12 col-md-4">
                      <div class="badge-soft w-100">No disponibles: <b id="resNoDisp">0</b></div>
                    </div>

                    <div class="col-12">
                      <label class="fw-bold mini-note">Fallidos (copiar/pegar)</label>
                      <textarea id="resFallidos" class="form-control" rows="6" readonly></textarea>
                    </div>
                  </div>
                </div>

                <div class="col-12 mini-note">
                  Si un código falla: puede ser <b>no existe</b>, <b>no es tuyo</b>, <b>no está en estado 1</b> o ya fue asignado.
                </div>
              </div>

            </div>
          </div>
        </div>

      </div>

      <!-- DEVOLUCIÓN -->
      <div class="tab-pane fade" id="pane-devolucion" role="tabpanel">
        <div class="row g-3">
          <div class="col-12 col-lg-8">
            <div class="card p-3">
              <div class="fw-bold mb-2"><i class="fa-solid fa-rotate-left"></i> Devolución por códigos</div>

              <div class="row g-2">
                <div class="col-12 col-md-4">
                  <label class="fw-bold mini-note">Tipo destino</label>
                  <select id="tipoDev" class="form-select">
                    <option value="PV">Punto de venta</option>
                    <option value="CAN">Canillita</option>
                  </select>
                </div>

                <div class="col-12 col-md-8">
                  <label class="fw-bold mini-note">Destino</label>
                  <select id="destinoDev" class="form-select"></select>
                </div>

                <div class="col-12">
                  <label class="fw-bold mini-note">Códigos a devolver (uno por línea)</label>
                  <textarea id="codigosDev" class="form-control" rows="9" placeholder="ABC123&#10;ABC124"></textarea>
                </div>

                <div class="col-12">
                  <hr class="hr-soft my-2">
                  <div class="card p-3">
                    <div class="fw-bold mb-2"><i class="fa-solid fa-calculator"></i> Totales / Saldo a restar</div>

                    <div class="row g-2 align-items-end">
                      <div class="col-12 col-md-3">
                        <label class="fw-bold mini-note">Precio unitario</label>
                        <input id="precioUnitDev" type="number" step="0.01" min="0" class="form-control" value="0.50">
                      </div>

                      <div class="col-12 col-md-3">
                        <label class="fw-bold mini-note">Descuento</label>
                        <input id="descDev" type="number" step="0.01" min="0" class="form-control" value="0.00">
                      </div>

                      <div class="col-12 col-md-3">
                        <div class="badge-soft w-100">Códigos: <b id="cntDev">0</b></div>
                      </div>

                      <div class="col-12 col-md-3">
                        <div class="badge-soft w-100">Saldo restado: <b id="devSaldoRestado">—</b></div>
                      </div>

                      <div class="col-12 col-md-4">
                        <div class="badge-soft w-100">Subtotal: <b id="subDev">0.00</b></div>
                      </div>
                      <div class="col-12 col-md-4">
                        <div class="badge-soft w-100">Total: <b id="totDev">0.00</b></div>
                      </div>
                      <div class="col-12 col-md-4">
                        <div class="badge-soft w-100">Nuevo saldo: <b id="nuevoSaldoDev">—</b></div>
                      </div>

                      <div class="col-12 mini-note">
                        * Se resta saldo según <b>códigos realmente devueltos</b>.<br>
                        * Tu API de devolución debe validar asignación y restar saldo al PV/CAN.
                      </div>
                    </div>
                  </div>
                </div>

                <div class="col-12 d-flex flex-wrap gap-2 mt-1">
                  <button class="btn btn-danger" type="button" id="btnDevolver">
                    <i class="fa-solid fa-rotate-left"></i> Devolver y restar saldo
                  </button>
                </div>

                <div class="col-12">
                  <div class="badge-soft w-100">Resultado: <span id="resDevText">—</span></div>
                </div>

                <div class="col-12 d-none" id="resDevBox">
                  <div class="row g-2">
                    <div class="col-12 col-md-4">
                      <div class="badge-soft w-100">Devueltos: <b id="resDevOk">0</b></div>
                    </div>
                    <div class="col-12 col-md-4">
                      <div class="badge-soft w-100">No encontrados: <b id="resDevNF">0</b></div>
                    </div>
                    <div class="col-12 col-md-4">
                      <div class="badge-soft w-100">No disponibles: <b id="resDevND">0</b></div>
                    </div>

                    <div class="col-12">
                      <label class="fw-bold mini-note">Fallidos</label>
                      <textarea id="resDevFallidos" class="form-control" rows="6" readonly></textarea>
                    </div>
                  </div>
                </div>

              </div>

            </div>
          </div>
        </div>
      </div>

      <!-- COBRAR SALDOS -->
      <div class="tab-pane fade" id="pane-cobros" role="tabpanel">

        <div class="row g-3">
          <div class="col-12 col-lg-5">
            <div class="card p-3">
              <div class="fw-bold mb-2"><i class="fa-solid fa-cash-register"></i> Cobrar saldo</div>

              <div class="row g-2">
                <div class="col-12 col-md-4">
                  <label class="fw-bold mini-note">Tipo</label>
                  <select id="cobTipo" class="form-select">
                    <option value="PV">Punto de venta</option>
                    <option value="CAN">Canillita</option>
                  </select>
                </div>

                <div class="col-12 col-md-8">
                  <label class="fw-bold mini-note">Destino con saldo</label>
                  <select id="cobDestino" class="form-select"></select>
                  <div class="mini-note mt-1">Saldo actual: <b id="cobSaldoActual">0.00</b></div>
                </div>

                <div class="col-12 col-md-6">
                  <label class="fw-bold mini-note">Abono</label>
                  <input id="cobAbono" class="form-control" type="number" min="0" step="0.01" placeholder="0.00">
                </div>

                <div class="col-12 col-md-6">
                  <label class="fw-bold mini-note">Observación</label>
                  <input id="cobObs" class="form-control" type="text" maxlength="255" placeholder="Ej: pago parcial">
                </div>

                <div class="col-12 d-flex gap-2 mt-1">
                  <button class="btn btn-soft" type="button" id="btnCobRefresh">
                    <i class="fa-solid fa-arrows-rotate"></i> Actualizar lista
                  </button>
                  <button class="btn btn-success" type="button" id="btnCobrar">
                    <i class="fa-solid fa-check"></i> Cobrar
                  </button>
                </div>

                <div class="col-12">
                  <div class="badge-soft w-100">Resultado: <span id="cobRes">—</span></div>
                </div>

                <div class="col-12 mini-note" id="cobPvWarn" style="display:none;color:#fecaca;">
                  ⚠️ PV no tiene columna saldo. Crea: <b>ALTER TABLE tbr_usuario ADD saldo DECIMAL(10,2) DEFAULT 0;</b>
                </div>
              </div>
            </div>
          </div>

          <div class="col-12 col-lg-7">
            <div class="card p-3">
              <div class="d-flex flex-wrap align-items-end justify-content-between gap-2">
                <div class="fw-bold"><i class="fa-solid fa-clock-rotate-left"></i> Historial de cobros</div>

                <div class="d-flex flex-wrap gap-2">
                  <div>
                    <label class="fw-bold mini-note">Desde</label>
                    <input id="hisDesde" type="date" class="form-control">
                  </div>
                  <div>
                    <label class="fw-bold mini-note">Hasta</label>
                    <input id="hisHasta" type="date" class="form-control">
                  </div>
                  <div class="d-flex align-items-end">
                    <button class="btn btn-soft" type="button" id="btnHis">
                      <i class="fa-solid fa-filter"></i> Ver
                    </button>
                  </div>
                </div>
              </div>

              <hr class="hr-soft my-3">

              <div class="table-responsive">
                <table id="tblCobros" class="table table-dark table-striped align-middle w-100">
                  <thead>
                    <tr>
                      <th>Fecha</th>
                      <th>Tipo</th>
                      <th>Destino</th>
                      <th>Saldo ant.</th>
                      <th>Abono</th>
                      <th>Saldo nuevo</th>
                    </tr>
                  </thead>
                  <tbody></tbody>
                </table>
              </div>

            </div>
          </div>
        </div>

      </div>

      <!-- REPORTE -->
      <div class="tab-pane fade" id="pane-reporte" role="tabpanel">

        <div class="fw-bold">Reporte (por rango de fechas)</div>
        <div class="mini-note">
          🔥 Vendidas = <b>estado 3</b> · Premios pagados = <b>estado 8</b> · Neto = <b>Vendido - PremiosPagados</b>.
          (Tabla mostrará 3 y 8 si tu API_LISTADO soporta <b>incluir_pagadas:true</b>)
        </div>

        <hr class="hr-soft my-3">

        <div class="row g-2 align-items-end">
          <div class="col-12 col-md-2">
            <label class="fw-bold mini-note">Desde</label>
            <input id="repDesde" type="date" class="form-control">
          </div>
          <div class="col-12 col-md-2">
            <label class="fw-bold mini-note">Hasta</label>
            <input id="repHasta" type="date" class="form-control">
          </div>

          <div class="col-12 col-md-2">
            <label class="fw-bold mini-note">Filtrar por</label>
            <select id="repTipo" class="form-select">
              <option value="ALL">Todos</option>
              <option value="PV">Punto de venta</option>
              <option value="CAN">Canillita</option>
            </select>
          </div>

          <div class="col-12 col-md-3">
            <label class="fw-bold mini-note">Destino</label>
            <select id="repDestino" class="form-select">
              <option value="0">— Todos —</option>
            </select>
          </div>

          <div class="col-12 col-md-1 d-grid">
            <button class="btn btn-soft" type="button" id="btnRepHoy">
              <i class="fa-solid fa-calendar-day"></i> Hoy
            </button>
          </div>
          <div class="col-12 col-md-2 d-grid">
            <button class="btn btn-success" type="button" id="btnRepCargar">
              <i class="fa-solid fa-magnifying-glass"></i> Cargar
            </button>
          </div>
        </div>

        <div class="row g-3 mt-2">
          <div class="col-12 col-md-3">
            <div class="kpi">
              <div class="ico"><i class="fa-solid fa-cart-shopping" style="color:var(--green)"></i></div>
              <div class="w-100">
                <div class="label">Vendidas</div>
                <div class="value" id="repVendidas">0</div>
              </div>
            </div>
          </div>

          <div class="col-12 col-md-3">
            <div class="kpi">
              <div class="ico"><i class="fa-solid fa-dollar-sign" style="color:var(--cyan)"></i></div>
              <div class="w-100">
                <div class="label">Total vendido</div>
                <div class="value" id="repTotalVendido">$0.00</div>
              </div>
            </div>
          </div>

          <div class="col-12 col-md-3">
            <div class="kpi">
              <div class="ico"><i class="fa-solid fa-trophy" style="color:var(--amber)"></i></div>
              <div class="w-100">
                <div class="label">Premios pagados</div>
                <div class="value" id="repPremios">$0.00</div>
              </div>
            </div>
          </div>

          <div class="col-12 col-md-3">
            <div class="kpi">
              <div class="ico"><i class="fa-solid fa-scale-balanced" style="color:var(--purple)"></i></div>
              <div class="w-100">
                <div class="label">Neto</div>
                <div class="value" id="repNeto">$0.00</div>
              </div>
            </div>
          </div>
        </div>

        <hr class="hr-soft my-3">

        <div class="table-responsive">
          <table id="tblReporte" class="table table-dark table-striped align-middle w-100">
            <thead>
              <tr>
                <th>Fecha</th>
                <th>Código</th>
                <th>Valor</th>
                <th>Premio</th>
                <th>Estado</th>
                <th>Asignado a</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>

        <div class="mini-note mt-2">
          Nota: para que el filtro PV/CAN sea exacto, <b>API_LISTADO</b> debe devolver <b>id_usuario</b> y/o <b>id_canillita</b> en cada item.
        </div>
      </div>

    </div>
  </div>

</div>

<!-- Modal detalle -->
<div class="modal fade" id="modalDetalle" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content" style="background:linear-gradient(180deg, var(--card), var(--card2)); border:1px solid var(--border); color:var(--text); border-radius:16px;">
      <div class="modal-header" style="border-bottom:1px solid var(--border);">
        <h5 class="modal-title fw-bold"><i class="fa-solid fa-circle-info"></i> Detalle</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <div class="row g-3">
          <div class="col-md-6"><div class="badge-soft w-100">Código: <b id="dCodigo">—</b></div></div>
          <div class="col-md-6"><div class="badge-soft w-100">Estado: <b id="dEstado">—</b></div></div>
          <div class="col-md-6"><div class="badge-soft w-100">Fecha/Hora: <b id="dFecha">—</b></div></div>
          <div class="col-md-6"><div class="badge-soft w-100">Asignado a: <b id="dAsignado">—</b></div></div>
        </div>
      </div>
      <div class="modal-footer" style="border-top:1px solid var(--border);">
        <button class="btn btn-soft" data-bs-dismiss="modal"><i class="fa-solid fa-xmark"></i> Cerrar</button>
      </div>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.10.8/dist/sweetalert2.all.min.js"></script>

<script>
  // RUTAS
  const API_RESUMEN   = "api/coordinador_resumen.php";
  const API_LISTADO   = "api/coordinador_listado.php";
  const API_DETALLE   = "api/raspadita_detalle.php";
  const API_LOGOUT    = "logout.php";

  const API_CATS      = "api/coordinador_catalogos.php";
  const API_STOCK     = "api/coordinador_stock.php";

  const API_ASIGNAR   = "api/coordinador_asignar.php";
  const API_DEVOLVER  = "api/coordinador_devolver.php";
  const API_PREVIEW   = "api/coordinador_codigos_preview.php";

  const API_SALDOS    = "api/coordinador_saldos_pendientes.php";
  const API_COBRAR    = "api/coordinador_cobrar_saldo.php";
  const API_COBROS    = "api/coordinador_cobros_list.php";

  const API_PV_LIST_SIMPLE  = "api/pv_list_simple.php";
  const API_CANILLITAS_LIST = "api/canillitas_list.php";

  const ID_COORD = <?= (int)$idCoord ?>;

  let dt = null;
  let cats = { puntos_venta: [], canillitas: [] };

  let saldos = { pv_has_saldo:false, puntos_venta:[], canillitas:[] };
  let dtCobros = null;

  let preview = { items: [], subtotal: 0, validos: 0, invalidos: 0, codigos_validos: [], total_codigos: 0 };
  let previewTimer = null;

  let dtReporte = null;
  let repLists = { pv: [], can: [] };

  function money(n){
    const x = Number(n || 0);
    return x.toLocaleString('es-EC', { style:'currency', currency:'USD' });
  }
  function num2(n){ return Number(n || 0).toFixed(2); }

  async function postJson(url, payload){
    const r = await fetch(url, {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      credentials: "include",
      body: JSON.stringify(payload || {})
    });
    const txt = await r.text();
    let data = null;
    try { data = JSON.parse(txt); }
    catch(e){ data = {success:false, message: txt || "Respuesta no válida"}; }

    if(!r.ok || !data?.success) throw new Error(data?.message || "Error en API");
    return data;
  }

  function estadoPill(estado){
    const e = parseInt(estado, 10);
    if (e === 1) return `<span class="pill s1"><i class="fa-solid fa-tag"></i> ASIGNADA</span>`;
    if (e === 2) return `<span class="pill s2"><i class="fa-solid fa-truck"></i> ENTREGADA</span>`;
    if (e === 3) return `<span class="pill s3"><i class="fa-solid fa-check"></i> VENDIDA</span>`;
    if (e === 8) return `<span class="pill s8"><i class="fa-solid fa-money-bill-wave"></i> PAGADA</span>`;
    return `<span class="pill"><i class="fa-solid fa-circle-question"></i> —</span>`;
  }

  function initDT(){
    dt = new DataTable('#tbl', {
      pageLength: 10,
      order: [[0,'desc']],
      language: { url: "https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json" },
      columns: [
        { data: 'fecha' },
        { data: 'codigo' },
        { data: 'valor' },
        { data: 'estado' },
        { data: 'asignado_a' },
        { data: 'acciones' }
      ]
    });
  }

  function initCobrosDT(){
    dtCobros = new DataTable('#tblCobros', {
      pageLength: 10,
      order: [[0,'desc']],
      language: { url: "https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json" },
      columns: [
        { data: 'fecha_hora' },
        { data: 'tipo' },
        { data: 'destino' },
        { data: 'saldo_anterior' },
        { data: 'abono' },
        { data: 'saldo_nuevo' }
      ]
    });
  }

  function initReporteDT(){
    if (dtReporte) return;
    dtReporte = new DataTable('#tblReporte', {
      pageLength: 10,
      order: [[0,'desc']],
      language: { url: "https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json" },
      columns: [
        { data: 'fecha' },
        { data: 'codigo' },
        { data: 'valor' },
        { data: 'premio' },
        { data: 'estado' },
        { data: 'asignado_a' }
      ]
    });
  }

  function buildAcciones(row){
    const id = Number(row.id || 0);
    const codigo = String(row.codigo || '');
    return `
      <button class="btn btn-soft btn-sm" type="button"
        onclick="verDetalle(${id}, '${codigo.replace(/'/g,"\\'")}')"
        title="Ver detalle">
        <i class="fa-solid fa-eye"></i>
      </button>
    `;
  }

  async function cargarResumen(){
    const d = await postJson(API_RESUMEN, { id_coordinador: ID_COORD });
    document.getElementById('kpiSaldo').textContent    = money(d?.saldo ?? 0);
    document.getElementById('kpiTotal123').textContent = String(d?.total_123 ?? 0);
    document.getElementById('kpiVenHoy').textContent   = String(d?.hoy_vendidas ?? 0);
  }

  async function cargarListado(){
    const d = await postJson(API_LISTADO, { id_coordinador: ID_COORD });
    const items = Array.isArray(d?.items) ? d.items : [];

    dt.clear();
    dt.rows.add(items.map(r => {
      const est = (r.estado_num ?? r.estado ?? 0);
      return {
        fecha: r.fecha ?? r.fecha_hora ?? '',
        codigo: r.codigo ?? '',
        valor: money(r.valor ?? 0),
        estado: estadoPill(est),
        asignado_a: r.asignado_a ?? '',
        acciones: buildAcciones(r),
        id: r.id
      };
    }));
    dt.draw();
  }

  async function cargarCatalogos(){
    cats = await postJson(API_CATS, {});
    renderDestino();
    renderDestinoDev();
  }

  function renderDestino(){
    const tipo = document.getElementById('tipoDestino').value;
    const sel = document.getElementById('destino');
    sel.innerHTML = "";

    const arr = (tipo === 'PV') ? (cats?.puntos_venta || []) : (cats?.canillitas || []);
    for (const it of arr) {
      const op = document.createElement('option');
      op.value = it.id;
      op.textContent = it.text;
      sel.appendChild(op);
    }
  }

  function renderDestinoDev(){
    const tipo = document.getElementById('tipoDev').value;
    const sel = document.getElementById('destinoDev');
    sel.innerHTML = "";

    const arr = (tipo === 'PV') ? (cats?.puntos_venta || []) : (cats?.canillitas || []);
    for (const it of arr) {
      const op = document.createElement('option');
      op.value = it.id;
      op.textContent = it.text;
      sel.appendChild(op);
    }
  }

  async function cargarStock(){
    const d = await postJson(API_STOCK, {});
    document.getElementById('kpiStock').textContent = String(d?.stock_disponible ?? 0);
  }

  function getCodigosUniq(){
    const txt = (document.getElementById('codigos').value || '').trim();
    const cods = txt ? txt.split(/\r?\n/).map(s=>s.trim()).filter(Boolean) : [];
    return Array.from(new Set(cods));
  }

  function calcTotal(subtotal){
    const pct = Number(document.getElementById('descAsig').value || 0);
    const p = (Number.isFinite(pct) && pct > 0) ? pct : 0;
    const sub = Number(subtotal || 0);
    const descValor = sub * (p / 100);
    const total = Math.max(0, sub - descValor);
    return { porcentaje: p, descuento_valor: descValor, total };
  }

  function renderPreviewUI(p){
    const tb = document.getElementById('tbodyPreview');
    const msg = document.getElementById('previewMsg');

    const items = Array.isArray(p.items) ? p.items : [];
    if (items.length === 0){
      tb.innerHTML = `<tr><td colspan="3" class="mini-note">Escribe códigos para ver valores…</td></tr>`;
      msg.textContent = '—';
    } else {
      tb.innerHTML = items.map(it => {
        const ok = !!it.ok;
        const st = ok ? `<span class="st-ok">OK</span>` : `<span class="st-bad">${(it.motivo||'NO')}</span>`;
        const val = ok ? money(it.valor || 0) : '—';
        return `
          <tr>
            <td><span class="code-badge">${String(it.codigo||'')}</span></td>
            <td>${val}</td>
            <td>${st}</td>
          </tr>
        `;
      }).join('');

      msg.textContent = `Válidos: ${p.validos||0} · Inválidos: ${p.invalidos||0}`;
    }

    document.getElementById('cntAsig').textContent = String(p.total_codigos || 0);
    document.getElementById('cntValidos').textContent = String(p.validos || 0);

    const subtotal = Number(p.subtotal || 0);
    document.getElementById('subAsig').textContent = num2(subtotal);

    const { total } = calcTotal(subtotal);
    document.getElementById('totAsig').textContent = num2(total);
  }

  async function cargarPreviewCodigos(){
    const uniq = getCodigosUniq();
    document.getElementById('cntAsig').textContent = String(uniq.length);

    if (uniq.length === 0){
      preview = { items: [], subtotal: 0, validos: 0, invalidos: 0, codigos_validos: [], total_codigos: 0, total_codigos_in: 0 };
      renderPreviewUI(preview);
      return;
    }

    try{
      const d = await postJson(API_PREVIEW, { codigos: uniq });
      preview = {
        items: d.items || [],
        subtotal: d.subtotal || 0,
        validos: d.validos || 0,
        invalidos: d.invalidos || 0,
        codigos_validos: d.codigos_validos || [],
        total_codigos: uniq.length
      };
      renderPreviewUI(preview);
    }catch(e){
      const tb = document.getElementById('tbodyPreview');
      tb.innerHTML = `<tr><td colspan="3" class="mini-note" style="color:#fecaca;">No se pudo previsualizar: ${e.message}</td></tr>`;
      document.getElementById('previewMsg').textContent = '—';
    }
  }

  function debouncePreview(){
    clearTimeout(previewTimer);
    previewTimer = setTimeout(()=>{ cargarPreviewCodigos(); }, 250);
  }

  function setResultadoBox({asignados=[], no_encontrados=[], no_disponibles=[]}){
    const a = asignados.length, n = no_encontrados.length, nd = no_disponibles.length;
    document.getElementById('resBox').classList.remove('d-none');
    document.getElementById('resAsignados').textContent = String(a);
    document.getElementById('resNoFound').textContent = String(n);
    document.getElementById('resNoDisp').textContent = String(nd);

    const fallidos = [...no_encontrados, ...no_disponibles];
    document.getElementById('resFallidos').value = fallidos.join("\n");

    document.getElementById('resText').textContent =
      `Asignados ${a} | No encontrados ${n} | No disponibles ${nd}`;
  }

  function setTotalesUI({cant=0, subtotal=0, total=0, saldo_sumado=false}){
    document.getElementById('cntValidos').textContent = String(cant);
    document.getElementById('subAsig').textContent = num2(subtotal);
    document.getElementById('totAsig').textContent = num2(total);
    document.getElementById('saldoSumado').textContent = saldo_sumado ? 'SI' : 'NO';
  }

  async function asignar(){
    const tipo = document.getElementById('tipoDestino').value;
    const idDestino = Number(document.getElementById('destino').value || 0);
    if (!idDestino) {
      Swal.fire({ icon:'warning', title:'Destino requerido', text:'Selecciona un destino.' });
      return;
    }

    const uniq = getCodigosUniq();
    if (uniq.length < 1) {
      Swal.fire({ icon:'warning', title:'Códigos requeridos', text:'Escribe al menos un código (uno por línea).' });
      return;
    }

    const codigos_validos = Array.isArray(preview.codigos_validos) ? preview.codigos_validos : [];
    if (codigos_validos.length < 1){
      Swal.fire({ icon:'warning', title:'Sin códigos válidos', text:'Ningún código es válido para asignar.' });
      return;
    }

    const tipo_pago = String(document.getElementById('tipoPagoAsig').value || 'efectivo');

    const descuento = Number(document.getElementById('descAsig').value || 0); // %
    if (!Number.isFinite(descuento) || descuento < 0 || descuento > 100) {
      Swal.fire({ icon:'warning', title:'Descuento inválido', text:'El descuento debe estar entre 0 y 100.' });
      return;
    }

    const subtotalPreview = Number(preview.subtotal || 0);
    const { total } = calcTotal(subtotalPreview);

    const ok = await Swal.fire({
      icon:'question',
      title:'Confirmar',
      html:`Códigos ingresados: <b>${uniq.length}</b><br>
            Códigos válidos: <b>${codigos_validos.length}</b><br>
            Subtotal: <b>${num2(subtotalPreview)}</b><br>
            Descuento: <b>${num2(descuento)}%</b><br>
            Total: <b>${num2(total)}</b><br><br>
            Destino: <b>${tipo === 'PV' ? 'Punto de venta' : 'Canillita'}</b><br>
            Pago: <b>${tipo_pago.toUpperCase()}</b>`,
      showCancelButton:true,
      confirmButtonText:'Sí, cobrar y asignar',
      cancelButtonText:'Cancelar'
    });
    if (!ok.isConfirmed) return;

    try{
      setTotalesUI({cant:0, subtotal:0, total:0, saldo_sumado:false});
      document.getElementById('resText').textContent = 'Procesando…';

      const d = await postJson(API_ASIGNAR, {
        tipo,
        id_destino: idDestino,
        codigos: codigos_validos,
        tipo_pago,
        descuento_pct: descuento
      });

      setResultadoBox({
        asignados: d.asignados || [],
        no_encontrados: d.no_encontrados || [],
        no_disponibles: d.no_disponibles || []
      });

      setTotalesUI({
        cant: (d.asignadas ?? (d.asignados||[]).length),
        subtotal: d.subtotal ?? subtotalPreview,
        total: d.total ?? total,
        saldo_sumado: !!d.saldo_sumado
      });

      await cargarStock();
      await cargarResumen();
      await cargarListado();

      if ((d.asignados || []).length > 0){
        document.getElementById('codigos').value = '';
        await cargarPreviewCodigos();
      }

      Swal.fire({
        icon:'success',
        title:'Proceso terminado',
        text:`Asignados: ${(d.asignados||[]).length} | No encontrados: ${(d.no_encontrados||[]).length} | No disponibles: ${(d.no_disponibles||[]).length}`,
        timer:2600,
        showConfirmButton:false
      });

    }catch(e){
      Swal.fire({ icon:'error', title:'No se pudo procesar', text: e.message });
      document.getElementById('resText').textContent = '—';
    }
  }

  // DEVOLUCIÓN
  function setTotalesDevUI({cant=0, subtotal=0, total=0, saldo_restado=false, nuevo_saldo=null}){
    document.getElementById('cntDev').textContent = String(cant);
    document.getElementById('subDev').textContent = num2(subtotal);
    document.getElementById('totDev').textContent = num2(total);
    document.getElementById('devSaldoRestado').textContent = saldo_restado ? 'SI' : 'NO';
    document.getElementById('nuevoSaldoDev').textContent = (nuevo_saldo == null) ? '—' : num2(nuevo_saldo);
  }

  function setResultadoDevBox({devueltos=[], no_encontrados=[], no_disponibles=[]}){
    document.getElementById('resDevBox').classList.remove('d-none');
    document.getElementById('resDevOk').textContent = String(devueltos.length);
    document.getElementById('resDevNF').textContent = String(no_encontrados.length);
    document.getElementById('resDevND').textContent = String(no_disponibles.length);

    const fallidos = [...no_encontrados, ...no_disponibles];
    document.getElementById('resDevFallidos').value = fallidos.join("\n");

    document.getElementById('resDevText').textContent =
      `Devueltos ${devueltos.length} | No encontrados ${no_encontrados.length} | No disponibles ${no_disponibles.length}`;
  }

  async function devolver(){
    const tipo = document.getElementById('tipoDev').value;
    const idDestino = Number(document.getElementById('destinoDev').value || 0);
    if (!idDestino) {
      Swal.fire({ icon:'warning', title:'Destino requerido', text:'Selecciona un destino.' });
      return;
    }

    const txt = (document.getElementById('codigosDev').value || '').trim();
    const cods = txt.split(/\r?\n/).map(s=>s.trim()).filter(Boolean);
    const uniq = Array.from(new Set(cods));
    if (uniq.length < 1) {
      Swal.fire({ icon:'warning', title:'Códigos requeridos', text:'Escribe al menos un código.' });
      return;
    }

    const precio_unitario = Number(document.getElementById('precioUnitDev').value || 0.50);
    const descuento = Number(document.getElementById('descDev').value || 0);

    if (!Number.isFinite(precio_unitario) || precio_unitario <= 0) {
      Swal.fire({ icon:'warning', title:'Precio inválido', text:'Revisa el precio unitario.' });
      return;
    }
    if (!Number.isFinite(descuento) || descuento < 0) {
      Swal.fire({ icon:'warning', title:'Descuento inválido', text:'El descuento no puede ser negativo.' });
      return;
    }

    const ok = await Swal.fire({
      icon:'question',
      title:'Confirmar devolución',
      html:`Vas a devolver <b>${uniq.length}</b> código(s) y restar saldo.<br>
            Destino: <b>${tipo === 'PV' ? 'Punto de venta' : 'Canillita'}</b>`,
      showCancelButton:true,
      confirmButtonText:'Sí, devolver',
      cancelButtonText:'Cancelar'
    });
    if (!ok.isConfirmed) return;

    try{
      setTotalesDevUI({cant:0, subtotal:0, total:0, saldo_restado:false, nuevo_saldo:null});
      document.getElementById('resDevText').textContent = 'Procesando…';

      const d = await postJson(API_DEVOLVER, {
        tipo,
        id_destino: idDestino,
        codigos: uniq,
        precio_unitario,
        descuento
      });

      setResultadoDevBox({
        devueltos: d.devueltos_codigos || [],
        no_encontrados: d.no_encontrados || [],
        no_disponibles: d.no_disponibles || []
      });

      setTotalesDevUI({
        cant: d.devueltos ?? (d.devueltos_codigos||[]).length,
        subtotal: d.subtotal ?? 0,
        total: d.total ?? 0,
        saldo_restado: !!d.saldo_restado,
        nuevo_saldo: d.nuevo_saldo ?? null
      });

      await cargarStock();
      await cargarResumen();
      await cargarListado();

      if ((d.devueltos_codigos || []).length > 0) document.getElementById('codigosDev').value = '';

      Swal.fire({
        icon:'success',
        title:'Devolución terminada',
        text:`Devueltos: ${(d.devueltos_codigos||[]).length}`,
        timer:2200,
        showConfirmButton:false
      });

    }catch(e){
      Swal.fire({ icon:'error', title:'No se pudo devolver', text: e.message });
      document.getElementById('resDevText').textContent = '—';
    }
  }

  // COBRAR SALDOS
  function setTodayRange(){
    const hoy = new Date();
    const y = hoy.getFullYear();
    const m = String(hoy.getMonth()+1).padStart(2,'0');
    const d = String(hoy.getDate()).padStart(2,'0');
    const s = `${y}-${m}-${d}`;
    document.getElementById('hisDesde').value = s;
    document.getElementById('hisHasta').value = s;
  }

  function renderCobDestinos(){
    const tipo = document.getElementById('cobTipo').value;
    const sel = document.getElementById('cobDestino');
    sel.innerHTML = "";

    const arr = (tipo === 'PV') ? (saldos.puntos_venta || []) : (saldos.canillitas || []);
    for (const it of arr) {
      const op = document.createElement('option');
      op.value = it.id;
      op.textContent = `${it.text} — Saldo: ${num2(it.saldo)}`;
      op.dataset.saldo = String(it.saldo);
      sel.appendChild(op);
    }

    const first = sel.options[0];
    document.getElementById('cobSaldoActual').textContent = first ? num2(first.dataset.saldo || 0) : '0.00';
  }

  async function cargarSaldosPendientes(){
    const d = await postJson(API_SALDOS, {});
    saldos = d;

    const warn = document.getElementById('cobPvWarn');
    if (warn) warn.style.display = (d.pv_has_saldo ? 'none' : 'block');

    renderCobDestinos();
  }

  async function cargarHistorialCobros(){
    const desde = document.getElementById('hisDesde').value;
    const hasta = document.getElementById('hisHasta').value;

    const d = await postJson(API_COBROS, { desde, hasta });
    const items = Array.isArray(d.items) ? d.items : [];

    dtCobros.clear();
    dtCobros.rows.add(items.map(x => ({
      fecha_hora: x.fecha_hora,
      tipo: x.tipo,
      destino: x.destino,
      saldo_anterior: num2(x.saldo_anterior),
      abono: num2(x.abono),
      saldo_nuevo: num2(x.saldo_nuevo),
    })));
    dtCobros.draw();
  }

  async function cobrarSaldo(){
    const tipo = document.getElementById('cobTipo').value;
    const id_destino = Number(document.getElementById('cobDestino').value || 0);
    const abono = Number(document.getElementById('cobAbono').value || 0);
    const observacion = String(document.getElementById('cobObs').value || '').trim();

    if (!id_destino) {
      Swal.fire({ icon:'warning', title:'Destino requerido', text:'Selecciona un destino con saldo.' });
      return;
    }
    if (!Number.isFinite(abono) || abono <= 0) {
      Swal.fire({ icon:'warning', title:'Abono inválido', text:'Ingresa un abono mayor a 0.' });
      return;
    }

    const ok = await Swal.fire({
      icon:'question',
      title:'Confirmar cobro',
      html:`Tipo: <b>${tipo}</b><br>Abono: <b>${num2(abono)}</b>`,
      showCancelButton:true,
      confirmButtonText:'Sí, cobrar',
      cancelButtonText:'Cancelar'
    });
    if (!ok.isConfirmed) return;

    try{
      document.getElementById('cobRes').textContent = 'Procesando…';

      const d = await postJson(API_COBRAR, { tipo, id_destino, abono, observacion });

      document.getElementById('cobRes').textContent =
        `OK · saldo anterior ${num2(d.saldo_anterior)} · abono ${num2(d.abono)} · saldo nuevo ${num2(d.saldo_nuevo)}`;

      document.getElementById('cobAbono').value = '';
      document.getElementById('cobObs').value = '';

      await cargarSaldosPendientes();
      await cargarHistorialCobros();
      await cargarResumen();

      Swal.fire({
        icon:'success',
        title:'Cobro registrado',
        text:`Saldo nuevo: ${num2(d.saldo_nuevo)}`,
        timer:2200,
        showConfirmButton:false
      });

    }catch(e){
      document.getElementById('cobRes').textContent = '—';
      Swal.fire({ icon:'error', title:'No se pudo cobrar', text: e.message });
    }
  }

  // Modal Detalle
  window.verDetalle = async function(id, codigo){
    try{
      const d = await postJson(API_DETALLE, { id });
      const it = d?.item || {};
      document.getElementById('dCodigo').textContent = it.codigo ?? codigo ?? '—';
      document.getElementById('dEstado').textContent = it.estado_txt ?? String(it.estado ?? '—');
      document.getElementById('dFecha').textContent  = it.fecha_hora ?? '—';

      let asignado = '—';
      if (Number(it.id_canillita || 0) > 0) asignado = `CANILLITA: ${it.canillita || ''}`;
      else if (Number(it.id_usuario || 0) > 0) asignado = `PUNTO: ${it.usuario_pv || ''}`;
      document.getElementById('dAsignado').textContent = asignado;

      new bootstrap.Modal(document.getElementById('modalDetalle')).show();
    }catch(e){
      Swal.fire({ icon:'warning', title:'No se pudo ver detalle', text: e.message });
    }
  }

  // REPORTE
  function ymdToday(){
    const d = new Date();
    const y = d.getFullYear();
    const m = String(d.getMonth()+1).padStart(2,'0');
    const day = String(d.getDate()).padStart(2,'0');
    return `${y}-${m}-${day}`;
  }
  function toYMD(x){
    const s = String(x || '');
    return s.length >= 10 ? s.slice(0,10) : s;
  }
  function inRange(ymd, desde, hasta){
    if (!ymd) return false;
    if (desde && ymd < desde) return false;
    if (hasta && ymd > hasta) return false;
    return true;
  }
  function pickArray(d){
    if (!d) return [];
    if (Array.isArray(d.data)) return d.data;
    if (Array.isArray(d.items)) return d.items;
    if (Array.isArray(d.canillitas)) return d.canillitas;
    if (Array.isArray(d.puntos_venta)) return d.puntos_venta;
    return [];
  }

  function renderRepDestino(){
    const tipo = document.getElementById('repTipo').value; // ALL/PV/CAN
    const sel  = document.getElementById('repDestino');

    sel.innerHTML = "";
    const op0 = document.createElement('option');
    op0.value = "0";
    op0.textContent = "— Todos —";
    sel.appendChild(op0);

    if (tipo === 'ALL') return;

    const arr = (tipo === 'PV') ? (repLists.pv || []) : (repLists.can || []);

    for (const it of arr){
      const op = document.createElement('option');

      if (tipo === 'PV'){
        const id = Number(it.idusuario || it.id || 0);
        if (!id) continue;
        const suc = it.sucursal ? ` (${it.sucursal})` : '';
        op.value = String(id);
        op.textContent = `${it.usuario ?? ('PV #' + id)}${suc}`;
      }

      if (tipo === 'CAN'){
        const id = Number(it.id || it.id_canillita || 0);
        if (!id) continue;
        op.value = String(id);
        op.textContent = String(it.canillita || it.nombre || it.usuario || ('CAN #' + id));
      }

      sel.appendChild(op);
    }
  }

  async function cargarListasReporte(){
    try{
      const r1 = await postJson(API_PV_LIST_SIMPLE, {});
      repLists.pv = pickArray(r1);
    }catch(e){
      repLists.pv = [];
    }

    try{
      const r2 = await postJson(API_CANILLITAS_LIST, {});
      repLists.can = pickArray(r2);
    }catch(e){
      repLists.can = [];
    }

    renderRepDestino();
  }

  async function cargarReporte(){
    initReporteDT();

    const desde = (document.getElementById('repDesde')?.value || '').trim();
    const hasta = (document.getElementById('repHasta')?.value || '').trim();

    const tipoFiltro = document.getElementById('repTipo').value; // ALL/PV/CAN
    const destinoId  = Number(document.getElementById('repDestino').value || 0);

    // Listado: pedir también pagadas
    const d = await postJson(API_LISTADO, { id_coordinador: ID_COORD, desde, hasta, incluir_pagadas:true });
    const items = Array.isArray(d?.items) ? d.items : [];

    let vendidas = 0;
    let totalVendido = 0;
    let premiosPagados = 0;

    const rows = [];
    for (const it of items){
      const fechaKey = toYMD(it.fecha || it.fecha_hora || '');
      if (!inRange(fechaKey, desde, hasta)) continue;

      const pvId  = Number(it.id_usuario || 0);
      const canId = Number(it.id_canillita || 0);

      if (tipoFiltro === 'PV'){
        if (pvId <= 0) continue;
        if (destinoId > 0 && pvId !== destinoId) continue;
      }
      if (tipoFiltro === 'CAN'){
        if (canId <= 0) continue;
        if (destinoId > 0 && canId !== destinoId) continue;
      }

      const est = Number(it.estado_num ?? it.estado ?? 0);
      const valor = Number(it.valor ?? 0);
      const premio = Number(it.premio ?? 0);

      // VENDIDA (3) o PAGADA (8) también cuenta como vendida
		if (est === 3 || est === 8){
		  vendidas += 1;
		  totalVendido += valor;
		}
      if (est === 8){
        premiosPagados += premio;
      }

      rows.push({
        fecha: it.fecha ?? it.fecha_hora ?? '',
        codigo: it.codigo ?? '',
        valor: money(valor),
        premio: money(premio),
        estado: estadoPill(est),
        asignado_a: it.asignado_a ?? ''
      });
    }

    document.getElementById('repVendidas').textContent = String(vendidas);
    document.getElementById('repTotalVendido').textContent = money(totalVendido);
    document.getElementById('repPremios').textContent = money(premiosPagados);
    document.getElementById('repNeto').textContent = money(totalVendido - premiosPagados);

    dtReporte.clear();
    dtReporte.rows.add(rows);
    dtReporte.draw();
  }

  // Eventos: preview
  document.getElementById('codigos').addEventListener('input', debouncePreview);
  document.getElementById('descAsig').addEventListener('input', ()=>{
    const sub = Number(preview.subtotal || 0);
    const { total } = calcTotal(sub);
    document.getElementById('totAsig').textContent = num2(total);
  });

  // Conteo en vivo - DEVOLUCIÓN
  document.getElementById('codigosDev').addEventListener('input', ()=>{
    const txt = (document.getElementById('codigosDev').value || '').trim();
    const cods = txt ? txt.split(/\r?\n/).map(s=>s.trim()).filter(Boolean) : [];
    document.getElementById('cntDev').textContent = String(new Set(cods).size);
  });

  // Listeners
  document.getElementById('tipoDestino').addEventListener('change', renderDestino);
  document.getElementById('btnStock').addEventListener('click', cargarStock);
  document.getElementById('btnAsignar').addEventListener('click', asignar);

  document.getElementById('tipoDev').addEventListener('change', renderDestinoDev);
  document.getElementById('btnDevolver').addEventListener('click', devolver);

  document.getElementById('cobTipo').addEventListener('change', renderCobDestinos);
  document.getElementById('cobDestino').addEventListener('change', ()=>{
    const sel = document.getElementById('cobDestino');
    const op = sel.options[sel.selectedIndex];
    document.getElementById('cobSaldoActual').textContent = op ? num2(op.dataset.saldo || 0) : '0.00';
  });
  document.getElementById('btnCobRefresh').addEventListener('click', cargarSaldosPendientes);
  document.getElementById('btnCobrar').addEventListener('click', cobrarSaldo);
  document.getElementById('btnHis').addEventListener('click', cargarHistorialCobros);

  document.getElementById('tab-asignar').addEventListener('click', async ()=>{
    await cargarCatalogos();
    await cargarStock();
    await cargarPreviewCodigos();
  });

  document.getElementById('tab-devolucion').addEventListener('click', async ()=>{
    await cargarCatalogos();
  });

  document.getElementById('tab-cobros').addEventListener('click', async ()=>{
    await cargarSaldosPendientes();
    await cargarHistorialCobros();
  });

  // REPORTE listeners
  document.getElementById('repTipo').addEventListener('change', ()=>{ renderRepDestino(); });

  document.getElementById('tab-reporte').addEventListener('click', async ()=>{
    const hoy = ymdToday();
    if (!document.getElementById('repDesde').value) document.getElementById('repDesde').value = hoy;
    if (!document.getElementById('repHasta').value) document.getElementById('repHasta').value = hoy;

    await cargarListasReporte();
    await cargarReporte();
  });

  document.getElementById('btnRepHoy').addEventListener('click', async ()=>{
    const hoy = ymdToday();
    document.getElementById('repDesde').value = hoy;
    document.getElementById('repHasta').value = hoy;
    await cargarReporte();
  });

  document.getElementById('btnRepCargar').addEventListener('click', cargarReporte);

  document.getElementById('btnReload').addEventListener('click', async ()=>{
    await cargarResumen();
    await cargarListado();
    await cargarStock();
    await cargarPreviewCodigos();
  });

  document.getElementById('btnLogout').addEventListener('click', async ()=>{
    const ok = await Swal.fire({
      icon:'question', title:'Cerrar sesión', text:'¿Deseas salir?',
      showCancelButton:true, confirmButtonText:'Sí', cancelButtonText:'No'
    });
    if(!ok.isConfirmed) return;
    try{ await fetch(API_LOGOUT, { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'include' }); }catch(e){}
    window.location.href = "login.php";
  });

  (async function(){
    initDT();
    initCobrosDT();
    setTodayRange();

    await cargarResumen();
    await cargarListado();
    await cargarCatalogos();
    await cargarStock();
    await cargarPreviewCodigos();

    // precarga fechas del reporte
    const hoy = ymdToday();
    const d1 = document.getElementById('repDesde');
    const d2 = document.getElementById('repHasta');
    if (d1) d1.value = hoy;
    if (d2) d2.value = hoy;
  })();
</script>

</body>
</html>