<?php
session_start();

// Verificar sesión
if (!isset($_SESSION['idusuario'], $_SESSION['usuario'], $_SESSION['sucursal'])) {
    header('Location: index.php');
    exit();
}

$idusuario = (int) $_SESSION['idusuario']; // Forzar entero para seguridad
$sucursal_id = $_SESSION['sucursal'] ?? null;

include("conex.php"); // Conexión a la base de datos

header("Content-Type: application/json");
date_default_timezone_set('America/Guayaquil'); // Ajustar la zona horaria

// Verificar conexión a la base de datos
if (!$conn) {
    http_response_code(500);
    echo json_encode(["error" => "Error de conexión a la base de datos."]);
    exit();
}

// Obtener la fecha actual restando un día
$fecha = new DateTime();
//$fecha->modify('-1 day'); // Restar un día
$fecha_formateada = $fecha->format('Y-m-d');

// Preparar la consulta SQL
$query = "SELECT t.numero, t.valor, l.loteria 
          FROM tbr_ticket AS t
          INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
		  INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
          WHERE t.condicion = 1 
          AND t.estado = 2 
		  AND t.id_cifras = 2
		  AND u.id_sucursal = ?
          AND t.fecha >= ?  
          ORDER BY t.idrifa DESC 
          LIMIT 3";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "is", $sucursal_id, $fecha_formateada);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

// Verificar errores en la consulta
if (!$result) {
    http_response_code(500);
    echo json_encode(["error" => "Error en la consulta: " . mysqli_error($conn)]);
    exit();
}

// Obtener resultados
$numeros = [];
while ($row = mysqli_fetch_assoc($result)) {
    $numeros[] = [
        'loteria' => $row['loteria'],
        'numero' => str_pad($row['numero'], 3, '0', STR_PAD_LEFT), // 3 dígitos
        'valor' => '$' . number_format($row['valor'], 2, '.', '') // 2 decimales
    ];
}

// Enviar la respuesta en JSON
echo json_encode($numeros, JSON_UNESCAPED_UNICODE);

// Cerrar la conexión
mysqli_stmt_close($stmt);
mysqli_close($conn);
?>
