<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$rol = $_SESSION['rol'] ?? 'Usuario';
$currentPage = basename($_SERVER['PHP_SELF']);

$configPages = ['usuarios.php', 'sucursal.php', 'suerte.php', 'sorteo.php', 'rifa.php', 'imagen.php', 'general.php'];
$reportPages = ['reporte_fecha_eliminado.php','ventas_reporte.php', 'ganadores.php', 'caducados_r.php', 'reporte_fecha.php', 'reporte_u_p.php', 'reporte_u_p3c.php', 'reporte_u_p4c.php'];
//$appMovilPages = ['recargas.php', 'retiros.php', 'usuarios_app.php'];

$isConfigActive = in_array($currentPage, $configPages);
$isReportActive = in_array($currentPage, $reportPages);
//$isAppActive = in_array($currentPage, $appMovilPages);
?>
<style>
#toggleSidebar {
    position: fixed;
    top: 15px;
    left: 15px;
    z-index: 1100;
    background-color: #2c3e50;
    color: white;
    border: none;
    padding: 8px 12px;
    font-size: 18px;
    border-radius: 5px;
    display: none;
}
.sidebar {
    width: 250px;
    background-color: #2c3e50;
    color: white;
    min-height: 100vh;
    padding-top: 60px;
    position: fixed;
    top: 0;
    left: 0;
    overflow-y: auto;
    z-index: 1000;
    transition: all 0.3s ease;
}
.sidebar a {
    display: block;
    color: white;
    padding: 12px 20px;
    text-decoration: none;
    transition: background 0.3s ease;
}
.sidebar a:hover,
.sidebar a.active {
    background-color: #34495e;
}
.sidebar i {
    margin-right: 10px;
}
.sidebar .submenu {
    display: none;
    background-color: #34495e;
}
.sidebar .submenu a {
    padding-left: 40px;
    font-size: 0.95em;
    background-color: #3d566e;
}
@media (max-width: 768px) {
    #toggleSidebar {
        display: block;
    }
    .sidebar {
        transform: translateX(-100%);
    }
    .sidebar.show {
        transform: translateX(0);
    }
}
/* Parpadeo */
@keyframes parpadeo {
  0%, 100% { opacity: 1; }
  50% { opacity: 0.4; }
}
.badge-flash {
  animation: parpadeo 1s infinite;
}
</style>

<!-- Botón hamburguesa -->
<button id="toggleSidebar">☰</button>

<!-- Sidebar -->
<div class="sidebar" id="sidebar">
    <a href="index.php" class="<?= $currentPage === 'index.php' ? 'active' : '' ?>"><i class="fa fa-home"></i> <span>Inicio</span></a>

    <?php if (in_array($rol, [1, 3])): ?>
        <a href="#" class="submenu-toggle <?= $isConfigActive ? 'active' : '' ?>" data-target="configSubmenu">
            <i class="fas fa-cogs"></i> <span>Configuraciones</span>
        </a>
        <ul class="submenu" id="configSubmenu" style="display: <?= $isConfigActive ? 'block' : 'none' ?>;">
            <li><a href="general.php" class="<?= $currentPage === 'general.php' ? 'active' : '' ?>"><i class="fas fa-adjust"></i> General</a></li>
            <li><a href="usuarios.php" class="<?= $currentPage === 'usuarios.php' ? 'active' : '' ?>"><i class="fas fa-users"></i> Usuarios</a></li>
            <li><a href="sucursal.php" class="<?= $currentPage === 'sucursal.php' ? 'active' : '' ?>"><i class="fas fa-sitemap"></i> Sucursales</a></li>
            <?php if ($rol == 1): ?>
                <li><a href="suerte.php" class="<?= $currentPage === 'suerte.php' ? 'active' : '' ?>"><i class="fas fa-sort-amount-down-alt"></i> Suertes</a></li>
                <li><a href="sorteo.php" class="<?= $currentPage === 'sorteo.php' ? 'active' : '' ?>"><i class="fas fa-wrench"></i> Sorteos</a></li>
                <li><a href="rifa.php" class="<?= $currentPage === 'rifa.php' ? 'active' : '' ?>"><i class="fas fa-trophy"></i> Rifa</a></li>
                <li><a href="imagen.php" class="<?= $currentPage === 'imagen.php' ? 'active' : '' ?>"><i class="fa fa-camera"></i> Imágenes</a></li>
            <?php endif; ?>
        </ul>
    <?php endif; ?>

    <?php if (in_array($rol, [1, 3])): ?>
        <a href="#" class="submenu-toggle <?= $isReportActive ? 'active' : '' ?>" data-target="reportSubmenu">
            <i class="fas fa-chart-line"></i> <span>Reportes</span>
        </a>
        <ul class="submenu" id="reportSubmenu" style="display: <?= $isReportActive ? 'block' : 'none' ?>;">
            <li><a href="ventas_reporte.php" class="<?= $currentPage === 'ventas_reporte.php' ? 'active' : '' ?>"><i class="fas fa-dollar-sign"></i> Ventas por día</a></li>
            <li><a href="ganadores.php" class="<?= $currentPage === 'ganadores.php' ? 'active' : '' ?>"><i class="fas fa-trophy"></i> Ganadores por día</a></li>
            <li><a href="caducados_r.php" class="<?= $currentPage === 'caducados_r.php' ? 'active' : '' ?>"><i class="fas fa-times-circle"></i> Ganadores caducados</a></li>
            <li><a href="reporte_fecha.php" class="<?= $currentPage === 'reporte_fecha.php' ? 'active' : '' ?>"><i class="fas fa-calendar-alt"></i> Reporte por fecha</a></li>
            <li><a href="reporte_fecha_eliminado.php" class="<?= $currentPage === 'reporte_fecha_eliminado.php' ? 'active' : '' ?>"><i class="fas fa-calendar-alt"></i> Reporte eliminado</a></li>
            <li><a href="reporte_u_p.php" class="<?= $currentPage === 'reporte_u_p.php' ? 'active' : '' ?>"><i class="fas fa-coins"></i> Utilidad 2 cifras</a></li>
            <li><a href="reporte_u_p3c.php" class="<?= $currentPage === 'reporte_u_p3c.php' ? 'active' : '' ?>"><i class="fas fa-coins"></i> Utilidad 3 cifras</a></li>
            <li><a href="reporte_u_p4c.php" class="<?= $currentPage === 'reporte_u_p4c.php' ? 'active' : '' ?>"><i class="fas fa-coins"></i> Utilidad 4 cifras</a></li>
        </ul>
    <?php endif; ?>

    <?php //if (in_array($rol, [1, 5])): ?>
        <!--a href="#" class="submenu-toggle <?= $isAppActive ? 'active' : '' ?>" data-target="appSubmenu">
            <i class="fas fa-mobile-alt"></i> <span>Rifa APP Móvil</span>
        </a>
        <ul class="submenu" id="appSubmenu" style="display: <?= $isAppActive ? 'block' : 'none' ?>;">
            <li>
                <a href="recargas.php" class="<?= $currentPage === 'recargas.php' ? 'active' : '' ?>">
                    <i class="fas fa-battery-full"></i> Recargas
                    <span id="badgeRecargas" class="badge bg-warning text-dark ms-2 d-none">0</span>
                </a>
            </li>
            <li>
                <a href="retiros.php" class="<?= $currentPage === 'retiros.php' ? 'active' : '' ?>">
                    <i class="fas fa-wallet"></i> Retiros
                    <span id="badgeRetiro" class="badge bg-warning text-dark ms-2 d-none">0</span>
                </a>
            </li>
			<li>
				<a href="usuarios_app.php" class="<?= $currentPage === 'usuarios_app.php' ? 'active' : '' ?>">
					<i class="fas fa-users"></i> Datos de Usuarios
					<span id="badgeRetiro" class="badge bg-warning text-dark ms-2 d-none">0</span>
				</a>
			</li>


        </ul-->
    <?php //endif; ?>
	<?php if (in_array($rol, [1, 3])): ?>
		<a href="historial.php" class="<?= $currentPage === 'historial.php' ? 'active' : '' ?>"><i class="fa fa-history"></i> <span>Historial</span></a>
    <?php endif; ?>
	<a href="javascript:void(0)" onclick="cerrar();" aria-label="Cerrar sesión">
        <i class="fas fa-sign-out-alt"></i> <span>Cerrar Sesión</span>
    </a>
</div>

<!-- Scripts -->
<script>
//let prevRecargas = 0;
//let prevRetiros = 0;

function cerrar() {
    if (confirm("¿Estás segura de que deseas cerrar sesión?")) {
        window.location.href = "cerrar.php";
    }
}

/*function reproducirSonido() {
    const sonido = document.getElementById('notiSound');
    if (sonido) sonido.play();
}*/

/*function mostrarToast(mensaje) {
    Swal.fire({
        toast: true,
        position: 'top-end',
        icon: 'info',
        title: mensaje,
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true
    });
}*/

/*function actualizarContadorPendientes() {
    fetch('usuarios_app_m.php')
        .then(res => res.json())
        .then(data => {
            const badge = document.getElementById('badgeRecargas');
            if (badge) {
                const total = parseInt(data.total || 0);
                badge.textContent = total;

                if (total > 0) {
                    badge.classList.remove('d-none');
                    if (total > prevRecargas) {
                        badge.classList.add('badge-flash');
                        reproducirSonido();
                        mostrarToast(`📥 ${total} recargas pendientes`);
                    }
                } else {
                    badge.classList.add('d-none');
                }

                if (total <= prevRecargas) {
                    badge.classList.remove('badge-flash');
                }

                prevRecargas = total;
            }
        });
}*/

/*function actualizarBadgeRetiros() {
    fetch('retiros_count.php')
        .then(res => res.json())
        .then(data => {
            const badge = document.getElementById('badgeRetiro');
            if (badge) {
                const total = parseInt(data.total || 0);
                badge.textContent = total;

                if (total > 0) {
                    badge.classList.remove('d-none');
                    if (total > prevRetiros) {
                        badge.classList.add('badge-flash');
                        reproducirSonido();
                        mostrarToast(`💸 ${total} retiros pendientes`);
                    }
                } else {
                    badge.classList.add('d-none');
                }

                if (total <= prevRetiros) {
                    badge.classList.remove('badge-flash');
                }

                prevRetiros = total;
            }
        });
}*/

// Sidebar y actualizaciones
document.addEventListener("DOMContentLoaded", function () {
    document.getElementById("toggleSidebar").addEventListener("click", function () {
        document.getElementById("sidebar").classList.toggle("show");
    });

    document.querySelectorAll(".submenu-toggle").forEach(toggle => {
        toggle.addEventListener("click", function (e) {
            e.preventDefault();
            const submenu = document.getElementById(this.dataset.target);
            const isVisible = submenu.style.display === "block";

            document.querySelectorAll(".submenu").forEach(ul => ul.style.display = "none");
            document.querySelectorAll(".submenu-toggle").forEach(t => t.classList.remove("active"));

            if (!isVisible) {
                submenu.style.display = "block";
                this.classList.add("active");
            }
        });
    });

    /*actualizarContadorPendientes();
    actualizarBadgeRetiros();
    setInterval(() => {
        actualizarContadorPendientes();
        actualizarBadgeRetiros();
    }, 10000);*/
});
</script>
