<?php
	session_start();
	include("conex.php");

	// Obtener datos de sesión
	$usuario = $_SESSION['usuario'];
	$idusuario = $_SESSION['idusuario'];
	$sucursal = $_SESSION['sucursal'];
	$rol = $_SESSION['rol'];
	date_default_timezone_set('America/Guayaquil');
    $fecha_actual = date('Y-m-d');
	// Validar si el usuario tiene permiso
	if ($rol != 1 AND $rol != 3 ) {
		// Mostrar página de acceso denegado
		echo '
		<!DOCTYPE html>
		<html lang="es">
		<head>
			<meta charset="UTF-8">
			<meta name="viewport" content="width=device-width, initial-scale=1.0">
			<title>Acceso Denegado</title>
			<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
			<style>
				body {
					display: flex;
					justify-content: center;
					align-items: center;
					height: 100vh;
					background-color: #f8d7da;
					text-align: center;
				}
				.container {
					background: white;
					padding: 30px;
					border-radius: 10px;
					box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.2);
				}
				.btn-exit {
					margin-top: 15px;
					background: #dc3545;
					color: white;
					border: none;
					padding: 10px 20px;
					border-radius: 5px;
					cursor: pointer;
				}
				.btn-exit:hover {
					background: #c82333;
				}
				
				.menu {
    list-style: none;
    padding: 0;
    margin: 0;
    width: 250px;
}

.menu li {
    border-bottom: 1px solid #ccc;
}

.submenu-toggle {
    display: block;
    padding: 10px 15px;
    text-decoration: none;
    color: #333;
    cursor: pointer;
    background: #f4f4f4;
    transition: background 0.3s;
}

.submenu-toggle.active {
    background: #ddd;
}

.submenu {
    max-height: 0;
    overflow: hidden;
    transition: max-height 0.3s ease;
    background: #f9f9f9;
}

.submenu.active {
    max-height: 300px;
}

.submenu li a {
    display: block;
    padding: 10px 30px;
    text-decoration: none;
    color: #555;
}

.submenu li a:hover {
    background-color: #eee;
}

			</style>
		</head>
		<body>
			<div class="container">
				<h2>Acceso Denegado</h2>
				<p>No tienes permiso para acceder a esta página.</p>
				<button class="btn-exit" onclick="salir()">Salir</button>
			</div>
			<script>
				function salir() {
					window.location.href = "../administracion.php"; // Redirige a la página de inicio o login
				}
				
			</script>
		</body>
		
		</html>';
		exit();
	}
?>
<!DOCTYPE html>
<html lang="es">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<title>Sistema de Gestión</title>
		<link rel="shortcut icon" href="../resources/img/crud.ico">
		<!-- Bootstrap CSS -->
		<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
		<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
		<style>
			body {
				background-color: #f4f6f9;
				padding-top: 60px;
				overflow-x: hidden;
			}

			.topbar {
				width: 100%;
				height: 60px;
				background: #343a40;
				color: white;
				display: flex;
				align-items: center;
				justify-content: space-between;
				padding: 0 20px;
				position: fixed;
				top: 0;
				left: 0;
				z-index: 1000;
			}

			.sidebar {
				width: 250px;
				background: #343a40;
				padding: 20px;
				height: 100vh;
				position: fixed;
				left: 0;
				top: 60px;
				display: flex;
				flex-direction: column;
				align-items: flex-start;
				transition: width 0.3s;
				z-index: 1000;
			}

			.main-content {
				margin-left: 250px;
				padding: 1rem;
				transition: margin-left 0.3s;
				z-index: 100;
			}

			.sidebar.collapsed {
				width: 80px;
			}

			.sidebar a {
				color: white;
				text-decoration: none;
				padding: 12px;
				display: flex;
				align-items: center;
				width: 100%;
			}

			#imagenActualContainer {
				text-align: center;
			}

			#imagenActualContainer img {
				max-width: 100%;
				height: auto;
			}

			/* Estilos para el gráfico */
			#graficoBarras {
				width: 25vw; /* 25% del ancho de la ventana */
				height: 25vh; /* 25% de la altura de la ventana */
				max-width: 600px;  /* Limita el tamaño máximo a 500px */
				max-height: 300px; /* Limita la altura máxima a 500px */
			}
			
			/* Estilos para el gráfico */
			#graficoBarras2 {
				width: 25vw; /* 25% del ancho de la ventana */
				height: 25vh; /* 25% de la altura de la ventana */
				max-width: 600px;  /* Limita el tamaño máximo a 500px */
				max-height: 300px; /* Limita la altura máxima a 500px */
			}
		</style>
	</head>
	<body>

		<!-- Barra Superior -->
		<div class="topbar">
			<div class="toggle-btn" onclick="toggleSidebar()">
				<i class="fas fa-bars"></i>
			</div>
			<span>Sistema de Gestión</span>
			<div class="info">
				<span><?php echo $usuario; ?></span>
				<span id="fechaActual"></span>
				<span id="horaActual"></span>
			</div>
		</div>

		<!-- Sidebar -->
		<?php include("menu.php"); ?>

		<!-- Contenido Principal -->
		<div class="main-content">
		    <div class="row">
                <canvas id="graficoBarras"></canvas>
                <canvas id="graficoBarras2"></canvas>
            </div>
		</div>
		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
		<!-- Asegúrate de que los scripts necesarios estén cargados -->
		<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
		<script src="../../resources/media/js/jquery.dataTables.min.js"></script>
		<script src="../../resources/media/js/dataTables.bootstrap.min.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
		<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
		<!-- Scripts -->
		<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
		

		<script>
			// Datos pasados desde PHP
			var usuarios = <?php
				$query = "
				SELECT u.usuario, SUM(t.valor) AS total_valor
				FROM tbr_ticket AS t
				INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
				WHERE t.condicion = 1 
				AND t.estado >= 2
				AND t.fecha_impreso = '$fecha_actual'
				GROUP BY u.usuario
				ORDER BY u.usuario;
				";

				$result = mysqli_query($conn, $query);

				$usuarios = [];
				$totales = [];
				while ($row = mysqli_fetch_assoc($result)) {
					$usuarios[] = $row['usuario'];
					$totales[] = (float)$row['total_valor'];
				}

				echo json_encode($usuarios);
			?>;

			var totales = <?php
				echo json_encode($totales);
			?>;

			// Crear el gráfico
			var ctx = document.getElementById('graficoBarras').getContext('2d');
			var chart = new Chart(ctx, {
				type: 'bar', // Tipo de gráfico
				data: {
					labels: usuarios, // Los usuarios como etiquetas en el eje X
					datasets: [{
						label: 'Total Valor por Día',
						data: totales, // Los totales como datos de las barras
						backgroundColor: 'rgba(31, 153, 235, 1)', // Color de las barras
						borderColor: 'rgba(54, 162, 235, 1)', // Color de los bordes
						borderWidth: 1
					}]
				},
				options: {
					responsive: true,
					scales: {
						x: {
							title: {
								display: true,
								text: 'Usuarios'
							}
						},
						y: {
							title: {
								display: true,
								text: 'Total Valor'
							},
							beginAtZero: true
						}
					}
				}
			});
		</script>
		<script>
			// Datos pasados desde PHP
			var usuarios = <?php
				$query = "
				        SELECT 
				            su.sucursal,   
                            SUM(t.valor) AS total_valor      
                        FROM tbr_ticket AS t
                        INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
                        INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
                        INNER JOIN tbr_sucursal AS su ON su.idsucursal = u.id_sucursal
                        WHERE t.condicion = 1 
                          AND t.estado >= 2
                          AND t.fecha_impreso = '$fecha_actual'
                        GROUP BY su.sucursal
                        ORDER BY su.sucursal
				";

				$result = mysqli_query($conn, $query);

				$usuarios = [];
				$totales = [];
				while ($row = mysqli_fetch_assoc($result)) {
					$usuarios[] = $row['sucursal'];
					$totales[] = (float)$row['total_valor'];
				}

				echo json_encode($usuarios);
			?>;

			var totales2 = <?php
				echo json_encode($totales);
			?>;

			// Crear el gráfico
			var ctx = document.getElementById('graficoBarras2').getContext('2d');
			var chart = new Chart(ctx, {
				type: 'bar', // Tipo de gráfico
				data: {
					labels: usuarios, // Los usuarios como etiquetas en el eje X
					datasets: [{
						label: 'Total valor por días',
						data: totales2, // Los totales como datos de las barras
						backgroundColor: 'rgba(31, 153, 235, 1)', // Color de las barras
						borderColor: 'rgba(54, 162, 235, 1)', // Color de los bordes
						borderWidth: 1
					}]
				},
				options: {
					responsive: true,
					scales: {
						x: {
							title: {
								display: true,
								text: 'Sucursales'
							}
						},
						y: {
							title: {
								display: true,
								text: 'Total Valor'
							},
							beginAtZero: true
						}
					}
				}
			});
		</script>
		<script>
			// Función para actualizar la fecha y hora en la barra superior
			function actualizarHora() {
				const ahora = new Date();
				const opcionesFecha = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
				const opcionesHora = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
				document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opcionesFecha);
				document.getElementById('horaActual').textContent = ahora.toLocaleTimeString('es-ES', opcionesHora);
			}
			setInterval(actualizarHora, 1000);
			actualizarHora();
		
			// Función para alternar la visibilidad del sidebar
			function toggleSidebar() {
				const sidebar = document.getElementById('sidebar');
				const mainContent = document.getElementById('mainContent');
				sidebar.classList.toggle('collapsed');
				mainContent.style.marginLeft = sidebar.classList.contains('collapsed') ? '80px' : '250px';
			}
		
			function cerrar() {
				Swal.fire({
					title: '¿Estás seguro?',
					text: '¿Deseas cerrar sesión?',
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'Sí, cerrar sesión',
					cancelButtonText: 'Cancelar'
				}).then((result) => {
					if (result.isConfirmed) {
						fetch('../../controllers/usuario.php', {
							method: 'POST',
							headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
							body: new URLSearchParams({ boton: 'cerrar' })
						})
						.then(response => response.ok ? location.href = '../administracion.php' : Promise.reject(response.statusText))
						.catch(error => Swal.fire('Error', 'Hubo un error al cerrar sesión: ' + error, 'error'));
					}
				});
			}
		</script>
	</body>
</html>
