<?php
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}

$id_usuario = $_SESSION['idusuario'];
$sucursal_id = $_SESSION['sucursal'] ?? null;
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');

if (!isset($conn) || !$conn) {
    echo json_encode(["error" => "No se pudo establecer conexión con la base de datos."]);
    exit();
}

// Sanitización y validación de datos
$sucursal = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_STRING);
$cupo = filter_input(INPUT_POST, 'cupo', FILTER_VALIDATE_INT) ?: 0;
$cupo3 = 0;
$cupo4 = 0;
$activo = 0;
$condicion = 1;

if (empty($sucursal)) {
    echo json_encode(["error" => "Todos los campos son obligatorios."]);
    exit();
}

// Manejo de imagen
$target_dir = "imagen/"; // Carpeta donde se guardarán las imágenes
if (!file_exists($target_dir)) {
    mkdir($target_dir, 0777, true); // Crear la carpeta si no existe
}

$imagen_url = null; // Por defecto, no hay imagen

if (!empty($_FILES['imagen']['name'])) {
    $imagen_nombre = basename($_FILES['imagen']['name']);
    $imagen_extension = strtolower(pathinfo($imagen_nombre, PATHINFO_EXTENSION));

    // Validar tipo de archivo
    $extensiones_permitidas = ['jpg', 'jpeg', 'png', 'gif'];
    if (!in_array($imagen_extension, $extensiones_permitidas)) {
        echo json_encode(["error" => "Formato de imagen no permitido. Use JPG, JPEG, PNG o GIF."]);
        exit();
    }

    // Asignar un nombre único a la imagen
    $nuevo_nombre = uniqid("sucursal_") . "." . $imagen_extension;
    $ruta_completa = $target_dir . $nuevo_nombre;

    // Mover la imagen al servidor
    if (!move_uploaded_file($_FILES['imagen']['tmp_name'], $ruta_completa)) {
        echo json_encode(["error" => "Error al subir la imagen."]);
        exit();
    }

    $imagen_url = $ruta_completa; // Guardar la ruta para la base de datos
}

// Insertar sucursal en la base de datos
$sql_insert = "INSERT INTO tbr_sucursal (sucursal, activo, cupo, cupo_3c, cupo_4c, condicion, id_usuario, imagen) 
               VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = mysqli_prepare($conn, $sql_insert);
if (!$stmt) {
    echo json_encode(["error" => "Error en la preparación de la consulta: " . mysqli_error($conn)]);
    exit();
}

mysqli_stmt_bind_param($stmt, "siiiiiis", $sucursal, $activo, $cupo, $cupo3, $cupo4, $condicion, $id_usuario, $imagen_url);
$insert_success = mysqli_stmt_execute($stmt);

if (!$insert_success) {
    echo json_encode(["error" => "Error al insertar sucursal: " . mysqli_error($conn)]);
    exit();
}

$idusuario = mysqli_insert_id($conn);
mysqli_stmt_close($stmt);

if ($idusuario === 0) {
    echo json_encode(["error" => "Error: No se pudo obtener el ID de la sucursal."]);
    exit();
}

// Enviar respuesta de éxito con la URL de la imagen
echo json_encode(["success" => "Sucursal registrada exitosamente.", "idusuario" => $idusuario, "imagen" => $imagen_url]);

// Cerrar conexión
mysqli_close($conn);
?>
