<?php
// Iniciar sesión
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}

$id_usuario = $_SESSION['idusuario'];
$sucursal_id = $_SESSION['sucursal'] ?? null;
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');

if (!isset($conn) || !$conn) {
    echo json_encode(["error" => "No se pudo establecer conexión con la base de datos."]);
    exit();
}

// Sanitización y validación de datos
$idsorteo_a = filter_input(INPUT_POST, 'idsorteo_a', FILTER_VALIDATE_INT);
$fecha_a = filter_input(INPUT_POST, 'fecha_a', FILTER_SANITIZE_STRING);
$loteria_a = filter_input(INPUT_POST, 'loteria_a', FILTER_VALIDATE_INT);
$suerte_a = filter_input(INPUT_POST, 'suerte_a', FILTER_VALIDATE_INT);
$numero_a = filter_input(INPUT_POST, 'numero_a', FILTER_SANITIZE_STRING);;


//echo $suerte_a;

if ($fecha_a === false || $loteria_a === false || empty($suerte_a) || empty($numero_a)) {
    echo json_encode(["error" => "Todos los campos son obligatorios y deben tener un formato valido."]);
    exit();
}

// Consulta para actualizar los datos en la base de datos
$query = "UPDATE tbr_sorteo SET fecha_g = ?, suerte_g = ?, numero_g = ?, id_loteria = ? WHERE idsorteo = ?";

// Preparar la sentencia SQL
$stmt = $conn->prepare($query);

if ($stmt === false) {
    echo json_encode(["error" => "Error al preparar la consulta: " . $conn->error]);
    exit();
}

// Bind de los parámetros
$stmt->bind_param("sisii", $fecha_a, $suerte_a, $numero_a, $loteria_a, $idsorteo_a);

// Ejecutar la consulta
if ($stmt->execute()) {
    echo json_encode(["success" => true]);
} else {
    echo json_encode(["success" => false, "error" => $stmt->error]);
}

// Cerrar la conexión
$stmt->close();
$conn->close();
?>
