<?php
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}

$id_usuario = $_SESSION['idusuario'];
$sucursal_id = $_SESSION['sucursal'] ?? null;
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');

// Verificar la conexión
if (!isset($conn) || !$conn) {
    echo json_encode(["error" => "No se pudo establecer conexión con la base de datos."]);
    exit();
}

// Sanitización y validación de datos
$idsucursal = filter_input(INPUT_POST, 'idsucursal_a', FILTER_VALIDATE_INT);
$sucursal = filter_input(INPUT_POST, 'sucursal_a', FILTER_SANITIZE_STRING);
$cupo = filter_input(INPUT_POST, 'cupo_a', FILTER_VALIDATE_INT);
$cupo3 =0;
$cupo4 = 0;

if ($sucursal === false || $cupo === false) {
    echo json_encode(["error" => "Todos los campos son obligatorios y deben tener un formato válido."]);
    exit();
}

// Manejo de imagen
$target_dir = "imagen/"; // Carpeta donde se guardarán las imágenes
if (!file_exists($target_dir)) {
    mkdir($target_dir, 0777, true); // Crear la carpeta si no existe
}

$imagen_url = null; // Por defecto, no hay imagen

if (!empty($_FILES['imagen']['name'])) {
    $imagen_nombre = basename($_FILES['imagen']['name']);
    $imagen_extension = strtolower(pathinfo($imagen_nombre, PATHINFO_EXTENSION));

    // Validar tipo de archivo
    $extensiones_permitidas = ['jpg', 'jpeg', 'png', 'gif'];
    if (!in_array($imagen_extension, $extensiones_permitidas)) {
        echo json_encode(["error" => "Formato de imagen no permitido. Use JPG, JPEG, PNG o GIF."]);
        exit();
    }

    // Asignar un nombre único a la imagen
    $nuevo_nombre = uniqid("sucursal_") . "." . $imagen_extension;
    $ruta_completa = $target_dir . $nuevo_nombre;

    // Mover la imagen al servidor
    if (!move_uploaded_file($_FILES['imagen']['tmp_name'], $ruta_completa)) {
        echo json_encode(["error" => "Error al subir la imagen."]);
        exit();
    }

    $imagen_url = $ruta_completa; // Guardar la ruta para la base de datos
}
 echo $imagen_url;
 

// Consulta para actualizar los datos en la base de datos
// Solo añadimos la columna imagen en la consulta si la imagen fue subida
$query = "UPDATE tbr_sucursal SET sucursal = ?, cupo = ?, cupo_3c = ?, cupo_4c = ?, imagen = ? WHERE idsucursal = ?";

// Preparar la sentencia SQL
$stmt = $conn->prepare($query);

if ($stmt === false) {
    echo json_encode(["error" => "Error al preparar la consulta: " . $conn->error]);
    exit();
}

// Bind de los parámetros
if ($imagen_url) {
    // Si hay imagen, vinculamos la ruta de la imagen
    $stmt->bind_param("siiisi", $sucursal, $cupo, $cupo3, $cupo4, $imagen_url, $idsucursal);
} else {
    // Si no hay imagen, solo vinculamos sucursal y cupo
    $stmt->bind_param("siiisi", $sucursal, $cupo, $cupo3, $cupo4, $imagen_url, $idsucursal);
}

// Ejecutar la consulta
if ($stmt->execute()) {
    echo json_encode(["success" => true]);
} else {
    echo json_encode(["success" => false, "error" => $stmt->error]);
}

// Cerrar la conexión
$stmt->close();
$conn->close();
?>
