<?php
// Iniciar sesión
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}

$id_usuario = $_SESSION['idusuario'];
$sucursal_id = $_SESSION['sucursal'] ?? null;
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');

if (!isset($conn) || !$conn) {
    echo json_encode(["error" => "No se pudo establecer conexión con la base de datos."]);
    exit();
}

// Sanitización y validación de datos
$idloteria_a = filter_input(INPUT_POST, 'idloteria_a', FILTER_VALIDATE_INT);
$loteria_a = filter_input(INPUT_POST, 'loteria_a', FILTER_SANITIZE_STRING);
$fecha_a = filter_input(INPUT_POST, 'fecha_a', FILTER_SANITIZE_STRING);
$dia_a = filter_input(INPUT_POST, 'dia_a', FILTER_SANITIZE_STRING);
$hora_inicio_a = filter_input(INPUT_POST, 'hora_inicio_a', FILTER_SANITIZE_STRING);
$hora_fin_a = filter_input(INPUT_POST, 'hora_fin_a', FILTER_SANITIZE_STRING);

// Extraer solo HH:mm y eliminar los dos puntos
$hora_inicio_a = str_replace(':', '', substr($hora_inicio_a, 0, 5));
$hora_fin_a = str_replace(':', '', substr($hora_fin_a, 0, 5));

//echo $usuario;

if ($loteria_a === false || $fecha_a === false || empty($dia_a) || empty($hora_inicio_a) || empty($hora_fin_a)) {
    echo json_encode(["error" => "Todos los campos son obligatorios y deben tener un formato válido."]);
    exit();
}

// Consulta para actualizar los datos en la base de datos
$query = "UPDATE tbr_loteria SET loteria = ?, dia = ?, fecha = ?, hora_inicio = ?, hora_fin = ? WHERE idloteria = ?";

// Preparar la sentencia SQL
$stmt = $conn->prepare($query);

if ($stmt === false) {
    echo json_encode(["error" => "Error al preparar la consulta: " . $conn->error]);
    exit();
}

// Bind de los parámetros
$stmt->bind_param("sssssi", $loteria_a, $dia_a, $fecha_a, $hora_inicio_a, $hora_fin_a, $idloteria_a);

// Ejecutar la consulta
if ($stmt->execute()) {
    echo json_encode(["success" => true]);
} else {
    echo json_encode(["success" => false, "error" => $stmt->error]);
}

// Cerrar la conexión
$stmt->close();
$conn->close();
?>
