<?php
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}

$id_usuario = $_SESSION['idusuario'];
$sucursal_id = $_SESSION['sucursal'] ?? null;
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');

// Verificar la conexión
if (!isset($conn) || !$conn) {
    echo json_encode(["error" => "No se pudo establecer conexión con la base de datos."]);
    exit();
}

// Sanitización y validación de datos
$idcifras = filter_input(INPUT_POST, 'idcifras_a', FILTER_VALIDATE_INT);
$cifras = filter_input(INPUT_POST, 'cifras_a', FILTER_SANITIZE_STRING);
$cupo = filter_input(INPUT_POST, 'cupo_a', FILTER_VALIDATE_INT);


if ($cifras === false || $cupo === false) {
    echo json_encode(["error" => "Todos los campos son obligatorios y deben tener un formato válido."]);
    exit();
}

// Consulta para actualizar los datos en la base de datos
// Solo añadimos la columna imagen en la consulta si la imagen fue subida
$query = "UPDATE tbr_cifras SET cifras = ?, cupo_cifras = ? WHERE idcifras = ?";

// Preparar la sentencia SQL
$stmt = $conn->prepare($query);

if ($stmt === false) {
    echo json_encode(["error" => "Error al preparar la consulta: " . $conn->error]);
    exit();
}
    // Si hay imagen, vinculamos la ruta de la imagen
    $stmt->bind_param("sii", $cifras, $cupo, $idcifras);


// Ejecutar la consulta
if ($stmt->execute()) {
    echo json_encode(["success" => true]);
} else {
    echo json_encode(["success" => false, "error" => $stmt->error]);
}

// Cerrar la conexión
$stmt->close();
$conn->close();
?>
