<?php
// Iniciar sesión
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}

$id_usuario = $_SESSION['idusuario'];
$sucursal_id = $_SESSION['sucursal'] ?? null;
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');

if (!isset($conn) || !$conn) {
    echo json_encode(["error" => "No se pudo establecer conexión con la base de datos."]);
    exit();
}

// Sanitización y validación de datos
$idusuario_a = filter_input(INPUT_POST, 'idusuario_a', FILTER_VALIDATE_INT);
$sucursal = filter_input(INPUT_POST, 'sucursal_a', FILTER_VALIDATE_INT);
$cupo = filter_input(INPUT_POST, 'cupo_a', FILTER_VALIDATE_INT);
$cupo3 = filter_input(INPUT_POST, 'cupo3_a', FILTER_VALIDATE_INT);
$cupo4 = filter_input(INPUT_POST, 'cupo4_a', FILTER_VALIDATE_INT);
$hora_inicio = filter_input(INPUT_POST, 'hora_inicio_a', FILTER_SANITIZE_STRING);
$hora_fin = filter_input(INPUT_POST, 'hora_fin_a', FILTER_SANITIZE_STRING);
$usuario = filter_input(INPUT_POST, 'usuario_a', FILTER_SANITIZE_STRING);
$clave = filter_input(INPUT_POST, 'clave_a', FILTER_SANITIZE_STRING);

//echo $usuario;

if ($sucursal === false || empty($hora_inicio) || empty($hora_fin) || empty($usuario) || empty($clave)) {
    echo json_encode(["error" => "Todos los campos son obligatorios y deben tener un formato válido."]);
    exit();
}

// Hashear la contraseña antes de guardarla
//$clave_hash = password_hash($clave, PASSWORD_BCRYPT);

// Consulta para actualizar los datos en la base de datos
$query = "UPDATE tbr_usuario SET id_sucursal = ?, extra_cupo = ?, extra_cupo3 = ?, extra_cupo4 = ?, hora_inicio_a = ?, hora_fin_a = ?, usuario = ?, clave = ? WHERE idusuario = ?";

// Preparar la sentencia SQL
$stmt = $conn->prepare($query);

if ($stmt === false) {
    echo json_encode(["error" => "Error al preparar la consulta: " . $conn->error]);
    exit();
}

// Bind de los parámetros
$stmt->bind_param("iiiissssi", $sucursal, $cupo, $cupo3, $cupo4, $hora_inicio, $hora_fin, $usuario, $clave, $idusuario_a);

// Ejecutar la consulta
if ($stmt->execute()) {
    echo json_encode(["success" => true]);
} else {
    echo json_encode(["success" => false, "error" => $stmt->error]);
}

// Cerrar la conexión
$stmt->close();
$conn->close();
?>
