<?php
session_start();
include("conex.php");
$usuario = $_SESSION['usuario'];
$idusuario = $_SESSION['idusuario'];
$sucursal = $_SESSION['sucursal'];
?>
<!DOCTYPE html>
<html lang="es">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<title>Sistema de Gestión</title>
		<link rel="shortcut icon" href="../resources/img/crud.ico">
		<!-- Bootstrap CSS -->
		<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
		<style>
			body {
				background-color: #f4f6f9;
				padding-top: 60px;
				overflow-x: hidden; /* Evitar desplazamiento horizontal */
			}

			.topbar {
				width: 100%;
				height: 60px;
				background: #343a40;
				color: white;
				display: flex;
				align-items: center;
				justify-content: space-between;
				padding: 0 20px;
				position: fixed;
				top: 0;
				left: 0;
				z-index: 1000;
			}

			.sidebar {
				width: 250px;
				background: #343a40;
				padding: 20px;
				height: 100vh;
				position: fixed;
				left: 0;
				top: 60px;
				display: flex;
				flex-direction: column;
				align-items: flex-start;
				transition: width 0.3s;
				z-index: 1000; /* Asegura que el sidebar tenga un z-index menor que el modal */
			}

			.main-content {
				margin-left: 250px;
				padding: 1rem;
				transition: margin-left 0.3s; /* Para cuando se colapse el sidebar */
				z-index: 100; /* Asegura que el contenido principal no se desorganice al mostrar el modal */
			}

			.modal-backdrop {
				z-index: 1040 !important; /* Asegura que el fondo del modal esté por encima del sidebar */
			}

			.modal-dialog {
				z-index: 1050 !important; /* Asegura que el contenido del modal esté por encima del sidebar */
			}

			.sidebar.collapsed {
				width: 80px;
			}

			.sidebar.collapsed a span {
				display: none;
			}

			.toggle-btn {
				cursor: pointer;
				margin-right: 10px;
			}

			/* Ajustar la visibilidad del sidebar al colapsar */
			.sidebar a {
				color: white;
				text-decoration: none;
				padding: 12px;
				display: flex;
				align-items: center;
				width: 100%;
				transition: background 0.3s, transform 0.2s;
				border-radius: 8px;
			}

			.sidebar .submenu {
				display: none;
				padding-left: 20px;
				list-style: none;
				margin: 0;
				font-size: 14px;
			}

			.sidebar .submenu li {
				padding: 8px 0;
			}

			.sidebar a:hover, .sidebar a.active {
				background: #495057;
				transform: scale(1.05);
			}
			
			/* Estilos del interruptor */
			.switch {
			  position: relative;
			  display: inline-block;
			  width: 60px;
			  height: 34px;
			}

			.switch input {
			  opacity: 0;
			  width: 0;
			  height: 0;
			}
			.slider {
			  position: absolute;
			  cursor: pointer;
			  top: 0;
			  left: 0;
			  right: 0;
			  bottom: 0;
			  background-color: #ccc;
			  transition: 0.4s;
			  border-radius: 34px;
			}

			.slider:before {
			  position: absolute;
			  content: "";
			  height: 26px;
			  width: 26px;
			  border-radius: 50%;
			  left: 4px;
			  bottom: 4px;
			  background-color: white;
			  transition: 0.4s;
			}

			input:checked + .slider {
			  background-color: #4CAF50;
			}

			input:checked + .slider:before {
			  transform: translateX(26px);
			}
			
			#imagenActualContainer {
				text-align: center; /* Centra la imagen dentro del contenedor */
			}

			#imagenActualContainer img {
				max-width: 100%;  /* Asegura que la imagen no sobrepase el ancho del contenedor */
				height: auto;     /* Mantiene la proporción de la imagen */
			}
			#imagenActualContainer {
				text-align: center; /* Centra la imagen dentro del contenedor */
				height: 150px; /* Altura fija para el contenedor */
				display: flex;
				justify-content: center;
				align-items: center;
				overflow: hidden; /* Asegura que la imagen no se desborde del contenedor */
			}

			#imagenActualContainer img {
				max-width: 100%;  /* La imagen no debe exceder el ancho del contenedor */
				height: 100%;     /* La imagen se ajustará a la altura fija */
				object-fit: contain; /* Mantiene la proporción sin recortar la imagen */
			}	
		</style>
	</head>
	<body>

		<!-- Barra Superior -->
		<div class="topbar">
			<div class="toggle-btn" onclick="toggleSidebar()">
				<i class="fas fa-bars"></i>
			</div>
			<span style="margin-left: 20px;">Sistema de Gestión</span>
			<div class="info">
				<span><?php echo $usuario; ?></span>
				<span id="fechaActual"></span>
				<span id="horaActual"></span>
			</div>
		</div>

		<!-- Sidebar -->
		<?php include("menu.php"); ?>
		<!-- Contenido Principal -->
		<div class="main-content">
			<div class="col-lg-12 col-md-12">
				<div class="panel panel-WHITE">
					<div class="panel-heading">
						<div class="row">
							<div class="col-md-12"> 
								<button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#agregar">Agregar Cifra</button>
							</div>                    
							<div class="col-md-12">
								<table id="usuar" class="table table-hover" cellspacing="0" width="100%">
									<thead>
										<tr class="info">
											<th>Cifras</th>
											<th>Cupo</th>											
											<th>Acción</th>
										</tr>
									</thead>
									<tbody>
										<!-- Aquí se carga dinámicamente el contenido -->
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- Modal -->
		<div class="modal fade" id="agregar" tabindex="-1" aria-labelledby="agregar_empresaLabel" aria-hidden="true">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title" id="agregarLabel">Agregar nueva cifra</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					
					<div class="modal-body">
						<!-- Formulario de agregar usuario -->
						<form id="formAgregarUsuario">
							<div class="row">
								<div class="col-lg-8 col-md-8">
									<div class="form-group">
										<label for="cifra">Cifra*</label>
										 <input type="text" class="form-control" id="cifra" name="cifra" required>
									</div>
								</div>
								<div class="col-lg-4 col-md-4">
									<div class="form-group">
										<label for="cupo">Cupo cifra*</label>
										<input type="number" class="form-control" id="cupo" name="cupo" required>
									</div>
								</div>								
							</div>
						</form>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
						<button type="button" class="btn btn-primary" onclick="guardar()">Guardar</button>
					</div>
				</div>
			</div>
		</div>

		<!-- Modal para editar -->
		<div id="modalEditar" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalEditarLabel">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title" id="modalEditarLabel">Editar Cifra</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>                    
					</div>
					<div class="modal-body">
						<form id="formEditar" enctype="multipart/form-data">
							<div class="row">
								<input type="hidden" id="idcifras_a" name="idcifras_a">
								
								<div class="col-lg-8 col-md-8">
									<div class="form-group">
										<label for="cifras_a">Cifras*</label>
										 <input type="text" class="form-control" id="cifras_a" name="cifras_a" required>
									</div>
								</div>
								<div class="col-lg-4 col-md-4">
									<div class="form-group">
										<label for="cupo_a">Cupo cifras*</label>
										<input type="number" class="form-control" id="cupo_a" name="cupo_a" required>
									</div>
								</div>								
							</div>                    
						</form>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
						<button type="button" class="btn btn-primary" onclick="actualizar()">Guardar Cambios</button>
					</div>
				</div>
			</div>
		</div>
		<!-- Scripts -->
		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
		<!-- Asegúrate de que los scripts necesarios estén cargados -->
		<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
		<script src="../../resources/media/js/jquery.dataTables.min.js"></script>
		<script src="../../resources/media/js/dataTables.bootstrap.min.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
		<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
		<script src="../../resources/js/menu_cifras.js"></script>
		<script>
			// Función para actualizar la fecha y hora en la barra superior
			function actualizarHora() {
				const ahora = new Date();
				const opcionesFecha = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
				const opcionesHora = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
				document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opcionesFecha);
				document.getElementById('horaActual').textContent = ahora.toLocaleTimeString('es-ES', opcionesHora);
			}
			setInterval(actualizarHora, 1000);
			actualizarHora();
    
			// Función para alternar la visibilidad del sidebar
			function toggleSidebar() {
				const sidebar = document.getElementById('sidebar');
				const mainContent = document.getElementById('mainContent');
				sidebar.classList.toggle('collapsed');
				mainContent.style.marginLeft = sidebar.classList.contains('collapsed') ? '80px' : '250px';
			}
		
			//funcion para bloquear cifra
			$(document).ready(function () {
				$(document).on("click", ".toggle-condicion", function () {
					let boton = $(this);
					let id = boton.data("id");

					Swal.fire({
						title: "¿Estás seguro?",
						text: "La cifra será eliminada.",
						icon: "warning",
						showCancelButton: true,
						confirmButtonColor: "#d33",
						cancelButtonColor: "#3085d6",
						confirmButtonText: "Sí, eliminar",
						cancelButtonText: "Cancelar"
					}).then((result) => {
						if (result.isConfirmed) {
							$.ajax({
								url: "actualizar_condicion_c.php",
								type: "POST",
								data: { id: id },
								dataType: "json",
								success: function (response) {
									if (response.success) {
										Swal.fire({
											icon: "success",
											title: "Cifra eliminada",
											text: "La cifra ha sido eliminada correctamente.",
											timer: 3000
										});

										// Recargar la tabla automáticamente
										$("#usuar").DataTable().ajax.reload(null, false);
									} else {
										Swal.fire("Error", "No se pudo eliminar.", "error");
									}
								},
								error: function () {
									Swal.fire("Error", "Error de conexión con el servidor.", "error");
								}
							});
						}
					});
				});
			});

			//funcion guardar	
			function guardar() {
				var formData = new FormData();
				formData.append('cifra', $('#cifra').val());
				formData.append('cupo', $('#cupo').val());				
				
				// Validar que todos los campos estén llenos
				if (!$('#cifra').val() || !$('#cupo').val()) {
					Swal.fire("Error", "Por favor, complete todos los campos obligatorios.", "error");
					return;
				}

				$.ajax({
					url: 'guardar_cifra.php', // Archivo PHP para procesar los datos
					type: 'POST',
					data: formData,
					contentType: false,
					processData: false,
					beforeSend: function () {
						$('button[onclick="guardar()"]').prop('disabled', true);
					},
					success: function (response) {
						//alert(response);
						try {
							var jsonData = JSON.parse(response);
							if (jsonData.success) {
								Swal.fire({
									title: 'Éxito',
									text: 'La cifra fue guardada correctamente.',
									icon: 'success',
									confirmButtonText: 'OK',
									timer: 2000
								}).then((result) => {
									if (result.isConfirmed || result.isDismissed) {
										location.reload(); // Recargar la página
									}
								});
							} else {
								Swal.fire("Error", jsonData.message, "error");
							}
						} catch (e) {
							Swal.fire("Error", "Hubo un problema en el servidor.", "error");
							console.error("Error en la respuesta: ", response);
						}
					},
					error: function (xhr, status, error) {
						Swal.fire("Error", "Ocurrió un error al guardar los datos.", "error");
						console.error(error);
					},
					complete: function () {
						$('button[onclick="guardar()"]').prop('disabled', false);
					}
				});
			}
	
			// Función para editar registro de sucursal
			$(document).on('click', '.toggle-editar', function() {
				var idcifras_a = $(this).data('id');        
				var cifras_a = $(this).data('cifras');
				var cupo_a = $(this).data('cupo');				        
				

				// Cargar los datos en el formulario del modal
				$('#idcifras_a').val(idcifras_a);        
				$('#cifras_a').val(cifras_a);
				$('#cupo_a').val(cupo_a);				

				
				// Mostrar el modal
				$('#modalEditar').modal('show');
			});
	
			//funcion para actualizar
			function actualizar() {
				// Obtener los valores de los campos
				var idcifras_a = $('#idcifras_a').val();        
				var cifras_a = $('#cifras_a').val();
				var cupo_a = $('#cupo_a').val();				
				
				// Validar que todos los campos estén llenos
				if (!cifras_a || !cupo_a) {
					Swal.fire("Error", "Por favor, complete todos los campos obligatorios.", "error");
					return;
				}

				// Crear un objeto FormData para enviar datos junto con el archivo
				var formData = new FormData();
				formData.append('idcifras_a', idcifras_a);
				formData.append('cifras_a', cifras_a);
				formData.append('cupo_a', cupo_a);				
				
				// Enviar los datos por AJAX usando FormData
				$.ajax({
					url: 'guardar_edicion_c.php', // Reemplaza con la URL correcta
					type: 'POST',
					data: formData,
					processData: false,  // Importante para evitar que jQuery intente procesar los datos
					contentType: false,  // Esto también es necesario cuando se envía un FormData
					beforeSend: function () {
						// Deshabilitar el botón para evitar envíos múltiples
						$('button[onclick="actualizar()"]').prop('disabled', true);
					},
					success: function (response) {
						// Alerta de éxito
						//alert (response);
						Swal.fire({
							title: 'Éxito',
							text: 'La cifra fue actualizada correctamente.',
							icon: 'success',
							confirmButtonText: 'OK',
							timer: 2000
						}).then((result) => {
							if (result.isConfirmed || result.isDismissed) {
								location.reload(); // Recargar la página después de cerrar la alerta
							}
						});
					},
					error: function (xhr, status, error) {
						Swal.fire("Error", "Ocurrió un error al guardar los datos.", "error");
						console.error(error);
					},
					complete: function () {
						// Rehabilitar el botón después de completar la solicitud
						$('button[onclick="actualizar()"]').prop('disabled', false);
					}
				});
			}
			
			function cerrar() {
				Swal.fire({
					title: '¿Estás seguro?',
					text: '¿Deseas cerrar sesión?',
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'Sí, cerrar sesión',
					cancelButtonText: 'Cancelar'
				}).then((result) => {
					if (result.isConfirmed) {
						fetch('../../controllers/usuario.php', {
							method: 'POST',
							headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
							body: new URLSearchParams({ boton: 'cerrar' })
						})
						.then(response => response.ok ? location.href = '../administracion.php' : Promise.reject(response.statusText))
						.catch(error => Swal.fire('Error', 'Hubo un error al cerrar sesión: ' + error, 'error'));
					}
				});
			}
		</script>
	</body>
</html>
