<?php
// Devuelve idusuario, usuario, sucursal, ip
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
session_start();

require_once __DIR__ . '/conex.php';
/** @var mysqli $db */
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { echo json_encode(['data'=>[]]); exit; }
mysqli_set_charset($db, 'utf8mb4');

/*
  Tablas/campos esperados:
  - tbr_usuario: idusuario, usuario, id_sucursal, ip_permitida, condicion
  - tbr_sucursal: idsucursal, sucursal
*/

$sql = "
SELECT 
  u.idusuario,
  u.usuario,
  s.sucursal,
  COALESCE(u.ip_permitida,'') AS ip
FROM tbr_usuario u
LEFT JOIN tbr_sucursal s ON s.idsucursal = u.id_sucursal
WHERE COALESCE(u.condicion,1) = 1
ORDER BY u.usuario ASC
";

$res = $db->query($sql);
$data = [];
if ($res) {
  while ($row = $res->fetch_assoc()) {
    $data[] = [
      'idusuario' => (int)($row['idusuario'] ?? 0),
      'usuario'   => $row['usuario'] ?? '',
      'sucursal'  => $row['sucursal'] ?? '',
      'ip'        => $row['ip'] ?? ''
    ];
  }
  $res->free();
}

echo json_encode(['data'=>$data], JSON_UNESCAPED_UNICODE);
