<?php
session_start();
include("conex.php");

// Verificación de sesión
if (!isset($_SESSION['idusuario'])) {
    die(json_encode(["error" => "Sesión expirada."]));
}

$idusuario = mysqli_real_escape_string($conn, $_SESSION['idusuario']);

// Consulta segura con INNER JOIN
$sql = "SELECT s.idsuerte, c.cifras, s.suerte, s.valor, s.detalle, s.activar, su.sucursal, 
		s.id_sucursal, s.condicion, p.detalle as premio
        FROM tbr_suerte as s
        INNER JOIN tbr_sucursal AS su ON su.idsucursal = s.id_sucursal
		INNER JOIN tbr_cifras as c ON c.idcifras = s.id_cifras
		INNER JOIN tbr_premio as p ON p.idpremio = s.id_premio
        WHERE s.condicion = 1 AND su.condicion = 1 
        ORDER BY s.idsuerte;";

$consulta = mysqli_query($conn, $sql);

// Manejo de error en la consulta
if (!$consulta) {
    die(json_encode(["error" => "Error en la consulta: " . mysqli_error($conn)]));
}

// Si no hay resultados, devolver JSON vacío
if (mysqli_num_rows($consulta) == 0) {
    echo json_encode(["data" => []], JSON_UNESCAPED_UNICODE);
    exit;
}

$usuarios_data = [];
while ($row = mysqli_fetch_assoc($consulta)) {
    // Convertir el campo 'activo' en "SI" o "NO"
    $activo_texto = $row['activar'] == 1 ? "SI" : "NO";

    // Botón de activación/desactivación
    $boton_estado = '<label class="switch">
                        <input type="checkbox" class="toggle-switch" data-id="' . $row['idsuerte'] . '" ' . ($row['activar'] ? 'checked' : '') . ' data-estado="' . ($row['activar'] ? 1 : 0) . '">
                        <span class="slider round"></span>
                    </label>';
    
    // Acción eliminar
    $eliminar = '<button class="btn btn-danger toggle-condicion" 
                    data-id="' . $row['idsuerte'] . '"
                    data-condicion="' . $row['condicion'] . '">
                    <i class="fa fa-trash" aria-hidden="true"></i>
                </button>';

    // Botón de editar (corrección de sintaxis)
    $editar = '<button class="btn btn-warning toggle-editar" 
                    data-id="' . $row['idsuerte'] . '"                    
					data-loteria="' . $row['premio'] . '"
					data-suerte="' . $row['suerte'] . '"
                    data-valor="' . $row['valor'] . '"
                    data-detalle="' . $row['detalle'] . '"
                    data-sucursal="' . $row['id_sucursal'] . '">
                    <i class="fa fa-pencil" aria-hidden="true"></i>
                </button>';

    // Construir fila en JSON
    $usuarios_data[] = [
        
        "loteria"            => $row['premio'],
        "cifras"            => $row['cifras'],
        "suerte"            => $row['suerte'],
        "valor"             => $row['valor'],        
        "detalle"           => $row['detalle'],
        "sucursal"          => $row['sucursal'],        
        "activo"            => $boton_estado,            
        "accion"            => $editar.' '.$eliminar
    ];
}

// Enviar JSON limpio
echo json_encode(["data" => $usuarios_data], JSON_UNESCAPED_UNICODE);
?>
