<?php
session_start();
include("conex.php");

// Verificación de sesión
if (!isset($_SESSION['idusuario'])) {
    die(json_encode(["error" => "Sesión expirada."]));
}

$idusuario = mysqli_real_escape_string($conn, $_SESSION['idusuario']);
$rol = mysqli_real_escape_string($conn, $_SESSION['rol']);

// Consulta segura con INNER JOIN
if( $rol == 1)
{
	$sql = "SELECT s.idsucursal, s.sucursal, s.cupo, s.cupo_3c, s.cupo_4c, s.activo, s.condicion, s.imagen
			FROM tbr_sucursal AS s        
			WHERE s.condicion = 1";
}
if( $rol == 3)
{
	$sql = "SELECT s.idsucursal, s.sucursal, s.cupo, s.cupo_3c, s.cupo_4c, s.activo, s.condicion, s.imagen
			FROM tbr_sucursal AS s        
			WHERE s.condicion = 1 and id_usuario = '$idusuario'";
}
$consulta = mysqli_query($conn, $sql);

// Manejo de error en la consulta
if (!$consulta) {
    die(json_encode(["error" => "Error en la consulta: " . mysqli_error($conn)]));
}

// Si no hay resultados, devolver JSON vacío
if (mysqli_num_rows($consulta) == 0) {
    echo json_encode(["data" => []], JSON_UNESCAPED_UNICODE);
    exit;
}

$usuarios_data = [];
while ($row = mysqli_fetch_assoc($consulta)) {
    // Convertir el campo 'activo' en "SI" o "NO"
    $activo_texto = $row['activo'] == 1 ? "SI" : "NO";

    // Botón de activación/desactivación
    $boton_estado = '<label class="switch">
                        <input type="checkbox" class="toggle-switch" data-id="' . $row['idsucursal'] . '" ' . ($row['activo'] ? 'checked' : '') . ' data-estado="' . ($row['activo'] ? 1 : 0) . '">
                        <span class="slider round"></span>
                    </label>';

    // Acción eliminar
    $eliminar = '<button class="btn btn-danger toggle-condicion" 
                    data-id="' . $row['idsucursal'] . '"
                    data-condicion="' . $row['condicion'] . '">
                    <i class="fa fa-trash" aria-hidden="true"></i>
                </button>';

    $editar = '<button class="btn btn-warning toggle-editar" 
                data-id="' . $row['idsucursal'] . '"                
                data-sucursal="' . $row['sucursal'] . '"
                data-cupo="' . $row['cupo'] . '",               
				data-imagen="' . $row['imagen'] . '">
                <i class="fa fa-pencil" aria-hidden="true"></i>
            </button>';

    // Mostrar imagen (si existe)
    $imagen = !empty($row['imagen']) ? '<img src="' . $row['imagen'] . '" alt="Imagen Sucursal" width="50" height="50">' : 'Sin imagen';

    // Construir fila en JSON
    $usuarios_data[] = [        
        "sucursal"          => $row['sucursal'],
        "cupo"              => $row['cupo'],        
        "activo"            => $boton_estado,            
        "imagen"            => $imagen,  // Aquí se agrega la imagen
        "accion"            => $editar.' '.$eliminar
    ];
}

// Enviar JSON limpio
echo json_encode(["data" => $usuarios_data], JSON_UNESCAPED_UNICODE);
?>
