<?php
session_start();
include("conex.php");

// Verificación de sesión
if (!isset($_SESSION['idusuario'])) {
    die(json_encode(["error" => "Sesión expirada."]));
}

$idusuario = mysqli_real_escape_string($conn, $_SESSION['idusuario']);

// Consulta segura con INNER JOIN
				$sql = "SELECT 
					s.idsorteo,         
					s.fecha_g,          
					s.id_loteria,       
					l.loteria,          
					s.numero_g,         
					s.suerte_g,         
					s.condicion,        
					s.activo            
				FROM 
					tbr_sorteo as s
				INNER JOIN 
					tbr_loteria as l 
					ON l.idloteria = s.id_loteria  
				WHERE 
					s.condicion = 1  
					AND s.fecha_g >= CURDATE() - INTERVAL 15 DAY  -- Filtra los registros dentro de los últimos 15 días
				ORDER BY 
					s.fecha_g DESC;  -- Ordena por fecha descendente
				;";

$consulta = mysqli_query($conn, $sql);

// Manejo de error en la consulta
if (!$consulta) {
    die(json_encode(["error" => "Error en la consulta: " . mysqli_error($conn)]));
}

// Si no hay resultados, devolver JSON vacío
if (mysqli_num_rows($consulta) == 0) {
    echo json_encode(["data" => []], JSON_UNESCAPED_UNICODE);
    exit;
}

$usuarios_data = [];
while ($row = mysqli_fetch_assoc($consulta)) {
    // Convertir el campo 'activo' en "SI" o "NO"
    $activo_texto = $row['activo'] == 1 ? "SI" : "NO";

    // Botón de activación/desactivación
    $boton_estado = '<label class="switch">
                        <input type="checkbox" class="toggle-switch" data-id="' . $row['idsorteo'] . '" ' . ($row['activo'] ? 'checked' : '') . ' data-estado="' . ($row['activo'] ? 1 : 0) . '">
                        <span class="slider round"></span>
                    </label>';
    
    // Acción eliminar
    $eliminar = '<button class="btn btn-danger toggle-condicion" 
                    data-id="' . $row['idsorteo'] . '"
                    data-condicion="' . $row['condicion'] . '">
                    <i class="fa fa-trash" aria-hidden="true"></i>
                </button>';

    // Botón de editar (corrección de sintaxis)
    $editar = '<button class="btn btn-warning toggle-editar" 
                    data-id="' . $row['idsorteo'] . '"
                    data-fecha="' . $row['fecha_g'] . '"
                    data-suerte="' . $row['suerte_g'] . '"
                    data-numero="' . $row['numero_g'] . '"
                    data-loteria="' . $row['id_loteria'] . '">
                    <i class="fa fa-pencil" aria-hidden="true"></i>
                </button>';

    // Construir fila en JSON
    $usuarios_data[] = [
        
        "fecha"            => $row['fecha_g'],
        "suerte"           => $row['suerte_g'],        
        "numero"           => $row['numero_g'],
        "loteria"          => $row['loteria'],        
        "activo"           => $boton_estado,            
        "accion"           => $editar.' '.$eliminar
    ];
}

// Enviar JSON limpio
echo json_encode(["data" => $usuarios_data], JSON_UNESCAPED_UNICODE);
?>
