<?php
// funcion_sinjugar2c_ar.php
session_start();
include("conex.php");

// Verificar sesión
if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["data" => []]);
    exit;
}

// Sanitizar
$idusuario = mysqli_real_escape_string($conn, $_SESSION['idusuario']);
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d');

// Consulta: tickets de 2 cifras, Argentina, sin jugar (fecha futura)
$sql = "
    SELECT 
        t.idrifa, 
        t.codigo, 
        l.loteria, 
        t.numero, 
        t.fecha_impreso AS fechar, 
        t.hora_impreso,
        t.fecha AS fechaj,  
        t.valor, 
        su.sucursal, 
        u.usuario,
        t.condicion
    FROM tbr_ticket AS t
    INNER JOIN tbr_loteria   AS l   ON l.idloteria   = t.id_loteria
    INNER JOIN tbr_usuario   AS u   ON u.idusuario   = t.id_usuario
    INNER JOIN tbr_sucursal  AS su  ON su.idsucursal = u.id_sucursal
    WHERE t.id_usuario = '$idusuario'
      AND t.condicion = 1
      AND l.id_pais   = 2          -- ARGENTINA
	  AND l.id_premio = 2
      AND t.estado    >= 2         -- ya impresos / aprobados
      AND t.id_cifras = 1          -- dos cifras
      AND t.fecha_impreso = '$fecha_actual'
      AND t.fecha > '$fecha_actual' -- SIN JUGAR (fecha futura)
    ORDER BY t.idrifa DESC
";

$consulta = mysqli_query($conn, $sql);

$tabla = [];
if ($consulta) {
    while ($row = mysqli_fetch_assoc($consulta)) {
        $valor = (float)$row['valor'];

        $valor_formateado  = number_format($valor, 2, '.', ',');
        $numero_formateado = str_pad($row['numero'], 2, '0', STR_PAD_LEFT);

        $tabla[] = [
            "codigo"  => $row['codigo'],
            "loteria" => $row['loteria'],
            "numero"  => $numero_formateado,
            "fechar"  => $row['fechar'] . ' ' . $row['hora_impreso'],
            "fechaj"  => $row['fechaj'],
            "valor"   => $valor_formateado,
            "negocio" => $row['sucursal'],
            "usuario" => $row['usuario'],
            "pagar"   => $valor_formateado
        ];
    }
}

// Enviar JSON
echo json_encode(["data" => $tabla], JSON_UNESCAPED_UNICODE);
