<?php
session_start();
include("conex.php");

// Verificación de sesión
if (!isset($_SESSION['idusuario'])) {
    die(json_encode(["error" => "Sesión expirada."]));
}

$idusuario = mysqli_real_escape_string($conn, $_SESSION['idusuario']);
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d');

// Consulta segura con INNER JOIN
				$sql = "SELECT l.idloteria, l.loteria, l.fecha, l.dia, l.hora_inicio, l.hora_fin, l.activar, l.condicion					         
						FROM tbr_loteria AS l				
						WHERE l.condicion = 1 
						AND l.fecha >= '$fecha_actual'  -- Solo registros con fecha de hoy en adelante
						ORDER BY l.fecha ASC;";

$consulta = mysqli_query($conn, $sql);

// Manejo de error en la consulta
if (!$consulta) {
    die(json_encode(["error" => "Error en la consulta: " . mysqli_error($conn)]));
}

// Si no hay resultados, devolver JSON vacío
if (mysqli_num_rows($consulta) == 0) {
    echo json_encode(["data" => []], JSON_UNESCAPED_UNICODE);
    exit;
}

$usuarios_data = [];
while ($row = mysqli_fetch_assoc($consulta)) {
    $hora_inicio = !empty($row['hora_inicio']) ? substr($row['hora_inicio'], 0, 2) . ':' . substr($row['hora_inicio'], 2, 2) : "";
	$hora_fin = !empty($row['hora_fin']) ? substr($row['hora_fin'], 0, 2) . ':' . substr($row['hora_fin'], 2, 2) : "";

	
	// Convertir el campo 'activo' en "SI" o "NO"
    $activo_texto = $row['activar'] == 1 ? "SI" : "NO";
	
    // Botón de activación/desactivación
    $boton_estado = '<label class="switch">
                        <input type="checkbox" class="toggle-switch" data-id="' . $row['idloteria'] . '" ' . ($row['activar'] ? 'checked' : '') . ' data-estado="' . ($row['activar'] ? 1 : 0) . '">
                        <span class="slider round"></span>
                    </label>';
    
    // Acción eliminar
    $eliminar = '<button class="btn btn-danger toggle-condicion" 
                    data-id="' . $row['idloteria'] . '"
                    data-condicion="' . $row['condicion'] . '">
                    <i class="fa fa-trash" aria-hidden="true"></i>
                </button>';

    // Botón de editar (corrección de sintaxis)
    $editar = '<button class="btn btn-warning toggle-editar" 
                    data-id="' . $row['idloteria'] . '"
                    data-loteria="' . $row['loteria'] . '"
                    data-fecha="' . $row['fecha'] . '"
                    data-dia="' . $row['dia'] . '"                    
                    data-hora_i="' . $hora_inicio . '"
                    data-hora_f="' . $hora_fin . '">
                    <i class="fa fa-pencil" aria-hidden="true"></i>
                </button>';


    // Construir fila en JSON
		$usuarios_data[] = [
		"loteria"  => $row['loteria'],
		"fecha"    => $row['fecha'],        
		"dia"      => $row['dia'],
		"hora_i"   => $hora_inicio,        
		"hora_f"   => $hora_fin,        
		"activo"   => $boton_estado,            
		"accion"   => $editar . ' ' . $eliminar
	];
}

// Enviar JSON limpio
echo json_encode(["data" => $usuarios_data], JSON_UNESCAPED_UNICODE);
?>
