<?php
session_start();
include("conex.php");

// Verificar sesión
$idusuario  = $_SESSION['idusuario'] ?? '';
$usuario    = htmlspecialchars($_SESSION['usuario'] ?? '');
$sucursal_s = htmlspecialchars($_SESSION['sucursal'] ?? '');
$rol = mysqli_real_escape_string($conn, $_SESSION['rol']);

// Establecer zona horaria
date_default_timezone_set('America/Guayaquil');

// Validar y escapar datos de entrada
$f_usuario  = $_GET['usuario'] ?? '';
$f_sucursal = $_GET['sucursal'] ?? '';
$f_fecha_i  = $_GET['fecha_i'] ?? '';
$f_fecha_f  = $_GET['fecha_f'] ?? '';

if ($conn) { 
    $f_usuario  = mysqli_real_escape_string($conn, $f_usuario);
    $f_sucursal = mysqli_real_escape_string($conn, $f_sucursal);
    $f_fecha_i  = mysqli_real_escape_string($conn, $f_fecha_i);
    $f_fecha_f  = mysqli_real_escape_string($conn, $f_fecha_f);
} else {
    error_log("Error: Conexión a la base de datos fallida.");
    http_response_code(500);
    echo json_encode(["error" => "Error de conexión"], JSON_UNESCAPED_UNICODE);
    exit;
}

// Validar que las fechas sean correctas
if (!empty($f_fecha_i) && !empty($f_fecha_f)) {
    if (!strtotime($f_fecha_i) || !strtotime($f_fecha_f)) {
        error_log("Error: Fechas inválidas recibidas.");
        http_response_code(400);
        echo json_encode(["error" => "Formato de fecha inválido"], JSON_UNESCAPED_UNICODE);
        exit;
    }
}

// Construir la consulta
if( $rol == 1)
{
    $sql = "
        SELECT 
    	t.idrifa,
    	c.cifras,
    	t.codigo,
    	l.loteria,
    	t.numero,				
    	t.fecha AS fecha_impreso,
    	l.fecha AS fecha_ganador,
    	t.valor,
    	ts.premio,				
    	s.suerte_g,
    	suc.sucursal,
    	suc.idsucursal,
    	u.usuario				
    FROM tbr_sorteo AS s
    INNER JOIN tbr_ticket AS t 
    	ON (
    		(t.id_cifras = 1 AND t.numero = RIGHT(s.numero_g, 2)) OR
    		(t.id_cifras = 2 AND t.numero = RIGHT(s.numero_g, 3)) OR
    		(t.id_cifras = 3 AND t.numero = s.numero_g)
    	) 
    	AND t.fecha = s.fecha_g
    INNER JOIN tbr_cifras AS c ON c.idcifras = t.id_cifras
    INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
    INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket = t.idrifa    
    INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
    INNER JOIN tbr_sucursal AS suc ON suc.idsucursal = u.id_sucursal
    WHERE t.condicion = 1 
      AND t.estado = 2
      AND s.activo = 1
      AND s.condicion = 1					
      AND ts.id_suerte = s.suerte_g
      AND DATE(t.fecha) BETWEEN CURDATE() - INTERVAL 8 DAY AND CURDATE()";
}
if( $rol == 3)
{
	$sql = "
		SELECT 
		t.idrifa,
		c.cifras,
		t.codigo,
		l.loteria,
		t.numero,				
		t.fecha AS fecha_impreso,
		l.fecha AS fecha_ganador,
		t.valor,
		ts.premio,				
		s.suerte_g,
		suc.sucursal,
		suc.idsucursal,
		u.usuario				
	FROM tbr_sorteo AS s
	INNER JOIN tbr_ticket AS t 
		ON (
			(t.id_cifras = 1 AND t.numero = RIGHT(s.numero_g, 2)) OR
			(t.id_cifras = 2 AND t.numero = RIGHT(s.numero_g, 3)) OR
			(t.id_cifras = 3 AND t.numero = s.numero_g)
		) 
		AND t.fecha = s.fecha_g
	INNER JOIN tbr_cifras AS c ON c.idcifras = t.id_cifras
	INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
	INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket = t.idrifa    
	INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
	INNER JOIN tbr_sucursal AS suc ON suc.idsucursal = u.id_sucursal
	WHERE t.condicion = 1 
	  AND t.estado = 2
	  AND s.activo = 1
	  AND s.condicion = 1					
	  AND ts.id_suerte = s.suerte_g
	  AND u.id_administrador = '$idusuario'
	  AND DATE(t.fecha) BETWEEN CURDATE() - INTERVAL 8 DAY AND CURDATE()";
}
// Agregar filtros
if (!empty($f_usuario)) {
    $sql .= " AND u.idusuario = '$f_usuario'";
}

if (!empty($f_sucursal)) {
    $sql .= " AND suc.idsucursal = '$f_sucursal'";
}

if (!empty($f_fecha_i) && !empty($f_fecha_f)) {
    $sql .= " AND t.fecha_impreso BETWEEN '$f_fecha_i' AND '$f_fecha_f'";
}


// Registrar la consulta para depuración
error_log("Consulta SQL: " . $sql);

// Ejecutar la consulta
$consulta = mysqli_query($conn, $sql);

if (!$consulta) {
    error_log("Error en la consulta: " . mysqli_error($conn));
    http_response_code(500);
    echo json_encode(["error" => "Error en la consulta"], JSON_UNESCAPED_UNICODE);
    exit;
}

// Procesar los resultados
$tabla = [];
while ($row = mysqli_fetch_assoc($consulta)) {
    $tabla[] = [
        "cifras"     => $row['cifras'],
        "sucursal"   => $row['sucursal'],
        "usuario"    => $row['usuario'],
        "fechai"     => $row['fecha_impreso'],
        "fechaj"     => $row['fecha_ganador'],
        "vendido"    => number_format($row['valor'], 2, '.', ''),
        "ganado"     => number_format($row['premio'], 2, '.', '')		
    ];
}

// Cerrar la conexión
mysqli_close($conn);

// Enviar respuesta JSON
header('Content-Type: application/json; charset=utf-8');
echo json_encode(["data" => $tabla], JSON_UNESCAPED_UNICODE);
?>
