<?php
session_start();
include("conex.php");
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('America/Guayaquil');

// Obtener datos de sesión
$idusuario  = (int) ($_SESSION['idusuario'] ?? 0);
$rol        = (int) ($_SESSION['rol'] ?? 0);

// Filtros desde AJAX
$fecha_inicio = !empty($_POST['fecha_inicio']) ? date('Y-m-d', strtotime($_POST['fecha_inicio'])) : '';
$fecha_fin    = !empty($_POST['fecha_fin']) ? date('Y-m-d', strtotime($_POST['fecha_fin'])) : '';
$sucursal_f   = mysqli_real_escape_string($conn, $_POST['sucursal'] ?? '');
$usuario_f    = mysqli_real_escape_string($conn, $_POST['usuario_s'] ?? '');

// Inicializar totales
$total = $totalp = $totalTope1 = $totalTope2 = 0;

// Consulta base
$sql = "
    SELECT 
        t.idrifa, c.cifras,
        t.codigo, t.`key`, t.numero AS numero_ganador,
        t.valor, ts.premio, t.tope1, t.tope2,
        l.loteria, su.suerte, t.estado, t.fecha,
        u.usuario, suc.sucursal
    FROM tbr_sorteo s
    INNER JOIN tbr_ticket t ON (
        (
            (t.id_cifras = 1 AND RIGHT(t.numero, 2) = RIGHT(s.numero_g, 2)) OR 
            (t.id_cifras = 2 AND RIGHT(t.numero, 3) = RIGHT(s.numero_g, 3)) OR 
            (t.id_cifras = 3 AND t.numero = s.numero_g)
        )
        AND t.fecha = s.fecha_g
    )
    INNER JOIN tbr_cifras c ON c.idcifras = t.id_cifras
    INNER JOIN tbr_loteria l ON l.idloteria = t.id_loteria
    INNER JOIN tbr_ticket_suerte ts ON ts.id_ticket = t.idrifa AND ts.id_suerte = s.suerte_g
    INNER JOIN tbr_suerte su ON su.idsuerte = s.suerte_g
    INNER JOIN tbr_usuario u ON u.idusuario = t.id_usuario
    INNER JOIN tbr_sucursal suc ON suc.idsucursal = u.id_sucursal
    WHERE t.condicion = 1 
      AND t.estado = 2 
      AND s.activo = 1 
      AND s.condicion = 1
      AND DATEDIFF(CURDATE(), t.fecha) > 8
";

// Rol: administrador
if ($rol === 3) {
    $sql .= " AND u.id_administrador = '$idusuario'";
}

// Filtros adicionales
if (!empty($sucursal_f) && $sucursal_f !== 'Seleccionar una sucursal') {
    $sql .= " AND suc.idsucursal = '$sucursal_f'";
}
if (!empty($usuario_f) && $usuario_f !== 'Seleccione un usuario') {
    $sql .= " AND u.idusuario = '$usuario_f'";
}
if (!empty($fecha_inicio) && !empty($fecha_fin)) {
    $sql .= " AND t.fecha BETWEEN '$fecha_inicio' AND '$fecha_fin'";
}

$sql .= " ORDER BY t.idrifa DESC";

// Ejecutar la consulta
$result = mysqli_query($conn, $sql);
if (!$result) {
    echo json_encode([
        "data" => [],
        "total" => "0.00",
        "totalp" => "0.00",
        "totalTope1" => "0.00",
        "totalTope2" => "0.00"
    ]);
    exit;
}

// Procesar resultados
$data = [];
while ($row = mysqli_fetch_assoc($result)) {
    $valor  = (float) $row['valor'];
    $premio = (float) $row['premio'];
    $tope1  = (float) $row['tope1'];
    $tope2  = (float) $row['tope2'];

    $pago_tope1 = ($valor > 0) ? ($premio * ($tope1 / $valor)) : 0;
    $pago_tope2 = ($valor > 0) ? ($premio * ($tope2 / $valor)) : 0;

    $total      += $valor;
    $totalp     += $premio;
    $totalTope1 += $pago_tope1;
    $totalTope2 += $pago_tope2;

    $fecha_ganador = new DateTime($row['fecha']);
    $dias_vencidos = (new DateTime())->diff($fecha_ganador)->days;

    $data[] = [
        "cifras"  => $row['cifras'],
        "codigo"  => $row['codigo'],
        "key"     => $row['key'],
        "fecha"   => $row['fecha'],
        "loteria" => $row['loteria'],
        "suerte"  => $row['suerte'],
        "numero"  => str_pad($row['numero_ganador'], 2, '0', STR_PAD_LEFT),
        "valor"   => number_format($valor, 2, '.', ','),
        "pagar"   => number_format($premio, 2, '.', ','),
        "negocio" => $row['sucursal'],
        "usuario" => $row['usuario'],
        "tope1"   => number_format($pago_tope1, 2, '.', ','),
        "tope2"   => number_format($pago_tope2, 2, '.', ','),
        "estado"  => "Caducado ({$dias_vencidos} días)"
    ];
}

// Respuesta JSON
echo json_encode([
    "data"       => $data,
    "total"      => number_format($total, 2, '.', ','),
    "totalp"     => number_format($totalp, 2, '.', ','),
    "totalTope1" => number_format($totalTope1, 2, '.', ','),
    "totalTope2" => number_format($totalTope2, 2, '.', ',')
], JSON_UNESCAPED_UNICODE);
?>
