<?php
session_start();

if (!isset($_SESSION['idusuario'])) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['data' => [], 'error' => 'Sesin no vlida'], JSON_UNESCAPED_UNICODE);
    exit;
}

$idusuario = (int)($_SESSION['idusuario'] ?? 0);
$usuario   = $_SESSION['usuario']  ?? '';
$sucursal  = $_SESSION['sucursal'] ?? '';

require_once 'conex.php';

// Asegurar UTF-8 real y zona horaria de sesin SQL (opcional)
if (isset($conn) && $conn instanceof mysqli) {
    mysqli_set_charset($conn, 'utf8mb4');
    @mysqli_query($conn, "SET time_zone = '-05:00'"); // America/Guayaquil
}

header('Content-Type: application/json; charset=utf-8');

// Total numrico
$total = 0.0;

// Consulta (4 cifras: RIGHT(..., 4) y t.id_cifras = 3)
$sql = "
SELECT 
    t.idrifa, 
    t.codigo, 
    t.numero, 
    t.valor, 
    t.fecha AS fechar,  
    p.fecha,
    l.loteria,
    l.fecha AS fechaj,
    ts.premio,
    suc.sucursal,
    u.usuario,
    s.suerte_g
FROM tbr_ticket AS t
INNER JOIN tbr_pago AS p ON p.id_ticket = t.idrifa
INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
INNER JOIN tbr_sorteo AS s ON RIGHT(s.numero_g, 4) = t.numero AND t.fecha = s.fecha_g
INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket = t.idrifa  
INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
INNER JOIN tbr_sucursal AS suc ON suc.idsucursal = u.id_sucursal
WHERE t.condicion = 1 
  AND l.id_pais = 1
  AND l.id_premio = 1
  AND t.estado = 3 
  AND t.id_usuario = $idusuario
  AND t.id_cifras = 3
  AND ts.id_suerte = s.suerte_g
GROUP BY 
    t.idrifa, t.codigo, t.numero, t.valor, t.fecha, 
    p.fecha, l.loteria, l.fecha, ts.premio, 
    suc.sucursal, u.usuario, s.suerte_g;
";

$consulta = mysqli_query($conn, $sql);

if (!$consulta) {
    echo json_encode([
        'data'  => [],
        'error' => 'Error en la consulta: ' . mysqli_error($conn)
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

$data = [];

while ($row = mysqli_fetch_assoc($consulta)) {
    // Nmeros puros
    $valor  = (float)$row['valor'];
    $premio = (float)$row['premio'];

    // Formatos para la salida
    $valor_formateado  = number_format($valor, 2, '.', ',');
    $premio_formateado = number_format($premio, 2, '.', ',');

    // Para 3 cifras ? pad a 3
    $numero_formateado = str_pad((string)$row['numero'], 3, '0', STR_PAD_LEFT);

    // Acumular total numrico
    $total += $valor;

    $data[] = [
        'codigo'    => $row['codigo'],
        'loteria'   => $row['loteria'],
        'numero'    => $numero_formateado,
        'fechar'    => $row['fechar'],  // t.fecha
        'fechaj'    => $row['fechaj'],  // l.fecha
        'valor'     => $valor_formateado,
        'negocio'   => $row['sucursal'],
        'usuario'   => $row['usuario'],
        'porcentaje'=> '0.00',          // literal
        'pagar'     => $premio_formateado
    ];
}

// Respuesta JSON
echo json_encode([
    'data'  => $data,
    // Si tu DataTable no usa 'total', puedes quitar esta lnea
    'total' => number_format($total, 2, '.', ',')
], JSON_UNESCAPED_UNICODE);
